package com.ibm.ulc.ui.dataTypes;

/**
 * Defines the interaction between UIFields and Data types
 */
import javax.swing.text.AttributeSet;
public interface IDataType {
/**
 * Convert a String into the object represented by this DataType.
 * If the String cannot be converted the implementation has to
 * throw the DataTypeConversionException exception.
 * The return value null is a legal value!
 *
 * @param phase int	The current validation phase.
 * The phase can be one of the following:
 * <pre>
 *	FORM_NOTIFICATION_IMMEDIATE : Typically no validation is performed in this case the input string is returned as is.
 *	FORM_NOTIFICATION_ON_FOCUS_CHANGE 	 
 * 	FORM_NOTIFICATION_ON_REQUEST
 *	</pre>
 * @param newString The String to convert.
 * @return An object representing the converted String or null.
 *
 */
public Object convertToObject(int phase, String newString, Object previousValue) throws DataTypeConversionException;
/**
 * Convert an object into a String. The boolean flag
 * determines whether the string is used for editing (the field has the focus)
 * or for displaying. In the first case the String representation should be easy
 * to edit and shouldn't include any fancy formatting.
 *
 * @param object Object to convert.
 * @param forEditing True if string is used for editing.
 */
public String convertToString(Object object, boolean forEditing);
/**
 * Hook to filter any text input into the field.
 *
 * @param position		The location where the input is being inserted 
 * @param newString 	The string to filter.
 * @param currentText 	The current Contents.
 * @param attribute		The attributes of the text being inserted
 *
 * @return the filtered result, If null input is not accepted.
 * @see IDataType#filterInput(String, String)
 */
public String filterInput(int position, String newString, String currentText, AttributeSet attribute);
/**
 * Hook to filter any text input into the field.
 *
 * @param newString The string to filter.
 * @return the filtered result, If null input is not accepted.
 */
public String filterInput(String newString);
/**
 * Hook to filter any text input into the field.
 *
 * @param newString The string to filter.
 * @param oldText The current Contents.
 * @return the filtered result, If null input is not accepted.
 */
public String filterInput(String newString, String oldText);
/**
 * Returns the default width (in characters) used to determine the size of a field
 * or table and list column of this DataType. Can be overidden by giving the field an
 * explicit size.
 */
public int getCols();
/**
 * Returns the default object to be returned when a data conversion error occurs.
 */
Object getDefaultValue(String newString);
}
