package com.ibm.ulc.ui.dataTypes;

/**
 * Insert the type's description here.
 * Creation date: (23-Nov-99 11:15:47 AM)
 * @author: Markus Marzetta (CS-ZRH)
 */
import java.text.NumberFormat;
import java.text.ParseException;

public class UINumberFormatConverter implements IStringConverter {

	/**
	 * The format object that actually does the work
	 */
	protected NumberFormat fFormat = null;
	
/**
 * UINumberFormatConverter constructor comment.
 */
public UINumberFormatConverter() {
	super();
	fFormat = NumberFormat.getInstance();
}
/**
 * Answer a String  representation of the parameter suitable for editing
 * (e.g. increased precision).
 */
public String convertToEditString(Object object) {
	return fFormat.format(object);
}
/**
 * convertToObject method comment.
 */
public Object convertToObject(String string) throws DataTypeConversionException {
	try {
		return fFormat.parseObject(string);
	} catch (ParseException e) {
		throw new DataTypeConversionException(e.getMessage());
	}
}
/**
 * convertToString method comment.
 */
public String convertToString(Object object) {
	return fFormat.format(object);
}
/**
 * Answer an instance suitable for int, if isInteger == true,
 * for double, otherwise
 *
 * Creation date: (23-Nov-99 5:43:33 PM)
 * @return com.ibm.ulc.ui.dataTypes.UINumberFormatConverter
 * @param isInteger boolean
 */

public static UINumberFormatConverter getInstance(boolean isInteger) {
	if (isInteger) {
		return new UIIntegerNumberFormatConverter();
	} else {
		return new UIDoubleNumberFormatConverter();
	}
}
/**
 * Set whether or not grouping will be used in this format.
 * (see NumberFormat)
 *
 * Creation date: (23-Nov-99 2:49:09 PM)
 * @param useGrouping boolean
 */
public void setGroupingUsed(boolean useGrouping) {
	fFormat.setGroupingUsed(useGrouping);
}
/**
 * Sets the maximum number of digits allowed in the fraction portion of a
 * number. maximumFractionDigits must be >= minimumFractionDigits.
 * (see NumberFormat)
 *
 * Creation date: (23-Nov-99 2:49:09 PM)
 * @param newValue int
 */
public void setMaximumFractionDigits(int newValue) {
	fFormat.setMaximumFractionDigits(newValue);
}
/**
 * Sets the minimum number of digits allowed in the fraction portion of a
 * number. minimumFractionDigits must be <= maximumFractionDigits.
 * (see NumberFormat)
 *
 * Creation date: (23-Nov-99 2:49:09 PM)
 * @param newValue int
 */
public void setMinimumFractionDigits(int newValue) {
	fFormat.setMinimumFractionDigits(newValue);
}
}
