package com.ibm.ulc.ui.dataTypes;

public class UIRangeConverter implements IStringConverter {

	/**
	 * The smallest allowed as a Double
	 */
	protected Integer fIntegerMin = null;
	/**
	 * The largest allowed value as a Double
	 */
	protected Integer fIntegerMax = null;

	/**
	 * The largest allowed as a Double
	 */
	protected Double fDoubleMax = null;
	/**
	 * The smallest allowed value as a Double
	 */
	protected Double fDoubleMin = null;

	/**
	 * The guy who really does the work
	 */
	protected IStringConverter fConverter = null;
/**
 * Should not be used.
 */
public UIRangeConverter() {
	super();
}
/**
 * Construct a range converter wrapping converter.
 */
public UIRangeConverter(IStringConverter converter) {
	super();
	fConverter = converter;
}
/**
 * convertToString method comment.
 */
public String convertToEditString(Object object) {
	return fConverter.convertToEditString(object);
}
/**
 * convertToObject method comment.
 */
public Object convertToObject(String string) throws DataTypeConversionException {
	Object object = fConverter.convertToObject(string);
	if (object instanceof Integer) {
		Integer compObject = (Integer) object;
		if (fIntegerMin != null && (fIntegerMin.intValue() > compObject.intValue())) {
			throw new DataTypeConversionException("range error: value too small");
		}
		if (fIntegerMax != null && (fIntegerMax.intValue() < compObject.intValue())) {
			throw new DataTypeConversionException("range error: value too big");
		}
		return object;
	}
	if (object instanceof Double) {
		Double compObject = (Double) object;
		if (fDoubleMin != null && (fDoubleMin.doubleValue() > compObject.doubleValue())) {
			throw new DataTypeConversionException("range error: value too small");
		}
		if (fDoubleMax != null && (fDoubleMax.doubleValue() < compObject.doubleValue())) {
			throw new DataTypeConversionException("range error: value too big");
		}
		return object;
	}
	return null;
}
/**
 * convertToString method comment.
 */
public String convertToString(Object object) {
	return fConverter.convertToString(object);
}
public void setMax(Object max) {
	if (max instanceof Integer) {
		fIntegerMax = (Integer)max;
		fDoubleMax= new Double(((Integer)max).intValue());
		}
	if (max instanceof Double) {
		fDoubleMax= (Double)max;
		fIntegerMax = new Integer(((Double)max).intValue());
		}
}
public void setMin(Object min) {
	if (min instanceof Integer) {
		fIntegerMin = (Integer) min;
		fDoubleMin = new Double(((Integer) min).intValue());
	}
	if (min instanceof Double) {
		fDoubleMin = (Double) min;
		fIntegerMin = new Integer(((Double) min).intValue());
	}
}
}
