package com.ibm.ulc.ui.dataTypes;

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.UIFormComponent;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 *
 * This class is used for ensuring that the input to a text field
 * lies within the specified minimum and maximum values.
 */
public class UIRangeValidator extends UIDataType {
	/**
	 * The minimum value allowed for this Validator. Default is 0.0
	 * @serial	 
	 */
	protected double fMin = 0.0;
	/**
	 * The maximum value allowed for this Validator. Default is 100.0
	 * @serial	 
	 */
	protected double fMax = 100.0;
	/**
	 * The boolean when true converts the returned value to an integer. Default is false.
	 * @serial	 
	 */
	protected boolean fIntValue = false;
	/**
	 * Allowed input characters
	 * @serial	 
	 */
	protected static String validChars = "E0123456789.- ";
public UIRangeValidator() {
}
/**
 * Check if the input string conforms to the range specified. Throw an exception on error.
 *
 * @param phase int	The current validation phase.
 * The phase can be one of the following:
 * <pre>
 *	FORM_NOTIFICATION_IMMEADIATE : Typically no validation is performed in this case the input string is returned as is.
 *	FORM_NOTIFICATION_ON_FOCUS_CHANGE 	 
 * 	FORM_NOTIFICATION_ON_REQUEST
 *	</pre>
 * @param newString The String to convert.
 * @return An object representing the converted String or null.
 *
 * @see IDataType#convertToObject(int, String, Object)
 */

public Object convertToObject(int phase, String newString, Object previousValue) throws DataTypeConversionException {
	if (phase == FORM_NOTIFICATION_IMMEDIATE)
		return newString; // no checking
	if (newString != null && newString.length() > 0) {
		try {
			Double d = Double.valueOf(newString);
			if (d.doubleValue() < fMin) {
				if (fIntValue)
					throw new DataTypeConversionException("range error", new Integer((new Double(fMin)).intValue()));
				else
					throw new DataTypeConversionException("range error", new Double(fMin));
			}
			if (d.doubleValue() > fMax) {
				if (fIntValue)
					throw new DataTypeConversionException("range error", new Integer((new Double(fMax)).intValue()));
				else
					throw new DataTypeConversionException("range error", new Double(fMax));
			}
			if (fIntValue)
				return new Integer(d.intValue());
			else
				return d;
		} catch (NumberFormatException e) {
			throw new DataTypeConversionException("format error", previousValue);
		}
	}
	return null;
}
/**
 * Return the String represenation of the object or the empty string if object is null.
 * The default implementation calls the toString() to return a string representation of the object.
 * Subclasses should override this method to return the formatted data type as a String.
 *
 * @see IDataType#convertToString(Object, boolean)
 */
public String convertToString(Object object, boolean forEditing) {
	if (object == null)
		return "";
	if (!forEditing) {
		Object value = null;
		try {
			value = convertToObject(FORM_NOTIFICATION_ON_FOCUS_CHANGE, object.toString(), null);
		} catch (DataTypeConversionException e) {
			return "";
		}
		if (value == null)
			return "";
		else
			return value.toString();
	} else
		return object.toString();
}
/**
 * The default implementation returns original string without modification.
 *
 * @see IDataType#filterInput(String)
 */
public String filterInput(String newString) {
	if (hasValidCharacters(newString))
		return newString;
	return null;
}
/**
 * Ensure that the given string has no invalid characters.
 *
 * @see IDataType#filterInput(String)
 */
public boolean hasValidCharacters(String s) {
	for (int i = 0; i < s.length(); i++)
		if (validChars.indexOf(s.charAt(i)) < 0)
			return false;
	return true;
}
public Double parse(String s) {
	return null;
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	fMin = args.get("min", 0.0);
	fMax = args.get("max", 100.0);
	fIntValue = args.get("iv", false);
}
}
