package com.ibm.ulc.ui.io;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */
import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import java.awt.*;
import java.util.*;
import java.io.*;
/**
 * The UIFile class implements the ULC protocol to allow client side file 
 * access to the ULC server application.
 */
public class UIFile extends com.ibm.ulc.ui.UIProxy {
	private File fFile = null;
public UIFile() {
}
	public void handleRequest(ORBConnection conn, String request, Anything args) {
		Anything reply=null;
  		if (request.equals("construct")) {
			if (args.isDefined("path")) {
			    fFile= new File(args.get("path",""),args.get("name",""));
			} else {
			    fFile=new File(args.get("name",""));
			}

			reply=new Anything();
			reply.put("separator",File.separator);
			reply.put("separatorChar",File.separatorChar);
			reply.put("pathSeparator",File.pathSeparator);
			reply.put("pathSeparatorChar",File.pathSeparatorChar);
			reply.put("lineSeparator", System.getProperty("line.separator"));
  		} else if (request.equals("getName")) {
			reply = new Anything(fFile.getName());
  		} else if (request.equals("getPath")) {
			reply = new Anything(fFile.getPath());
  		} else if (request.equals("getAbsolutePath")) {
			reply = new Anything(fFile.getAbsolutePath());
  		} else if (request.equals("getCanonicalPath")) {
  		    try {
				reply = new Anything(fFile.getCanonicalPath());
			} catch (IOException ioe) {
			    reply = new Anything();
			    reply.put("exception", ioe);
			}
  		} else if (request.equals("getParent")) {
			reply = new Anything(fFile.getParent());
  		} else if (request.equals("exists")) {
			reply = new Anything(fFile.exists());
  		} else if (request.equals("canWrite")) {
			reply = new Anything(fFile.canWrite());
  		} else if (request.equals("canRead")) {
			reply = new Anything(fFile.canRead());
  		} else if (request.equals("isFile")) {
			reply = new Anything(fFile.isFile());
  		} else if (request.equals("isDirectory")) {
			reply = new Anything(fFile.isDirectory());
  		} else if (request.equals("isAbsolute")) {
			reply = new Anything(fFile.isAbsolute());
  		} else if (request.equals("lastModified")) {
			reply = new Anything(fFile.lastModified());
  		} else if (request.equals("length")) {
			reply = new Anything(fFile.length());
  		} else if (request.equals("mkdir")) {
			reply = new Anything(fFile.mkdir());
  		} else if (request.equals("renameTo")) {
			reply = new Anything(fFile.renameTo(new File(args.get("arg1",""))));
  		} else if (request.equals("mkdirs")) {
			reply = new Anything(fFile.mkdirs());
  		} else if (request.equals("list")) {
			reply = new Anything(fFile.list());
  		} else if (request.equals("list_with_filter")) {
			reply = new Anything(fFile.list((UlcFileFilter)args.get("arg1",(Serializable)null)));
  		} else if (request.equals("delete")) {
			reply = new Anything(fFile.delete());
 		} else {
			super.handleRequest(conn, request, args);
			return;
		}
	    sendULC("reply", reply);		
	}
}
