package com.ibm.ulc.ui.io;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */

import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import java.io.*;
public class UIFileInputStream extends com.ibm.ulc.ui.UIProxy {
	private FileInputStream fStream = null;
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("construct")) {
		try {
			fStream = new FileInputStream(args.asString(""));
			sendULC("reply", new Anything("success"));
		} catch (FileNotFoundException e) {
			Anything reply = new Anything();
			reply.put("exception", e);
			sendULC("reply", reply);
		}
	} else
		if (request.equals("read")) {
			try {
				sendULC("reply", new Anything(fStream.read()));
			} catch (IOException e) {
				Anything reply = new Anything();
				reply.put("exception", e);
				sendULC("reply", reply);
			}
		} else
			if (request.equals("readBytes")) {
				try {
					int size = fStream.available();
					if (size > args.asInt(0))
						size = args.asInt(0);
					if ((size == 0) && (fStream.read() == -1)) {
						sendULC("reply", new Anything(-1));
						return;
					}
					byte buf[] = new byte[size];
					if (fStream.read(buf) == -1) {
						sendULC("reply", new Anything(-1));
					} else
						sendULC("reply", new Anything(buf));
				} catch (IOException e) {
					System.out.println(e);
					Anything reply = new Anything();
					reply.put("exception", e);
					sendULC("reply", reply);
				}
			} else
				if (request.equals("close")) {
					try {
						fStream.close();
						sendULC("reply", new Anything("success"));
					} catch (IOException e) {
						Anything reply = new Anything();
						reply.put("exception", e);
						sendULC("reply", reply);
					}
				} else
					super.handleRequest(conn, request, args);
}
}
