package com.ibm.ulc.ui.io;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */

import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import java.io.*;
public class UIFileOutputStream extends com.ibm.ulc.ui.UIProxy {
	private FileOutputStream fStream = null;
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("construct")) {
		try {
			fStream = new FileOutputStream(args.get("name").asString(""), args.get("append").asBoolean(true));
			sendULC("reply", new Anything("success"));
		} catch (IOException e) {
			Anything reply = new Anything();
			reply.put("exception", e);
			sendULC("reply", reply);
		}
	} else
		if (request.equals("write")) {
			try {
				fStream.write(args.asInt(-1));
				sendULC("reply", new Anything("success"));
			} catch (IOException e) {
				Anything reply = new Anything();
				reply.put("exception", e);
				sendULC("reply", reply);
			}
		} else
			if (request.equals("writeBytes")) {
				try {
					fStream.write(args.asBytes());
					fStream.flush();
					sendULC("reply", new Anything("success"));
				} catch (IOException e) {
					Anything reply = new Anything();
					reply.put("exception", e);
					sendULC("reply", reply);
				}
			} else
				if (request.equals("close")) {
					try {
						fStream.close();
						sendULC("reply", new Anything("success"));
					} catch (IOException e) {
						Anything reply = new Anything();
						reply.put("exception", e);
						sendULC("reply", reply);
					}
				} else
					super.handleRequest(conn, request, args);
}
}
