package com.ibm.ulc.ui.lists;

/**
 * this interface defines the protocol for a row object in a <code>TableModel</code>
 */
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcHashtable;
public interface IRow {
/**
 * answer the receiver's object identifier (oid)
 */
public IRow asNonPendingRow(UiItemCache cache, int oid);
public void cancelInput(UiItemCache cache);
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public void changedAttributes(String[] attributeNames);
/**
 * answer the value of the receiver's attribute called attributeName. Answer an instance of InvalidCell if the value is not already known
 *
 * @param attributeName		the attribute requested is named this
 */
public Object getExistingValueAt(String attributeName, UiItemCache cache);
/**
 * answer the receiver's object identifier (oid)
 */
public int getOid();
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer a PendingCell, if the attribute is not defined but has been requested from ULC.
 * Answer an InvalidCell, if the attribute is not defined and cannot be requested from ULC.
 *
 * @param attributeName		the attribute requested is named this
 */
public Object getValueAt(String attributeName, UiItemCache cache);
public boolean hasUnsavedChanges();
/**
 * answer true, if the receiver's value for @atttributeName is equal to value
 *
 */
public boolean isValue(String attributeName, Object value);
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void prepareChanges(UITableModel model, Anything rowIds, Anything changes);
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void resetValues(String[] attributeNames);
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void resetValues(UiItemCache cache);
public void saveInput(UiItemCache cache);
/**
 * Set the data directly without trashing the edit cache.
 */
public abstract void setData(UITableModel tableModel, Anything attributeName, Anything attributeValues);
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public boolean setInput(UiItemCache cache, String attributeName, Object value);
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public void setValue(UiItemCache cache, String attributeName, Object value);
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void startEditing(UiItemCache cache);
/**
 * answer the receiver's object identifier (oid)
 */
public void updateData(UiItemCache cache, UlcHashtable table);
}
