package com.ibm.ulc.ui.lists;

import com.ibm.ulc.util.UlcObject;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import javax.swing.AbstractAction;
import javax.swing.Icon;

/**
 * Instances of subclasses of this class handle the keystrokes in a table cell.
 * To this extent they add the suitable callbacks to the text field,
 * and provide routines to handle them.
 */
public abstract class UICellEditorKeyPolicy extends UlcObject {

	// The whole table widget
	protected UiJTable fTableComponent;

	// Dummy index
	static final int INVALID_INDEX = -1;
/** 
 * Initialize the instance to have its fTableComponent field pointing at table.
 */

UICellEditorKeyPolicy(UiJTable table) {
	fTableComponent= table;
}
/**
 * Edit the cell at position point
 */
void editCellAtPoint(Point point) {
	UiJTable table = getTableComponent();
//?	// fKeyPolicy.fCellEditor.stopCellEditing();
	if (point != null) {
		table.ensureIndexIsVisible(point.y);
		table.editCellAt(point.y, point.x);
//?		// table.setRowSelectionInterval(point.y, point.y);
	}
}
/**
 * Answer the table component the receiver is working on.
 * Once a reference is got, cache it in the fTableComponent instance variable.
 * @return UiJTable
 */
protected UiJTable getTableComponent() {
	return fTableComponent;
}
/**
 * Answer the index of the column of the next editable cell in row row
 * starting from col and searching to the left.
 */
protected int nextEditableColumnLeft(int col, int numCols, int row) {
	int c= col-1;
	for (int i=0; i<numCols; i++) {
		if (c<0) c= numCols-1;
		if (getTableComponent().ulcIsCellEditable(row, c)) {
			return c;
		}
		c--;
	}
	return INVALID_INDEX;
}
/**
 * Answer the index of the column of the next editable cell in row row
 * starting from col and searching to the right.
 */
protected int nextEditableColumnRight(int col, int numCols, int row) {
	int c= col+1;
	for (int i=0; i<numCols; i++) {
		if (c>=numCols) c= 0;
		if (getTableComponent().ulcIsCellEditable(row, c)) {
			return c;
		}
		c++;
	}
	return INVALID_INDEX;
}
/**
 * Answer the index of the row of the next editable cell in column col 
 * starting from row and searching downwards.
 */
protected int nextEditableRowDown(int row, int numRows, int col) {
	int r = row+1;
	for (int i=0; i<numRows; i++) {
		if (r>=numRows) r= 0;
		if (getTableComponent().ulcIsCellEditable(r, col)) {
			return r;
		}
		r++;
	}
	return INVALID_INDEX;
}
/**
 * Answer the index of the row of the next editable cell in column col 
 * starting from row and searching upwards.
 */
protected int nextEditableRowUp(int row, int numRows, int col) {
	int r= row-1;
	for (int i=0; i<numRows; i++) {
		if (r<0) r= numRows-1;
		if (getTableComponent().ulcIsCellEditable(r, col)) {
			return r;
		}
		r++;
	}
	return INVALID_INDEX;
}
/**
 * Answer the next editable point searching down and starting at the currently edited cell.
 */
abstract Point nextEditPointDown(int row, int numRows, int col, int numCols);
/**
 * Answer the next editable point searching to the left and starting at the currently edited cell.
 */
abstract Point nextEditPointLeft(int row, int numRows, int col, int numCols);
/**
 * Answer the next editable point searching to the left and starting at the currently edited cell.
 */
abstract Point nextEditPointRight(int row, int numRows, int col, int numCols);
/**
 * Answer the next editable point searching up and starting at the currently edited cell.
 */
abstract Point nextEditPointUp(int row, int numRows, int col, int numCols);
}
