package com.ibm.ulc.ui.lists;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.dataTypes.*;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 *
 * This is the column widget used in tables and treeTables. It 
 * wraps the swing TableColumn widget, and supports different 
 * renderers and validators.
 *
 */

public class UIColumn extends UIComponent {
	protected UiTableColumn fTableColumn = null;
	protected IDataType fDataType = null;
	protected UIFont fFont= null;
	protected UIComponent fRenderer= null;
	protected UILabel fHeaderRenderer= null;

/**
 * Configure the text field given in the parameter for editing cells in the receiver.
 *
 * Warning: we rely on the (documented) fact that JTextComponent.addKeymap(...)
 * answers a NEW Keymap object.
 *
 * Creation date: (20/10/1999 16:41:45)
 * @param textField javax.swing.text.JTextComponent
 */
public void configureForTableEditing(JTextComponent textField) {
	final UICellEditorKeyPolicy policy = new UICellEditorClosedSpiralsKeyPolicy(null) {
		protected UiJTable getTableComponent() {
			return (UiJTable) getTable().getBasicComponent();
		}
	};
	Keymap newKm = JTextComponent.addKeymap(null, textField.getKeymap());
	Object[] keyStrokesAndActions = UiJTable.editingKeyStrokesAndActionsFor(policy);
	for (int i = 0; i <= keyStrokesAndActions.length - 2; i += 2) {
		KeyStroke ks = (KeyStroke) keyStrokesAndActions[i];
		Action act = (Action) keyStrokesAndActions[i + 1];
		newKm.addActionForKeyStroke(ks, act);
	}
	textField.setKeymap(newKm);
}
/**
 * Free all the resources for the receiver.
 */
public void free() {
	if (fTableColumn != null) {
		TableCellRenderer r = fTableColumn.getCellRenderer();
		if (r instanceof UiTableCellRenderer)
			 ((UiTableCellRenderer) r).free();
		//			fTableColumn.setCellRenderer(null);
		fTableColumn.setCellEditor(null);
		fTableColumn = null;
	}
	super.free();
}
/**
 * Answer the basic component associated with the
 * receiver.
 */
public Component getBasicComponent() {
	return fRenderer.getBasicComponent();
}
/**
 * Answer the identifier for the receiver. This is the id
 * used for accessing the values shown in the receiver.
 */
public String getColumnId() {
	return (String) fTableColumn.getIdentifier();
}
	public Component getComponent() {
	    return null;
	}
/**
 * Answer the dataType (Validator) set on the receiver.
 * This dataType, if present, is used for validating inputs
 * made in the receiver during cell editing.
 */
public IDataType getDataType() {
	return fDataType;
}
/**
 * Answer the font used for rendering the receiver
 */
public UIFont getFont() {
	return fFont;
}
/*
 * answer the index of the receiver into its widget
 *
 */
public int getIndex() {
	return getTableColumn().getModelIndex();
}
/**
 * Answer the table widget in which the receiver is
 * present
 */
public UITable getTable() {
	return getTableColumn().getTable();
}
/**
 * Answer the underlying swing widget for the
 * receiver.
 */
public UiTableColumn getTableColumn() {
	return fTableColumn;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setColId")) {
		fTableColumn.setIdentifier(args.asString("???"));
		refreshTable();
		return;
	}
	if (request.equals("setWidth")) {
		setWidth(args.asInt(-1));
		return;
	}
	if (request.equals("setEditable")) {
		setEditable(args.asBoolean(false));
		return;
	}
	if (request.equals("setDataType")) {
		setDataType(conn, args);
		return;
	}
	if (request.equals("setHeaderRenderer")) {
		fHeaderRenderer = (UILabel) getManaged(UIComponent.class, conn, args);
		fTableColumn.setHeaderRenderer(new UiJDefaultTableCellRenderer(null, this, fHeaderRenderer));
		repaintTable();
		return;
	}
	super.handleRequest(conn, request, args);
}
protected void initializeFor(JTable table) {
	//do nothing	
}
/**
 * Answer boolean whether the receiver is editable.
 */
public boolean isEditable() {
	return fTableColumn.getCellEditor() != null;
}
protected void refreshTable() {
	UITable table = getTable();
	if (table != null)
		table.getTable().repaint();
}
private void repaintTable() {
	if (fTableColumn != null) {
		UITable table = (UITable) fTableColumn.getTable();
		if (table != null) {
			table.getComponent().getParent().invalidate();
			table.getComponent().getParent().validate();
			table.getComponent().getParent().repaint();
			table.getTable().revalidate();
			table.getTable().repaint();
		}
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fTableColumn = new UiTableColumn(this);
	fTableColumn.setIdentifier(args.get("colId", "???"));
	// we don't have a modelIndex yet! it will be set in TableModelWrapper.addColumn

	setDataType(conn, args.get("dataType"));
	setLabel(args.get("label", null));
	fTableColumn.setMinWidth(10);
	setWidth(args.get("w", 40));
	fRenderer = (UIComponent) getManaged(UIComponent.class, conn, args.get("renderer"));
	if (fRenderer == null)
		fRenderer = new UILabel(); // UILabel.getDefaultLabel(); creates problems in TreeTable. RM 10.07.98
	fHeaderRenderer = (UILabel) getManaged(UIComponent.class, conn, args.get("hrenderer"));
	fTableColumn.setHeaderRenderer(new UiJDefaultTableCellRenderer(null, this, fHeaderRenderer));
	super.restoreState(conn, args);
	setEditable(args.get("editable", false));
}
void setDataType(ORBConnection conn, Anything args) {
	if (args != null) {
		IDataType newType= (IDataType) getManaged(IDataType.class, conn, args);
		if (newType != null) {
			fDataType = newType;
			refreshTable();
		}
	}
}
/**
 * This method sets the column to be editable or not
 *
 */
public void setEditable(boolean editable) {
	if (fRenderer != null) {
		fRenderer.configureAsColumnRenderer(this, editable, getDataType());
	}
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	((UiJDefaultTableCellRenderer) fTableColumn.getHeaderRenderer()).setEnabled(state);
	if (fRenderer != null)
		fRenderer.setEnabled(state);
	if (getTable() != null)
		getTable().getComponent().repaint();
}
/**
 * Set the font for the receiver to the given font.
 * @param font		UIFont		The new font to be used for renderint
 *								the receiver.
 */
public void setFont(UIFont font) {
	fFont = font;
}
/**
 * Set the font for the receiver to the given font.
 * @param font		Font		The new font to be used for renderint
 *								the receiver.
 */
public void setFont(Font font) {
	((UiJDefaultTableCellRenderer) fTableColumn.getHeaderRenderer()).setFont(font);
	UIFont uiFont = new UIFont();
	uiFont.setFont(font);
	if (fHeaderRenderer != null)
		fHeaderRenderer.setFont(uiFont);
	if (getTable() != null)
		getTable().getComponent().repaint();
}
/*
 * set the index of the receiver into its widget to <code>index</code>
 *
 * @param index		the position of the column in the widget
 */
public void setIndex(int index) {
	getTableColumn().setModelIndex(index);
}
/**
 * Set the label which will be displayed as title
 * label on the receiver.
 * @param 	label 	String		The label to be shown
 */
public void setLabel(String label) {
	if (fTableColumn != null && label != null)
		fTableColumn.setHeaderValue(label);
	repaintTable();
}
/**
 * Set the width of the receiver.
 * PLEASE NOTE: Setting the width can confuse the UI, if autoResize is not off!
 *
 * @param 	width 	int		The new width of the column
 */
public void setWidth(int width) {
	if (width >= 0) {
		fTableColumn.setMinWidth(width);		
		fTableColumn.setWidth(width);
		fTableColumn.setPreferredWidth(width);
	}
	else {
		fTableColumn.sizeWidthToFit();
	}
	repaintTable();
}
/**
 * Answer boolean whether the receiver is editable.
 * This method is added for subclassing in UITreeColumn.
 * @see UITreeColumn.ulcIsEditable
 */
public boolean ulcIsEditable() {
	return isEditable();
}
/**
 * Use the validator (if present) on the receiver, to validate
 * the given object.
 *
 * @param value		Object		The value entered in a cell on the receiver
 */
public Object validate(Object value) {
	int validationPolicy = TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE;
	if (fDataType != null) {
		try {
			Object v = fDataType.convertToObject(validationPolicy, (String) value, null);
			return v;
		} catch (DataTypeConversionException e) {
			UI.beep();
			return fDataType.getDefaultValue((String) value);
		}
	} else
		return value;
}
/**
 * Use the validator (if present) on the receiver, to validate
 * the given object for display only.
 *
 * @param value		Object		The value entered in a cell on the receiver
 */
public Object validateForDisplay(Object value) {
	if (fDataType == null)
		return value;
	return fDataType.convertToString(value, false);
}
}
