package com.ibm.ulc.ui.lists;

import javax.swing.plaf.*;
/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.lists.*;
import com.ibm.ulc.ui.dataTypes.*;
public class UIComboBox extends UIFormComponent implements IItemListListener {
	protected UiJComboBox fComboBox = null;
	protected UiComboModelWrapper fModel = null;
	protected boolean fEditable = false;
	protected boolean fInInsertPhase = false;
	protected UIItemList fItemList = null;
	protected int fLastSelectedIndex = -1;
	protected UITrigger fTrigger = null;
	protected Color fReadOnlyBackgroundColor;
	protected Color fEditableBackgroundColor;
	protected boolean fInRestoreState = true;
/**
 * Configure the UIColumn to use this widget as a renderer.
  *
 * @see UIColumn#restoreState
 */
public void configureAsColumnRenderer(UIColumn column, boolean editable, IDataType dataType) {
	JComponent c= (JComponent) getComponent();
	column.getTableColumn().setCellRenderer(new UiTableCellRenderer(c));
	if (editable) {
		UiJComboBox comboEditor = new UiJComboBox();
		if (! (c.getFont() instanceof FontUIResource))		
			comboEditor.setFont(c.getFont());
		/* DO NOT set the following properties since the editor is also
		 *  used to DISPLAY a selected combobox
		if (! (c.getForeground() instanceof ColorUIResource))
			comboEditor.setForeground(c.getForeground());
		if (! (c.getBackground() instanceof ColorUIResource))
			comboEditor.setBackground(c.getBackground());
		 */
	 	UiComboModelWrapper mw = (UiComboModelWrapper) ((UiJComboBox) getComponent()).getModel();
		comboEditor.setModel(new UiComboModelWrapper(comboEditor, mw.getItemList(), mw.getAttributeName()));
		column.getTableColumn().setCellEditor(new UiCellEditor(comboEditor));
	} else
		column.getTableColumn().setCellEditor(null);
}
public void free() {
	if (fComboBox != null) {
		//			fComboBox.setEditor(null);
		ListCellRenderer r = fComboBox.getRenderer();
		if (r instanceof UiListCellRenderer)
			 ((UiListCellRenderer) r).free();
		//			fComboBox.setRenderer(null);
		fComboBox.removeAll();
		fComboBox = null;
	}
	if (fModel != null) {
		fModel.free();
		fModel = null;
	}
	super.free();
}
/**
 * Return the Component whose background can be set to show the mandatory property.
 * @return java.awt.Component
 */
protected Component getBackgroundComponent() {
	Component comp = getBasicComponent();
	if (comp instanceof JComboBox) {
		JComboBox comboComp = (JComboBox) comp;
		if (comboComp.isEditable()) {
			return ((JComboBox) comp).getEditor().getEditorComponent();
		} else {
			return comp;
		}
	} else {
		return comp;
	}
}
public Component getComponent() {
	return fComboBox;
}
public void handleNewItem(String s) {
	if (fFormModel != null) {
		fFormModel.setValueAt(s, fKey, this, FORM_NOTIFICATION_ON_FOCUS_CHANGE);
	} else {
		Anything a = new Anything();
		a.put("item", s);
		sendEventULC("itemInsert", a);
		if (fTrigger != null)
			fTrigger.trigger(fConnection, TRIGGER_ON_ACTION, this, null);
	}
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setSelected")) {
		fInInsertPhase = true;
		setSelected(args.asString("???"));
		fInInsertPhase = false;
		return;
	}
	if (request.equals("setMaximumRowCount")) {
		setMaximumRowCount(args.asInt(-1));
		return;
	}
	if (request.equals("setSelectedIndex")) {
		fInInsertPhase = true;
		setSelectedIndex(args.asInt(-1));
		fInInsertPhase = false;
		return;
	}
	if (request.equals("setEditable")) {
		setEditable(args.asBoolean(false));
		return;
	}
	if (request.equals("setTableModel") || request.equals("setItemList")) {
		fLastSelectedIndex = -1;
		setItemList(conn, args);
		notify(TABLE_MODEL_CONTENTS_CHANGED, null, -1, -1);
		return;
	}
	if (request.equals("setTrigger")) {
		if (args.isNull())
			fTrigger = null;
		else
			fTrigger = (UITrigger) getManaged(UITrigger.class, conn, args);
		return;
	}
	super.handleRequest(conn, request, args);
}
public boolean itemIsNew(Object anObject) {
	if (fModel.isPlaceholder((String) anObject)) {
		return false;
	}
	int end = fComboBox.getItemCount();
	for (int i = 0; i < end; i++) {
		if (anObject.equals(fComboBox.getItemAt(i)))
			return false;
	}
	return true;
}
public void notify(int type, String[] attributeNames, int start, int end) {
	if (type == TABLE_MODEL_CONTENTS_CHANGED) {
		fLastSelectedIndex = -1;
		return;
	}
	if ((type == TABLE_MODEL_ROWS_REMOVED) && ((fLastSelectedIndex >= start) && (fLastSelectedIndex <= end))) {
		fLastSelectedIndex = -1;
		return;
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fComboBox = new UiJComboBox();
	setItemList(conn, args);
	super.restoreState(conn, args);
	UIComponent renderer = (UIComponent) getManaged(UIComponent.class, conn, args.get("renderer"));
	if (renderer == null)
		renderer = new UILabel();
	fComboBox.setRenderer(new UiListCellRenderer(renderer.getComponent()));
	setEditable(args.get("editable", false)); // DM: moved it out of if
	if (fFormModel != null) {
		updateFromModel();
	} else {
		if (!args.isDefined("selected")) {
			setSelectedIndex(args.get("selectedIndex", -1));
			fLastSelectedIndex = args.get("selectedIndex", -1);
		} else {
			String s = args.get("selected", null);
			if (s == null) {
				Object o = fModel.getElementAt(0);
				if (o != null)
					s = o.toString();
				else
					s = "???";
			}
			setSelected(s);
		}
	}
	if (args.isDefined("maximumRowCount"))
		setMaximumRowCount(args.get("maximumRowCount", 8));
	com.ibm.ulc.comm.DeferredRequest r = new com.ibm.ulc.comm.DeferredRequest(conn) {
		public void safeDispatch() {
			fComboBox.registerMouseListenersForParentComponents();
		}
	};
	conn.postRequest(r);
	fTrigger = (UITrigger) getManaged(UITrigger.class, conn, args.get("trigger"));
	fInRestoreState = false;
}
// called internally during stateChanged handling
protected void selectItem(Object anObject) {
	selectItem(anObject, fInInsertPhase);
}
// called internally during stateChanged handling
protected void selectItem(Object anObject, boolean inInsertPhase) {
	String s;
	if (anObject == null)
		s = "";
	else
		s = anObject.toString();
	if (fComboBox.isEditable()) {
		fComboBox.getEditor().setItem(s);
		fComboBox.validate();
		fComboBox.repaint();
	}
	if (fFormModel != null) {
		fFormModel.setValueAt(s, fKey, this, FORM_NOTIFICATION_ON_FOCUS_CHANGE);
	} else {
		int ix = fComboBox.getSelectedIndex();
		if ((!inInsertPhase) && (fLastSelectedIndex != ix) && !fInRestoreState) {
			Anything a = new Anything();
			fLastSelectedIndex = ix;
			a.put("selected", s);
			a.put("selectedIndex", fLastSelectedIndex);
			sendEventULC("itemStateChange", a);
			if (fTrigger != null)
				fTrigger.trigger(fConnection, TRIGGER_ON_SELECTION, this, null);
		}
	}
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	if (red == -1 || green == -1 || blue == -1) {
	}
	else {
		JComboBox c = (JComboBox) getBasicComponent();
		if (c != null) {
			Color color = new Color(red, green, blue);
			c.setBackground(color);
			ComboBoxEditor editor = c.getEditor();
			Component e = (Component) editor.getEditorComponent();
			if (editor != null) {
				e.setBackground(color);
			}
			if (refresh)
				refreshComponentColor(c);
		}
	};
}
public void setEditable(boolean b) {
	if (fComboBox != null) {
		fComboBox.setEditable(b);
		fComboBox.revalidate();
	}
}
protected void setItemList(ORBConnection conn, Anything args) {
	UITableModel model = (UITableModel) getManaged(UITableModel.class, conn, args.get("model"));
	UIItemList itemList = (UIItemList) getManaged(UIItemList.class, conn, args.get("itemList"));
	if (itemList == null) {
		if (model == null) {
			trouble("restoreState", "a list must have either an itemList or listModel assigned");
			model = new UITableModel();
			model.setItemList(conn, args);
		}
		itemList = model.getItemList();
	}
	fItemList = itemList;
	fItemList.addListener(this);
	String attributeName = args.get("colId", "null");
	if (fModel != null)
		attributeName = fModel.getAttributeName();
	fModel = new UiComboModelWrapper(this, fItemList, attributeName);
	fComboBox.setModel(fModel);
	if (fComboBox != null)
		fComboBox.repaint();
}
protected void setMaximumRowCount(int count) {
	if (fComboBox != null && count > 0) {
		fComboBox.setMaximumRowCount(count);
		fComboBox.validate();
		fComboBox.repaint();
	}
}
protected void setSelected(String s) {
	//	System.out.println("ComboBox.setSelected: " + s);
	if (fComboBox != null) {
		fComboBox.setSelectedItem(s);
		fComboBox.validate();
		fComboBox.repaint();
	}
}
protected void setSelectedIndex(int ix) {
	//	System.out.println("ComboBox.setSelectedIndex: " + ix);
	if (fComboBox == null)
		return;
	if (ix >= 0 && ix < fModel.getSize())
		fComboBox.setSelectedIndex(ix);
	else
		fComboBox.setSelectedItem(null);
	fComboBox.validate();
	fComboBox.repaint();
}
// called from ComboModelWrapper
public void stateChanged(Object anObject) {
	stateChanged(anObject, fInInsertPhase);
}
// called from ComboModelWrapper
public void stateChanged(Object anObject, boolean inInsertPhase) {
	String s;
	if (anObject == null)
		s = "";
	else
		s = anObject.toString();
	selectItem(s, inInsertPhase);
	if (fComboBox.isEditable() && itemIsNew(s)) {
		if (!inInsertPhase) {
			handleNewItem(s);
		}
		return;
	} else {
		fComboBox.validate();
		fComboBox.repaint();
	}
}
public void updateFromModel() {
	//System.out.println("ComboBox.updateFromModel: " + fFormModel.toString());
	if (fFormModel != null) {
		Object o = fFormModel.getValueAt(fKey);
		if (o instanceof PendingCell)
			o = null;
		if (o == null) {
			//setSelected("<invalid>");
			setEnabled(false);
		} else {
			setSelected(o.toString());
			setEnabled(true);
		}
	}
}
}
