package com.ibm.ulc.ui.lists;

import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.comm.DeferredRequest;
import java.util.*;
/**
 * Insert the type's description here.
 * Creation date: (10/14/99 11:41:47 AM)
 * @author: Rupal Majmudar (SBC-STC)
 */
public class UIHierarchicalItemList extends UIItemList {
	protected UiTreeModelWrapper[] fTreeModelWrappers = new UiTreeModelWrapper[0];
	protected UiDefaultMutableTreeNode fRoot = null;
	private UlcHashtable fPendingNodes = null;
	protected boolean fHasRoot = false;
/**
 * Keep the specified unidentified node for the stopRequest.
 * @see #stopRequest()
 */
protected void addPendingNode(UiDefaultMutableTreeNode node) {
	if (node.getId() == -1)
		return;
	node.setId(-1);
	try {
		javax.swing.tree.TreeNode parent = node.getParent();
		if (!fPendingNodes.containsKey(parent))
			fPendingNodes.put(parent, new UlcRange(100000000, -1));
		UlcRange pendingRange = (UlcRange) fPendingNodes.get(parent);
		int index = node.getIndex();
		pendingRange.fStartIndex = Math.min(pendingRange.fStartIndex, index);
		pendingRange.fEndIndex = Math.max(pendingRange.fEndIndex, index);
	}
	catch (NullPointerException ne) {
		trouble("UIHierarchicalItemList", "null pointer ?");
	}
}
/**
 * Add the specified treeModel to the receiver.
 * 
 */
public void addTreeModel(UiTreeModelWrapper treeModel) {
	for (int i = 0; i < fTreeModelWrappers.length; i++) {
		if (fTreeModelWrappers[i] == treeModel)
			return;
	}
	UiTreeModelWrapper[] newModels = new UiTreeModelWrapper[fTreeModelWrappers.length + 1];
	System.arraycopy(fTreeModelWrappers, 0, newModels, 1, fTreeModelWrappers.length);
	newModels[0] = treeModel;
	fTreeModelWrappers = newModels;
}
public void clearRoot() {
	fHasRoot = false;
	setRoot(newDummyRoot()); //A dummy node to get the treeModel to instantiate
}
protected void contentsChanged(ORBConnection conn, Anything args) {
	super.contentsChanged(conn, args);
	if (args.get("rows", 0) > 0) {
		fHasRoot = true;
		setRoot(new UiDefaultMutableTreeNode(fItemCache, args));
		Anything children = args.get("c");
		if (children != null && !children.isNull()) {
			insertDummyNodesFor(fRoot, 0, children.size()); // put dummy nodes to be replaced
			extractChildrenFrom(conn, args, fRoot);
		}
	}
	else {
		clearRoot();
	}
	IItemListListener listener;
	for (int i = 0; i < fItemListListeners.size(); i++) {
		listener = ((IItemListListener) fItemListListeners.elementAt(i));
		if (listener instanceof UITreeTable)
			 ((UITreeTable) listener).updateRootVisibility();
	}
	for (int i = 0; i < getTreeModelWrappers().length; i++) {
		getTreeModelWrappers()[i].setRoot(fRoot);
	}
}
/**
 * An itemList need not contain all the nodes of it's model. 
 * So if an insertion occurs outside the receiver's tree, the node will be null.
 * Ignore the insertion in such a case.
 */
protected void doActiveRowInsertion(ORBConnection conn, Anything nodeAny, UiDefaultMutableTreeNode parentNode, Anything children) {
	//Ensure dummy nodes present, else problems with immediateInsertion etc.
	for (int k = 0; k < getTreeModelWrappers().length; k++) {
		getTreeModelWrappers()[k].getChild(parentNode, parentNode.getExpectedChildCount() - 1);
	}
	for (int j = 0; j < children.size(); j++) {
		Anything nodeArgs = children.get(j);
		UiDefaultMutableTreeNode nextNode = new UiDefaultMutableTreeNode(fItemCache, nodeArgs);
		int index = nodeAny.get("si").asInt(-1);
		try {
			UiDefaultMutableTreeNode existingNode = (UiDefaultMutableTreeNode) parentNode.getChildAt(index);
			if (existingNode.isValidNode()) {
				//Do nothing, new node gets inserted further down, correctly.
				//System.out.println("UIHierarchicalItemList.handleInsertImm. node : " + existingNode + " : Index: " + index + " exists");
			} else
				parentNode.remove(existingNode);
		} catch (ArrayIndexOutOfBoundsException abe) {
			//No problem, go ahead and insert. Should work because we have inserted
			//appropriate dummy nodes earlier.
		}
		insertChildNodeAndNotify(parentNode, nextNode, index);
	}
}
/**
 * An itemList need not contain all the nodes of it's model. 
 * So if an insertion occurs outside the receiver's tree, the node will be null.
 * Ignore the insertion in such a case.
 */
protected void doLazyRowInsertion(
	ORBConnection conn, 
	Anything nodeAny, 
	UiDefaultMutableTreeNode parentNode,
	int initialExpectedChildCount) {

	//Ensure dummy nodes present, else problems with immediateInsertion etc.
	for (int k = 0; k < getTreeModelWrappers().length; k++) {
		//Using initialCount so that the new dummy node can be inserted later at the
		//right index. Use ensureChildAt() so that we insert only till this initialCount,
		//and not till expectedCount (as in getChild(..)
		getTreeModelWrappers()[k].ensureChildAt(parentNode, initialExpectedChildCount);
	}
	Vector indices = null;
	if (nodeAny.isDefined("indices")) {
		indices = nodeAny.get("indices").toCollection();
		int[] indicesArray = new int[indices.size()];
		for (int jj = 0; jj < indices.size(); jj++)
			indicesArray[jj] = ((Integer) indices.elementAt(jj)).intValue();
		insertDummyNodesAndNotify(parentNode, indicesArray);
	} else { //No indices provided : start at the end of existing list of children
		int startIndex = parentNode.getChildCount();
		int stopIndex = parentNode.getExpectedChildCount();
		insertDummyNodesAndNotify(parentNode, startIndex, stopIndex);
	}
}
/**
 * Children have been delivered from the ULC. Extract them to nodes,
 * with the given parent, starting at the given startIndex.
 */
protected void extractChildrenFrom(ORBConnection conn, Anything args, UiDefaultMutableTreeNode parentNode) {
	int startIndex = args.get("si", -1);
	Anything children = args.get("c");
	Vector childNodesToBeInserted = getChildNodesFrom(conn, children, parentNode);
	//Ensure dummy nodes present, else problems with immediateInsertion etc.
	if (getTreeModelWrappers().length == 0)
		parentNode.ensureChildAt(startIndex);
	else {
		for (int i = 0; i < getTreeModelWrappers().length; i++) {
			getTreeModelWrappers()[i].getChild(parentNode, startIndex);
		}
	}
	insertChildNodes(parentNode, childNodesToBeInserted, startIndex);
}
protected UiDefaultMutableTreeNode extractParentFrom(Anything args) {
	int rootId = args.get("id").asInt(-1);
	return getRoot().locateNodeWithId(rootId);
	//The parent node MUST be present in the root structure, since the parent 
	//was sent from the UI in the first place.
}
/**
 * Based on the incoming args, make a list of all the childNodes
 * that need to be added to the given parent node.
 */
public Vector getChildNodesFrom(ORBConnection conn, Anything children, UiDefaultMutableTreeNode parentNode) {
	Vector nodesToBeInserted = new Vector();
	if (children != null) {
		for (int i = 0; i < children.size(); i++) {
			Anything nodeArgs = children.get(i);
			UiDefaultMutableTreeNode nextNode = new UiDefaultMutableTreeNode(fItemCache, nodeArgs);

			//UiDefaultMutableTreeNode existingNode = locateNodeWithId(nextNode.getId());
			//Add this new node in any case, and give a warning. Note :
			//If we do not do this insertion, it would cause index-problems in
			// insertChildNodes().
			nodesToBeInserted.addElement(nextNode);
			//if (existingNode != null) {
			//	System.out.println("Node already EXISTS ************ " + existingNode + ". Check !");
			// No harm done : this situation is handled cleanly in insertChildNodes().
			//}
		}
	}
	return nodesToBeInserted;
}
public  UiDefaultMutableTreeNode getRoot() {
	return fRoot;
}
/**
 * Returns the value at the specified index.  
 */
protected IRow getRowAt(int index) {
	shouldNotImplement("getRowAt");
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (11/15/99 12:57:22 PM)
 * @return com.ibm.ulc.ui.lists.UiTreeModelWrapper[]
 */
com.ibm.ulc.ui.lists.UiTreeModelWrapper[] getTreeModelWrappers() {
	return fTreeModelWrappers;
}
/**
 * Returns an attribute value for the cell at <I>columnIndex</I>
 * and <I>rowIndex</I>.
 *
 * @param	rowIndex	the row whose value is to be looked up
 * @param	columnIndex 	the column whose value is to be looked up
 * @return	the value Object at the specified cell
 */
public Object getValueAt(UiDefaultMutableTreeNode node, String attributeName) {
	if (!node.isValidNode())
		addPendingNode(node);
	return getValueAtOid(node.getId(), attributeName);
}
public void handleReload(ORBConnection conn, Anything args) {
	for (int i = 0; i < args.size(); i++) {
		Anything nodeAny = args.get(i);
		UiDefaultMutableTreeNode parentNode = extractParentFrom(nodeAny);
		removeAllChildren(parentNode);
		parentNode.setExpectedChildCount(0);
	}
	insertRows(args);
}
/*
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("reload")) {
		handleReload(conn, args);
		return;
	}
	if (request.equals("setPaths")) {
		handleSetPaths(conn, args);
		notify(TABLE_MODEL_ROWS_CHANGED, new String[0], 0, -1);
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * An itemList need not contain all the nodes of it's model. 
 * So if an insertion occurs outside the receiver's tree, the node will be null.
 * Ignore the insertion in such a case.
 */
protected void handleRowInsertion(ORBConnection conn, Anything args) {
	for (int i = 0; i < args.size(); i++) {
		Anything nodeAny = args.get(i);
		UiDefaultMutableTreeNode parentNode = extractParentFrom(nodeAny);
		if (parentNode == null)
			return;
		int initialExpectedChildCount = parentNode.getExpectedChildCount();
		parentNode.setExpectedChildCount(nodeAny.get("cc", initialExpectedChildCount));
		Anything children = nodeAny.get("c");
		if (children == null)
			doLazyRowInsertion(conn, nodeAny, parentNode, initialExpectedChildCount);
		else
			doActiveRowInsertion(conn, nodeAny, parentNode, children);
	}
	notify(TABLE_MODEL_ROWS_ADDED, null, new int[] {-1});
}
public void handleSetPaths(ORBConnection conn, Anything args) {
	for (int i = 0; i < args.size(); i++) {
		Anything pathArgs = args.get(i);
		for (int pi = 0; pi < pathArgs.size(); pi++) {
			Anything nodeAny = pathArgs.get(pi);
			int nodeId = nodeAny.get("id", -1);
			if (nodeId > -1) {
				UiDefaultMutableTreeNode node = getRoot().locateNodeWithId(nodeId);
				node.setExpectedChildCount(nodeAny.get("cc", node.getExpectedChildCount()));
				extractChildrenFrom(getConnection(), nodeAny, node);
			}
		}
	}
}
/*
  * Answer true if 
  *		the reciever has no root (from restoreState)
  *		the root has been set to null explicitly
  *		the previous root has been deleted.
  */
protected boolean hasNoRoot() {
	return !fHasRoot;
}
public void insertChildNodeAndNotify(UiDefaultMutableTreeNode parentNode, UiDefaultMutableTreeNode nodeToBeInserted, int index) {
	parentNode.insert(nodeToBeInserted, index);
	//Now the code from DefaultTreeModel moves here, since we have the node state
	//in the itemList and not in the treeModelWrapper anymore.
	int[] newIndexs = new int[1];
	newIndexs[0] = index;
	notifyInsertion(parentNode, newIndexs);
}
/**
 * Do the actual inserting of all the childNodes that have been
 * received, and fire just one notification at the end. Use the
 * index passed into each node, to know as to where this node should
 * be inserted.
 */
public void insertChildNodes(UiDefaultMutableTreeNode parentNode, Vector nodesToBeInserted, int startIndex) {
	if (parentNode == null)
		return;
	int numOfElements = nodesToBeInserted.size();
	int[] indices = new int[numOfElements];
	for (int j = startIndex; j < startIndex + numOfElements; j++) {
		indices[j - startIndex] = j;
		try {
			//A node exists at this location. It should normally be a dummy node.If it is a ' real '
			//node, this implies that we have fetched it unnecessarily (but no other harm done).
			UiDefaultMutableTreeNode existingNode = (UiDefaultMutableTreeNode) parentNode.getChildAt(j);
			if (!existingNode.isPendingNode() && !existingNode.isInvalidNode())
				System.out.println("Need not have requested node : " + existingNode + " : Index: " + j);
			removeChildNodeAndNotify(parentNode, existingNode);
		} catch (ArrayIndexOutOfBoundsException abe) {
			//Timing problems occur when the ULC side says 'changed' as part of the
			//nodeExpanded event, for example. Then, the receiver has not had the time
			//to put in dummyNodes at all, and the real nodes are delivered into this
			//method. In such a case : simply insert the incoming nodes, as usual : 
			//abe.printStackTrace();
		}
		UiDefaultMutableTreeNode nextNode = (UiDefaultMutableTreeNode) nodesToBeInserted.elementAt(j - startIndex);
		insertChildNodeAndNotify(parentNode, nextNode, j);
	}
}
public void insertDummyNodesAndNotify(UiDefaultMutableTreeNode parentNode, int[] indices) {
	for (int i = 0; i < indices.length; i++) {
		parentNode.insert(newDummyNode(), indices[i]);
	}
	notifyInsertion(parentNode, indices);
}
public void insertDummyNodesAndNotify(UiDefaultMutableTreeNode parentNode, int startIndex, int stopIndex) {
	int[] indices = new int[stopIndex - startIndex];
	for (int i = startIndex; i < stopIndex; i++) {
		parentNode.insert(newDummyNode(), i);
		indices[i - startIndex] = i;
	}
	notifyInsertion(parentNode, indices);
}
/**
 * For the given vector (UiDefaultMutableTreeNode elements),
 * insert the appropriate number of DummyNode objects into each element.
 */
protected void insertDummyNodesFor(UiDefaultMutableTreeNode parentNode, int startIndex, int stopIndex) {
	for (int i = startIndex; i < stopIndex; i++) {
		parentNode.insert(newDummyNode(), i);
	}
}
/**
 * Returns the value at the specified index.  
 */
protected void insertRows(Anything args) {
	startRequest();
	handleRowInsertion(getConnection(), args);
	stopRequest();
}
protected UiDefaultMutableTreeNode newDummyNode() {
	return UiDefaultMutableTreeNode.newDummyNode(fItemCache);
}
/**
 * Answer the dummy root to set, when no root is provided to the receiver.
 * This is required since a TreeModel cannot instantiate without a root.
 */
protected UiDefaultMutableTreeNode newDummyRoot() {
	return new UiDefaultMutableTreeNode(null, -1);
}
/**
 * handle the case of the missing row
 */
protected void notify(int changeType, String[] attributeNames, IRow[] changedRows) {
	int[] oids = new int[changedRows.length];
	for (int i = 0; i < changedRows.length; i++) {
		oids[i] = changedRows[i].getOid();
	}
	for (int i = 0; i < getTreeModelWrappers().length; i++) {
		getTreeModelWrappers()[i].notify(changeType, attributeNames, oids);
	}
}
/**
 * handle the case of the missing row
 */
public void notifyCellChanged(IRow changedRow, String attributeName) {
	for (int i = 0; i < getTreeModelWrappers().length; i++) {
		getTreeModelWrappers()[i].nodesChanged(new IRow[] {changedRow}, new String[] {attributeName});
	}
	notify(TABLE_MODEL_CELL_CHANGED, new String[] {attributeName}, new IRow[] {changedRow});
}
/**
 * handle the case of the missing row
 */
public void notifyCellsChanged(IRow[] changedRows, String[] attributeNames) {
	for (int i = 0; i < getTreeModelWrappers().length; i++) {
		getTreeModelWrappers()[i].nodesChanged(changedRows, attributeNames);
	}
	if (attributeNames != null && attributeNames.length > 0)
		notify(TABLE_MODEL_CELL_CHANGED, attributeNames, changedRows);
	else
		notify(TABLE_MODEL_ROWS_CHANGED, attributeNames, changedRows);
}
protected void notifyInsertion(UiDefaultMutableTreeNode parentNode, int[] indices) {
	UiTreeModelWrapper[] tmw = getTreeModelWrappers();
	if (tmw.length > 0) {
		for (int i = 0; i < tmw.length; i++)
			tmw[i].nodesWereInserted(parentNode, indices);
	}
}
public void notifyRemoval(UiDefaultMutableTreeNode parentNode, int[] removedIndices, Object[] removedNodes) {
	UiTreeModelWrapper[] tmw = getTreeModelWrappers();
	if (tmw.length > 0) {
		for (int i = 0; i < tmw.length; i++)
			tmw[i].nodesWereRemoved(parentNode, removedIndices, removedNodes);
	}
}
public void notifyRowsChanged(IRow[] changedRows) {
	for (int i = 0; i < getTreeModelWrappers().length; i++) {
		getTreeModelWrappers()[i].nodesChanged(changedRows, null);
	}
	super.notifyRowsChanged(changedRows);
	refreshRoot(changedRows);
}
public void notifyRowsRemoved(IRow[] removedRows) {
	Vector indices = new Vector();
	for (int i = 0; i < removedRows.length; i++) {
		int nodeId = removedRows[i].getOid();
		UiDefaultMutableTreeNode node = getRoot().locateNodeWithId(nodeId);
		if (node == null)
			return;
		UiDefaultMutableTreeNode parent = (UiDefaultMutableTreeNode) node.getParent();
		if (parent == null) { //Can only be the root node which has no parent.
			removeAllChildren(node); //Remove all children of the current root node.
			clearRoot();
			notify(TABLE_MODEL_ROWS_REMOVED, new String[0], 0, 0);
			return;
		}
		//Now the code from DefaultTreeModel moves here, since we have the node state
		//in the itemList and not in the treeModelWrapper anymore.
		int[] childIndex = new int[1];
		Object[] removedArray = new Object[1];
		childIndex[0] = parent.getIndex(node);
		parent.remove(childIndex[0]);
		removedArray[0] = node;
		notifyRemoval(parent, childIndex, removedArray);
		parent.decrementExpectedChildCount(1);
	}
}
/**
 * New data has been set in the itemCache of the receiver.
 * Need to workaround a swing bug with updating this new data
 * if one of the rowsis the root node.
 */
public void notifyRowsSet(IRow[] setRows) {
	super.notifyRowsSet(setRows);
	refreshRoot(setRows);
}
/** 
 * The mapping oid to index is done for each tree table widget
 * by that widget's treeModelWrapper. The receiver may be serving
 * multiple tree widgets.
 */
protected int oidToIndex(int oid) {
	shouldNotImplement("oidToIndex");
	return -1;
}
/**
 * Workaround for the bug that the tree root does not get refreshed
 * when it's data is changed. We therefore need to force this update
 * on the treeTable.
 */
private void refreshRoot(IRow[] setRows) {
	boolean rootChanged= false;
	for (int i = 0; i < setRows.length; i++) {
		if (setRows[i].getOid() == getRoot().getId())
			rootChanged= true;
			break;
	}
	if (rootChanged) {
		IItemListListener listener;
		for (int i = 0; i < fItemListListeners.size(); i++) {
			listener = ((IItemListListener) fItemListListeners.elementAt(i));
			if (listener instanceof UITreeTable)
				((UITreeTable) listener).updateRoot();
		}
	}
}
public void removeAllChildren(UiDefaultMutableTreeNode parentNode) {
	//First collect the data required for the notification
	int size = parentNode.getChildCount();
	int[] removedIndices = new int[size];
	Object[] removedNodes = new Object[size];
	for (int i = 0; i < size; i++) {
		UiDefaultMutableTreeNode nodeToBeRemoved = (UiDefaultMutableTreeNode) parentNode.getChildAt(i);
		removedIndices[i] = i;
		removedNodes[i] = nodeToBeRemoved;
	}
	//And only then do the actual remove
	parentNode.removeAllChildren();
	//And now the notification.
	notifyRemoval(parentNode, removedIndices, removedNodes);
}
public void removeChildNodeAndNotify(UiDefaultMutableTreeNode parentNode, UiDefaultMutableTreeNode nodeToBeRemoved) {
	int[] childIndex = new int[1];
	Object[] removedArray = new Object[1];
	childIndex[0] = parentNode.getIndex(nodeToBeRemoved);
	parentNode.remove(nodeToBeRemoved);
	removedArray[0] = nodeToBeRemoved;
	notifyRemoval(parentNode, childIndex, removedArray);
}
/**
 * Remove the specified treeModel from the receiver.
 * 
 */
public void removeTreeModel(UiTreeModelWrapper treeModel) {
	Vector v = new Vector();
	for (int i = 0; i < fTreeModelWrappers.length; i++) {
		if (fTreeModelWrappers[i] != treeModel) {
			v.addElement(fTreeModelWrappers[i]);
		}
	}
	UiTreeModelWrapper[] newModels = new UiTreeModelWrapper[v.size()];
	v.copyInto(newModels);
	fTreeModelWrappers = newModels;
}
/**
 * Request the nodes for the specified nodeIds. This is needed only when
 * the selected items of the receiver have no mapping for the receiver.
 * The answer for this request is handled in #setPaths.
 *
 */
protected void requestNodeIds(int[] oids) {
	Anything anything = new Anything();
	Anything oidAny = new Anything();
	for (int i = 0; i < oids.length; i++) {
		oidAny.append(new Anything(oids[i]));
	}
	anything.put("nodeIds", oidAny);
	sendULC("getPaths", anything);
}
/**
 * Request the ULC for the oids of indices previously requested by a widget
 * of the receiver. Make sure to request as full a page as possible and needed.
 * The answer for this request is handled in #setData.
 */
protected void requestOids() {
	if (fPendingNodes.size() > 0) {
		Anything args = new Anything();
		Enumeration parents = fPendingNodes.keys();
		while (parents.hasMoreElements()) {
			UiDefaultMutableTreeNode parent = (UiDefaultMutableTreeNode) parents.nextElement();
			UlcRange range = (UlcRange) fPendingNodes.get(parent);
			Anything anything = new Anything();
			anything.put("p", parent.getId());
			anything.put("if", range.fStartIndex);
			anything.put("it", range.fEndIndex);
			args.append(anything);
		}
		sendULC("getData", args);
		fPendingNodes = null;
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	if (args.get("rows", 0) > 0) {
		fHasRoot = true;
		fRoot = new UiDefaultMutableTreeNode(fItemCache, args);
		Anything children = args.get("c");
		if (children != null && !children.isNull()) {
			insertDummyNodesFor(fRoot, 0, children.size()); // put pending nodes to be replaced
			extractChildrenFrom(conn, args, fRoot);
		}
	}
	else {
		clearRoot();
	}
	if (args.isDefined("initialPaths"))
		handleSetPaths(conn, args.get("initialPaths"));
}
/**
 * Set the index-to-oid mappings specified in args. The format expected is
 *
 *	'if' (Index From)
 *	'it' (Index To)
 *	'rowids' (the oids for the index range)
 *
 * 'rowids' may be omitted if the oids are identical to their indices or
 * if the rowids are sent as a range defined by 'of' (from) and 'ot' (to).
 *
 * a range is extracted from the anything in #extractRowIds
 */
protected IRow[] setData(Anything ranges) {
	if (ranges == null)
		return new IRow[0];
	Vector rows = new Vector();
	for (int i = 0; i < ranges.size(); i++) {
		Anything rangeAny = ranges.get(i);
		int nodeId = rangeAny.get("p", -1);
		if (nodeId != -1) { //Happens because of the "an" and "data" tags in ulchierIL.getData().
			UiDefaultMutableTreeNode parent = getRoot().locateNodeWithId(nodeId);
			if (parent != null) {
				int from = rangeAny.get("if", -1);
				int to = rangeAny.get("it", -1);
				Anything nodeIds = rangeAny.get("c");
				for (int ci = from; ci <= to; ci++) {
					Anything nodeAny = nodeIds.get(ci - from);
					if (!nodeAny.isNull()) { //happens during special cases e.g. reload during expansion.
						int id = nodeAny.get("id").asInt(-1);
						if (id > -1) {
							UiDefaultMutableTreeNode child = (UiDefaultMutableTreeNode) parent.getChildAt(ci);
							child.initializeFrom(nodeAny);
							rows.addElement(child.getRow());
						}
					}
				}
			}
		}
	}
	IRow[] answer = new IRow[rows.size()];
	rows.copyInto(answer);
	return answer;
}
protected void setRoot(UiDefaultMutableTreeNode root) {
	fRoot = root;
}
public void setRowToBeEdited(int index) {
	//super.setRowToBeEdited(index);
}
/**
 * answer the instance of <code>UiRow</code> that is defined by <code>oid</code>. answer
 * the PendingItem if the row is not already present, and request the data from ULC
 */
public void setValueAt(String attributeName, Object value, UiDefaultMutableTreeNode node, int notificationPolicy) {
	getItemCache().setValue(node.getId(), attributeName, value, notificationPolicy);
}
/** 
 * The mapping oid to index is done for each tree table widget
 * by that widget's treeModelWrapper. The receiver may be serving
 * multiple tree widgets.
 */
protected void shouldNotImplement(String where) {
	trouble(where, "should not be called");
}
/**
 * Returns the value at the specified index.  
 */
public void startRequest() {
	if (fRequestsStarted == 0)
		fPendingNodes = new UlcHashtable();
	super.startRequest();
}
}
