package com.ibm.ulc.ui.lists;

import java.awt.Component;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import com.ibm.ulc.base.IDefaults;
import com.ibm.ulc.util.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.dataTypes.*;
/**
 * (c) Object Technology International 1997,1998,1999.
 *
 * This class is used for editing cells of a table.
 *
 */
public class UiCellEditor extends DefaultCellEditor implements FocusListener, DocumentListener {
	protected JTable fTable;
	protected IDataType fDataType = null;
	protected UiPlainDocument fDocument = null;
	protected UlcHashtable fSavedChanges = new UlcHashtable();
	protected int fRow, fColumn;

public UiCellEditor(JCheckBox x) {
	super(x);
	initialize();
}
public UiCellEditor(JComboBox x) {
	super(x);
	initialize();
}
public UiCellEditor(JTextField x) {
	super(x);
	initialize();
	fDocument= new UiPlainDocument(this);
	x.setDocument(fDocument);
	fDocument.addDocumentListener(this);
}
public UiCellEditor(JTextField x, IDataType dataType) {
	super(x);
	fDataType= dataType;
	initialize();
	fDocument= new UiPlainDocument(this);
	x.setDocument(fDocument);
	fDocument.addDocumentListener(this);
}
public void changedUpdate(DocumentEvent e) {
}
/**
 * This method is called from the UIPlainDocument class to filter
 * the text entered (pasted) into a field.
 * It may return the original string, a modified string, or null to indicate
 * invalid input.
 *
 * @see UIPlainDocument
 */
public String filterInput(int position, String newString, AttributeSet attribute) {
	if (fDataType != null) {
		String text = ((JTextField) getComponent()).getText();
		newString = fDataType.filterInput(position, newString, text, attribute);
		if (newString == null)
			UI.beep();
	}
	return newString;
}
public void focusGained(FocusEvent e) {
	//System.out.println("Gained Editor focus");

}
public void focusLost(FocusEvent e) {
	//*	for some strange reason with Swing11
	//* this event is fired immediately after edit start
	//	stopCellEditing();
}
public String getLastInput() {
	Object ht = fSavedChanges.get(new Integer(fRow));
	if (ht == null)
		return null;
	return (String) ((UlcHashtable) ht).get(new Integer(fColumn), null);
}
public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
	fTable = table;
	Object v = value;
	fRow = row;
	fColumn = column;
	String s = null;
	if ((fDocument != null) && ((s = getLastInput()) != null)) {
		v = s;
	}
	return super.getTableCellEditorComponent(table, v, isSelected, row, column);
}
public void initialize() {
//	getComponent().addFocusListener(this);
}
public void insertUpdate(DocumentEvent e) {
	//validate(IDefaults.TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
}
public void removeUpdate(DocumentEvent e) {
	//validate(IDefaults.TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
}
public void rowsRemoved(int start, int end) {
	if (start == -1 || end == -1) {
		fSavedChanges= new UlcHashtable();
		return;
		}
	for (int i = start; i <= end; i++) {
		fSavedChanges.remove(new Integer(i));
	}
}
public void setLastInput(String string) {
	Object ht = fSavedChanges.get(new Integer(fRow));
	if (ht == null) {
		ht = new UlcHashtable();
		fSavedChanges.put(new Integer(fRow), ht);
	}
	((UlcHashtable) ht).put(new Integer(fColumn), string);
}
public boolean stopCellEditing() {
	if (fDocument != null) {
		String text = ((JTextField) getComponent()).getText();
		setLastInput(text);
	}
	return super.stopCellEditing();
}
}
