package com.ibm.ulc.ui.lists;

import java.awt.Image;
import java.util.*;
import java.net.URL;
import javax.swing.tree.*;
import javax.swing.ImageIcon;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.comm.Common;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.base.*;

/**
 * This is a core class on the UI side for the ULCTree widget.
 * It models one node of the tree, by implementing the given
 * interfaces.
 */
public class UiDefaultMutableTreeNode extends DefaultMutableTreeNode implements ITreeNode, ITreeChildHandler {

	/**
	 * The index of the receiver in it's parent's collection
	 * of children. Required for inserting a nodeat a pre-
	 * defined position in the parent's list of children.
	 */
	protected int fIndex;

	/**
	 * The total number of children that should be present
	 * for the receiver when it has been completely uploaded.
	 * Note that getChildCount() gives the number of children
	 * that have been uploaded so far.
	 */
	protected int fExpectedChildCount;
	protected UiItemCache fItemCache = null;
	protected int fId = -1;
public UiDefaultMutableTreeNode(UiItemCache itemCache, int nodeId) {
	super(null);
	fItemCache = itemCache;
	fId = nodeId;
}
public UiDefaultMutableTreeNode(UiItemCache itemCache, Anything nodeArgs) {
	super(null);
	fItemCache = itemCache;
	initializeFrom(nodeArgs);
}
/**
 * Children are being removed from the receiver (AFTER the
 * initial childCount delivery).
 * Update the childCount appropriately.
 */
public void decrementExpectedChildCount(int n) {
	fExpectedChildCount= fExpectedChildCount - n;
}
/**
 * Add dummy nodes if necessary, to ensure that there is a child present at the given
 * index for the receiver.
 * Used in case the UiTreeModelWrapper is not yet instantiated. Else it will do the
 * same in getChild(parent, index)
 */
public void ensureChildAt(int childIndex) {
	try {
		super.getChildAt(childIndex);
	} catch (ArrayIndexOutOfBoundsException e) {
		int startIndex = Math.min(childIndex, getChildCount());
		insertDummyNodesAt(startIndex, getExpectedChildCount()-1);
	}
}
public void free() {
	removeAllChildren();
	setUserObject(null);
	removeFromParent();
	fItemCache = null;
}
public int getExpectedChildCount() {
	return fExpectedChildCount;
}
public int getId() {
	return fId;
}
public int getIndex() {
	if (getParent() == null)
		return 0;
	else
		return getParent().getIndex(this);
}
public UiItemCache getItemCache() {
	return fItemCache;
}
/**
 * Insert the method's description here.
 * Creation date: (10/18/99 5:37:15 PM)
 * @return com.ibm.ulc.ui.lists.IRow
 */
public IRow getRow() {
	try {
		return fItemCache.getRow(getId());
	}
	catch (NullPointerException ne) {
		return UiInvalidRow.getInstance();
	}
}
/**
 * Children are being added to the receiver (AFTER the
 * initial childCount delivery).
 * Update the childCount appropriately.
 */
public void incrementExpectedChildCount(int n) {
	fExpectedChildCount= fExpectedChildCount + n;
}
/** 
 * Initialize the id of the node being created.
 * This random id will be used by InvaidNode instances only, since
 * All 'normal' nodes will get their id as part of their constructor.
 */
													
protected void initialize() {	
	fExpectedChildCount= 0;
	fIndex= -1; 		// undefined by default.
}
public void initializeFrom(ORBConnection conn, Anything nodeArgs) {
	//fLabel = nodeArgs.get("label", "");
	fIndex = nodeArgs.get("index", -1);
	/*Anything iconArgs = nodeArgs.get("icon");
	if (iconArgs != null) {
	System.out.println("Icon to be handled in initializeFrom(..)");
	UIIcon icon = (UIIcon) uiTreeTable.getManaged(UIIcon.class, conn, iconArgs);
	icon.getImage(uiTreeTable, "setIcon", this);
	setIcon(icon, uiTreeTable);
	}*/
	fExpectedChildCount = nodeArgs.get("childCount").asInt(-1);
}
public void initializeFrom(Anything nodeArgs) {
	fId = nodeArgs.get("id").asInt(-1);
	//fLabel = nodeArgs.get("label", "");
	fIndex = nodeArgs.get("index", -1);
	/*Anything iconArgs = nodeArgs.get("icon");
	if (iconArgs != null) {
	System.out.println("Icon to be handled in initializeFrom(..)");
	UIIcon icon = (UIIcon) uiTreeTable.getManaged(UIIcon.class, conn, iconArgs);
	icon.getImage(uiTreeTable, "setIcon", this);
	setIcon(icon, uiTreeTable);
	}*/
	fExpectedChildCount = nodeArgs.get("cc").asInt(0);
}
/**
 * For the given vector (ITreeNode elements),
 * insert the appropriate number of DummyNode objects into each element.
 */
protected void insertDummyNodesAt(int startIndex, int stopIndex) {
	for (int i = startIndex; i < stopIndex; i++) {
		UiDefaultMutableTreeNode newNode = newDummyNode(getItemCache());
		insert(newNode, i);
	}
}
/**
 * Answer boolean whether the receiver is an 'InvalidNode'.
 */
public boolean isInvalidNode() {
	return getRow() instanceof UiInvalidRow;
}
/**
 * Answer boolean whether the receiver is a 'PendingNode'.
 */
public boolean isPendingNode() {
	return getRow() instanceof UiPendingRow;
}
/**
 * Answer boolean whether the receiver is an 'InvalidNode'.
 */
public boolean isValidNode() {
	return getId() > -1;
}
/**
 * Locate a node with the given id if one already exists.
 * If not, answer null.
 */
public UiDefaultMutableTreeNode locateNodeWithId(int nodeId) {
	TreeNode treeNode = getRoot();
	if (treeNode instanceof UiDefaultMutableTreeNode) {
		Enumeration e = ((UiDefaultMutableTreeNode) treeNode).breadthFirstEnumeration();
		while (e.hasMoreElements()) {
			Object nextObj = e.nextElement();
			if (nextObj instanceof UiDefaultMutableTreeNode) {
				UiDefaultMutableTreeNode nextNode = (UiDefaultMutableTreeNode) nextObj;
				if (nextNode.getId() == nodeId) {
					return nextNode;
				}
			}
		}
	}
	return null;
}
public static UiDefaultMutableTreeNode newDummyNode(UiItemCache itemCache) {
	return new UiDefaultMutableTreeNode(itemCache, -2);
}
public void prepareForRootChange() {
	removeAllChildren();
	setExpectedChildCount(0);
}
protected void setExpectedChildCount(int count) {
	fExpectedChildCount= count;
}
public void setId(int id) {
	fId = id;
}
public String toString() {
	return "Node(" + getId() + ")";
}
}
