package com.ibm.ulc.ui.lists;

/**
 * (c) Object Technology International 1997,1998.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.*;
import javax.swing.event.*;
public class UiJComboBox extends JComboBox implements IRenderer,MouseListener {

	private class AMouseAdapter extends MouseAdapter {
		UiJComboBox jCombo = null;
		public AMouseAdapter(UiJComboBox combo) {
			super();
			jCombo = combo;
		}
		public void mouseClicked(MouseEvent e) {
			jCombo.handleExternalMouseClicked(e);
		}
	}
	IAboutToPaintListener fListener = null;
	MouseAdapter fMouseAdapter = null;
	protected Vector fListenerComponents = new Vector();
/**
 * UiJComboBox constructor comment.
 */
public UiJComboBox() {
	super();
	addMouseListener(this);

}
/**
 * UiJComboBox constructor comment.
 * @param aModel javax.swing.ComboBoxModel
 */
public UiJComboBox(ComboBoxModel aModel) {
	super(aModel);
	addMouseListener(this);
}
/*
 * The combo box popup does not close when the mouse is clicked outside its area.
 * Register a mouse listener on the container to close the popup if a mouse is clicked
 * outside the popup area.
 */
private void addMouseListenerFor(Container c) {
	if (fMouseAdapter == null)
		fMouseAdapter = new AMouseAdapter(this);
	if (!fListenerComponents.contains(c)) {
		fListenerComponents.addElement(c);
		c.addMouseListener(fMouseAdapter);
	}
}
public void configureAsRenderer(JList list, IAboutToPaintListener listener, Object o, boolean isSelected) {
	fListener = listener;
	if (isSelected) {
		setOpaque(true); // we have to set this in order to get background painted
		setForeground(list.getSelectionForeground());
		setBackground(list.getSelectionBackground());
	} else {
		setOpaque(false);
		setForeground(list.getForeground());
		setBackground(list.getBackground());
	}
	if (o instanceof ComboBoxModel) {
		setModel((ComboBoxModel) o);
	} else
		if (o != null) {
			setSelectedItem(o, false);
		}
}
public void configureAsRenderer(JTable table, IAboutToPaintListener listener, Object o, boolean isSelected) {
	fListener = listener;
	javax.swing.LookAndFeel laf = UIManager.getLookAndFeel();
	boolean enableWorkAround = false;
	if (isSelected) {
		setOpaque(true); // we have to set this in order to get background painted
		setBackground(table.getSelectionBackground());
		if (laf.getID().equals("Windows") && isSelected)		 {
		// FIX combo Windows bug: unselected items show up white on white otherwise
			setForeground(Color.black);
	}
		else
			setForeground(table.getSelectionForeground());
	}
	if (o instanceof ComboBoxModel) {
		setModel((ComboBoxModel) o);
	} else
		if (o != null) {
			setSelectedItem(o, false);
		}
}
/** This method is public as an implementation side effect. 
 *  do not call or override. 
 *
 * @see ListDataListener
 */
public void contentsChanged(ListDataEvent e) {
	ComboBoxModel mod = getModel();
	Object newSelectedItem = mod.getSelectedItem();
	if (newSelectedItem != null) {
		String s = newSelectedItem.toString();
		if (!((UiComboModelWrapper) mod).isPlaceholder(s))
			super.contentsChanged(e);
	} else
		super.contentsChanged(e);
	repaint();
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
/**
 * Returns the index of the currently selected item in the list. The result is not
 * always defined if the JComboBox box allows selected items that are not in the
 * list. Returns -1 if the receiving JComboBox has no selected item or if the 
 * selected item is not in the list of items.
 
 * @return an int specifying the currently selected list item, where 0 specifies
 *                the first item in the list, or -1 if no item is selected or if
 *                the currently selected item is not in the list
 */
public int getSelectedIndex() {
	Object sObject = dataModel.getSelectedItem();
	int i, c;
	Object obj;
	for (i = 0, c = dataModel.getSize(); i < c; i++) {
		obj = dataModel.getElementAt(i);
		if (obj == null)
			return -1;
		if (obj.equals(sObject))
			return i;
	}
	return -1;
}
/*
 * This method will be called when a mouse has been clicked outside the combo box's visible area.
 */
public void handleExternalMouseClicked(MouseEvent e) {
	if (!contains(e.getPoint())) {
		if (isPopupVisible())
			hidePopup();
	};
}
public void mouseClicked(MouseEvent me) {
}
public void mouseEntered(MouseEvent me) {
}
public void mouseExited(MouseEvent e) {
}
public void mousePressed(MouseEvent e) {
	if (!contains(e.getPoint())) {
		final UiJComboBox c = this;
		Runnable r = new Runnable() {
			public void run() {
				javax.swing.FocusManager focusManager = javax.swing.FocusManager.getCurrentManager();
				focusManager.focusNextComponent(c);
			}
		};
		SwingUtilities.invokeLater(r);
	}
}
public void mouseReleased(MouseEvent me) {
}
public void paint(Graphics g) {
	if (fListener != null)
		fListener.aboutToPaint();

	super.paint(g);
}
protected void processComponentKeyEvent(KeyEvent e) {
	if (e.getKeyCode() == KeyEvent.VK_SPACE) {
		if (!isEditable())
			showPopup();
	}
	repaintPopup();
	super.processComponentKeyEvent(e);
}
/*
 * The combo box popup does not close when the mouse is clicked outside its area.
 * Register a mouse listener on the container to close the popup if a mouse is clicked
 * outside the popup area.
 */

private void registerMouseListenersFor(Container comp) {
	if ((comp != null) && (comp != this)) {
		Component c[] = comp.getComponents();
		for (int i = 0; i < c.length; i++) {
			if (c[i] instanceof JComponent)
				registerMouseListenersFor((JComponent) c[i]);
		}
		addMouseListenerFor((JComponent) comp);
	}
}
/*
 * The combo box popup does not close when the mouse is clicked outside its area.
 * Register a mouse listener on the parent components to close the popup if a mouse is clicked
 * outside the popup area.
 */

public void registerMouseListenersForParentComponents() {
	Component p = this;
	Component parent = this.getRootPane();
	while (p != null) {
		parent = p;
		p = parent.getParent();
	}
	if (parent != null) {
		Component c[] = ((Container) parent).getComponents();
		for (int i = 0; i < c.length; i++) {
			if (c[i] instanceof JComponent)
				registerMouseListenersFor((JComponent) c[i]);
		}
		addMouseListenerFor((Container) parent);
	}
}
protected void repaintPopup() {
	if (isPopupVisible())
		showPopup();
}
public void setEditable(boolean aFlag) {
	super.setEditable(aFlag);
	Component parent = this.getParent();
	if (parent != null) {
		parent.validate();
		parent.repaint();
	}
}
/*
 * We override the setEditor method to remove the focus listener from the editor.
 * Swing triggers an actionPerformed when focus is lost. In ULC we prefer to trap the
 * actual actionPerformed event (enter key).
 * triggering actionPerformed with a focus loss is nasty when the combobox is associated
 * with a Trigger since the combobox will loose its focus and get the focus again which 
 * can get into a loop.
 */
public void setEditor(ComboBoxEditor anEditor) {
	ComboBoxEditor oldEditor = editor;
	if (editor != null)
		editor.removeActionListener(this);
	editor = anEditor;
	if (editor != null) {
		editor.addActionListener(this);
		try {
			JTextField field=(JTextField)editor.getEditorComponent();
			field.removeFocusListener((FocusListener)editor);
		} catch (Exception e) {
		}
	}
	firePropertyChange("editor", oldEditor, editor);
}
public void setSelectedIndex(int anIndex) {
	if (anIndex < 0) {
		setSelectedItem(null);
		return;
	}
	int size = dataModel.getSize();
	if (anIndex >= size)
		throw new IllegalArgumentException("setSelectedIndex: " + anIndex + " out of bounds");
	Object element = dataModel.getElementAt(anIndex);
	if (dataModel instanceof UiComboModelWrapper) {
		if (((UiComboModelWrapper) dataModel).isPlaceholder(element))
			 ((UiComboModelWrapper) dataModel).setPendingSelection(anIndex);
	}
	setSelectedItem(element);
}
public void setSelectedItem(Object anObject) {
	super.setSelectedItem(anObject);
	repaintPopup(); // necessary in an editable combo box while popup is showing the arrow keys do not track the current item.
}
public void setSelectedItem(Object anObject, boolean notify) {
	if (dataModel instanceof UiComboModelWrapper)
		 ((UiComboModelWrapper) dataModel).setSelectedItem(anObject, notify);
	else
		dataModel.setSelectedItem(anObject);
	repaintPopup();
}
}
