package com.ibm.ulc.ui.lists;

import javax.swing.table.*;
import javax.swing.*;
import java.awt.Component;
import com.ibm.ulc.ui.*;
public class UiJDefaultTableCellRenderer extends javax.swing.table.DefaultTableCellRenderer {
	protected UITable fTable = null;
	protected UIColumn fColumn = null;
	protected UILabel fHeaderRenderer = null;
/**
 * UiJDefaultTableCellRenderer constructor comment.
 */
public UiJDefaultTableCellRenderer(UITable table, UIColumn column, UILabel headerRenderer) {
	super();
	fTable = table;
	fColumn = column;
	fHeaderRenderer = headerRenderer;
	if (fHeaderRenderer == null)
		setHorizontalAlignment(JLabel.CENTER);
	else {
		setHorizontalAlignment(fHeaderRenderer.getHorizontalAlignment());
		setVerticalAlignment(fHeaderRenderer.getVerticalAlignment());
		JLabel c = (JLabel) fHeaderRenderer.getComponent();
		setEnabled(c.isEnabled());
		setFont(c.getFont());
		setForeground(c.getForeground());
		setBackground(c.getBackground());
		if (c.getIcon() != null)
			setIcon(c.getIcon());
	}
}
public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
	UIFont font = fColumn.getFont();
	if (font != null) {
		setFont(font.getFont());
	}
	if (fHeaderRenderer != null) {
		setHorizontalAlignment(fHeaderRenderer.getHorizontalAlignment());
		setVerticalAlignment(fHeaderRenderer.getVerticalAlignment());
		setHorizontalTextPosition(fHeaderRenderer.getHorizontalTextPosition());
		JLabel c = (JLabel) fHeaderRenderer.getComponent();
		setEnabled(c.isEnabled());
		setFont(c.getFont());
		setForeground(c.getForeground());
		setBackground(c.getBackground());
		setIcon(c.getIcon());
	} else
		if (table != null) {
			JTableHeader header = table.getTableHeader();
			if (header != null) {
				setForeground(header.getForeground());
				setBackground(header.getBackground());
				setFont(header.getFont());
			}
		}
	setText((value == null) ? "" : value.toString());
	setBorder(UIManager.getBorder("TableHeader.cellBorder"));
	return this;
}
public void updateUI() {
	super.updateUI();
	if (fHeaderRenderer != null) {
		JLabel c = (JLabel) fHeaderRenderer.getComponent();
		c.updateUI();
	}
}
}
