package com.ibm.ulc.ui.lists;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import java.awt.*;
import com.ibm.ulc.ui.*;

/**
 * This example shows how to create a simple JTreeTable component, 
 * by using a JTree as a renderer (and editor) for the cells in a 
 * particular column in the JTable.  
 *
 */
public class UiJTreeTable extends UiJTable {
	protected UiTreeTableCellRenderer fTreeRenderer;
public UiJTreeTable(UiTreeTableModelWrapper tmw, UITreeTable uiTreeTable) {
	super(tmw, uiTreeTable);
}
//Overriding this method here just to add an additional
//prepareEditor() call *after* the isCellEditable() check is done.
//This way, the isEditable() can answer true whenever we want the
//tree to go into editing mode - it can and flag the editor to answer
//super.get...() in the following prepareEditor call.

public boolean editCellAt(int row, int column, java.util.EventObject e) {
	if (isEditing()) {
		if (cellEditor != null) {
			boolean stopped = cellEditor.stopCellEditing();
			if (!stopped)
				return false;
		}
	}
	if (!isCellEditable(row, column))
		return false;
	TableCellEditor editor = getCellEditor(row, column);
	if (editor != null) {
		editorComp = prepareEditor(editor, row, column); //cannot remove this
		//line from here, else fTable is null in isCellEditable().

		if (editor.isCellEditable(e)) {
			editorComp = prepareEditor(editor, row, column); //do it once
			//more, having set the appropriate flag during isCellEditable() !!
			editorComp.setBounds(getCellRect(row, column, false));
			this.add(editorComp);
			editorComp.validate();
			setCellEditor(editor);
			setEditingRow(row);
			setEditingColumn(column);
			editor.addCellEditorListener(this);
			return true;
		}
	}
	return false;
}
public UiTreeTableCellRenderer getTreeRenderer() {
	return fTreeRenderer;
}
public Object requestValue(int rowIndex, String colId) {
	if (fList != null) {
		UiTreeTableModelWrapper model = (UiTreeTableModelWrapper) getModel();
		return ((UIHierarchicalItemList) fList.getItemList()).getValueAtOid(model.indexToOid(rowIndex), colId);
	} else
		return null;
}
public void setFont(Font font) {
	super.setFont(font);
	if (fTreeRenderer != null)
		fTreeRenderer.setFont(font);
}
public void setTreeRendererFrom(UiTreeModelWrapper treeModel, UITreeTable uiTreeTable) {
	fTreeRenderer = new UiTreeTableCellRenderer(treeModel, this);
	((UiTreeTableModelWrapper) getModel()).setTreeModelWrapper(treeModel);
	fTreeRenderer.addTreeExpansionListener(uiTreeTable);
	((UiTreeTableModelWrapper) getModel()).setTree(fTreeRenderer);


	// Force the JTable and JTree to share their row selection models. 
	fTreeRenderer.setSelectionModel(new DefaultTreeSelectionModel() {
		// Extend the implementation of the constructor, as if: 
		public void UiJTreeTable() {
			setSelectionModel(getSelectionModel());
		}
	});
	// Make the tree and table row heights the same. 
	fTreeRenderer.setRowHeight(getRowHeight());
	// Install the tree editor renderer and editor.
	setDefaultRenderer(TreeModel.class, fTreeRenderer);
	setDefaultEditor(TreeModel.class, new UiTreeTableCellEditor(fTreeRenderer));
	fTreeRenderer.setEditable(true);
	setShowGrid(false);
	setIntercellSpacing(new Dimension(0, 0));
}
public boolean ulcIsCellEditable(int row, int column) {
	UIColumn uiColumn = getUiColumnFor(column);
	return uiColumn.ulcIsEditable();
}
/**
 * Overridden to message super and forward the method to the tree.
 * Since the tree is not actually in the component hieachy it will
 * never receive this unless we forward it in this manner.
 */
public void updateUI() {
	super.updateUI();
	if (getTreeRenderer() != null) {
		getTreeRenderer().updateUI();
	}
	// Use the tree's default foreground and background colors in the
	// table. 
	LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
}
}
