package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import com.ibm.ulc.ui.UI;
import com.ibm.ulc.base.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.dataTypes.*;
public class UiTableModelWrapper extends AbstractTableModel implements IItemListListener, IDefaults {
	protected UIItemList fItemList = null;
	protected Vector fColumns = new Vector();
/**
 * Add a listener to the list that's notified each time a change
 * to the data model occurs.
 * @param l the ListDataListener
 */
public UiTableModelWrapper(UIItemList itemList) {
	setItemList(itemList);
}
public void addColumn(UIColumn uiColumn) {
	if (uiColumn != null) {
		TableColumn col = uiColumn.getTableColumn();
		int ix = fColumns.size();
		col.setModelIndex(ix);
		fColumns.addElement(uiColumn);	//Receiver now holds UIColumn(s), not TableColumn(s)
	}
}
/**
 * break reference to TableModel.
 */
public void free() {
	if (fItemList != null) {
		fItemList.removeListener(this);
		fItemList = null;
	}
	if (fColumns != null) {
		fColumns.removeAllElements();
		fColumns = null;
	}
}
public UiTableColumn getColumn(int col) {
	try {
		return ((UIColumn) fColumns.elementAt(col)).getTableColumn();
	}
	catch (Exception e) {
	}
	return null;
}
 	public int getColumnCount() {	// 051
 		return fColumns.size();
 	}   
 	public Object getColumnIdentifier(int col) {	// 051
 		TableColumn column= getColumn(col);
		if (column != null)
			return column.getIdentifier();
		return null; //happens when an internal column (i.e. not the last one) is removed :
					//since the table keeps the list in a index-changing state, while the model
					//does not re-order it's elements on removal.
 	}   
	public int getColumnIndex(Object colId) {	// 051
		Enumeration e= fColumns.elements();
		//System.out.print("getColumnIndex(" + colId + ") ");
		for (int ix= 0; e.hasMoreElements(); ix++) {
			TableColumn tm= ((UIColumn) e.nextElement()).getTableColumn();
			Object id= tm.getIdentifier();
			//System.out.print(id + " ");
			if (id.equals(colId)) {
				//System.out.println(" found " + ix);
				return ix;
			}	
		}
		//System.out.println(" not found");
		return -1;
	}
 	public String getColumnName(int col) {	// 051
 		Object o= getColumnIdentifier(col);
 		if (o != null)
 			return o.toString();
 		//System.out.println("TableModelWrapper.getColumnName: no column id at " + col);
 		return "???";
 	}   
public int getNotificationPolicy() {
	return fItemList.getItemCache().getModel().getNotificationPolicy();
}
public int getRowCount() {
	if (fItemList != null)
		return fItemList.getRowCount();
	return 0;
}
public UIColumn getUiColumn(int col) {
	try {
		return (UIColumn) fColumns.elementAt(col);
	}
	catch (Exception e) {
	}
	return null;
}
public Vector getUiColumns() {
	return fColumns;
}
public Object getValueAt(int row, int col) { // 051
	if (fItemList != null) {
		String colId = (String) getColumnIdentifier(col);
		Object value = fItemList.getValueAt(row, colId);
		if ((value instanceof InvalidCell) || (value instanceof PendingCell))
			return value; // don't mess with this, else no lazy-loading occurs !
		return validateForDisplay(getUiColumn(col), value);
	}
	return "no model";
}
public boolean isCellEditable(int rowIndex, int columnIndex) {
	UiTableColumn column = getColumn(columnIndex);
	if (column != null)
		return column.getUIColumn().isEditable();
	return false;
}
/* 
 * For now, only text fields are validated. Also, we assume that
 * the validation is done on focus change, so "immediate" (i.e.
 * on each key-stroke) is not yet supported.
 */
public boolean isValid(Object value, UIColumn uiColumn) {
	int validationPolicy= TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE;
	if ((uiColumn != null) && (uiColumn.getDataType() != null) && (value instanceof String)) {
		try {
			uiColumn.getDataType().convertToObject(validationPolicy, (String) value, null);
			return true;
		}
		catch (DataTypeConversionException e) {
			UI.beep();
			return false;
		}
	}
	return true;
}
public void notify(int type, String[] attributeNames, int start, int end) {
	//System.out.println("Table.notify: " + type + ", " + colId + ", " + start + ", " + end);
	switch (type) {
		case TABLE_MODEL_CONTENTS_CHANGED :
			fireTableDataChanged();
			break;
		case TABLE_MODEL_ROWS_ADDED :
			fireTableRowsInserted(start, end);
			break;
		case TABLE_MODEL_ROWS_REMOVED :
		case 99 :
			fireTableRowsDeleted(start, end);
			break;
		case TABLE_MODEL_ROWS_CHANGED :
			fireTableRowsUpdated(start, end);
			break;
		case TABLE_MODEL_CELL_CHANGED :
			for (int i = 0; i < attributeNames.length; i++) {
				int ix = getColumnIndex(attributeNames[i]);
				if (ix >= 0)
					for (int j = start; j <= end; j++) {
						fireTableCellUpdated(j, ix);
					}
			}
			break;
	}
}
public void removeColumn(UIColumn uiColumn) {
	if (uiColumn != null) {
		fColumns.removeElement(uiColumn);
	}
}
public void requestString(int row, String colId) {
	if (fItemList != null)
		fItemList.getItemCache().requestAttribute(row, colId);
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
protected void setItemList(UIItemList itemList) {
	if (fItemList != null)
		fItemList.removeListener(this);
	fItemList = itemList;
	if (fItemList != null)
		fItemList.addModelListener(this);
}
/**
 * Flush the buffer if a different row is selected.
 */
public void setRowToBeEdited(int index) {
	fItemList.setRowToBeEdited(index);
}
public void setValueAt(Object input, int row, int col) { // 051
	if (fItemList == null)
		return;
	UIColumn uiColumn = getUiColumn(col);
	String colId = (String) getColumnIdentifier(col);
	if (shouldValidate(input, uiColumn)) {
		Object value = validate(input, uiColumn);
		fItemList.setValue(row, colId, value, getNotificationPolicy());
	} else {
		fItemList.setValue(row, colId, input, getNotificationPolicy());
	}
}
/* 
 * For now, only text fields are validated. Also, we assume that
 * the validation is done on focus change, so "immediate" (i.e.
 * on each key-stroke) is not yet supported.
 */
public boolean shouldValidate(Object value, UIColumn uiColumn) {
	if ((uiColumn != null) && (uiColumn.getDataType() != null) && (value instanceof String))
		return true;
	else
		return false;
}
public void startRequest() {
	if (fItemList != null)
		fItemList.startRequest();
}
public void stopRequest() {
	if (fItemList != null)
		fItemList.stopRequest();
}
/* 
 * Validate the contents of the column using the specified dataType
 */
public Object validate(Object value, UIColumn uiColumn) {
	return uiColumn.validate(value);
}
public Object validateForDisplay(UIColumn uiColumn, Object value) {
	return uiColumn.validateForDisplay(value);
}
}
