package com.ibm.ulc.ui.lists;

import javax.swing.*;
import javax.swing.tree.*;
import java.awt.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.base.IDummyCell;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.comm.Common;
/**
 * This class is used for rendering a tree which needs to display
 * just it's icon and label, with no additional attributes. 
 */
public class UiTreeCellRenderer extends JLabel implements TreeCellRenderer {
	//transient protected Font				fFont;
	transient protected ImageIcon fCollapsedIcon;
	transient protected ImageIcon fExpandedIcon;
	transient protected ImageIcon fLeafIcon;
	protected TreeModel fTreeModel;
	protected UiDefaultMutableTreeNode fNode; // the node being rendered
	private boolean fIsPainting; //To distinguish in getTreeCellRendererCompnent(..).
	protected boolean fIsLeaf;
	protected int fRow;
	protected UiJTable fTable;
	protected JTree fTree;
	protected String fColumnAttribute;
public UiTreeCellRenderer(JTree tree, UiJTable table) {
	fTable= table;
	fTree= tree;
}
public void free() {
	//fFont= null;
	fCollapsedIcon= null;
	fExpandedIcon= null;
	fLeafIcon= null;
	if (fNode != null) {
		fNode.free();
		fNode= null;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/99 10:32:35 AM)
 * @return java.lang.String
 */
public java.lang.String getColumnAttribute() {
	return fColumnAttribute;
}
/**
  * This is messaged from JTree whenever it needs to get the size
  * of the component or it wants to draw it.
  * This attempts to set the font based on value, which will be
  * a TreeNode.
  */
public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
	fNode = (UiDefaultMutableTreeNode) value;
	fTreeModel = (UiTreeModelWrapper) tree.getModel();
	fRow = row;
	setValue(value);
	fIsLeaf = leaf;
	setFont(tree.getFont());
	return this;
}
protected UI getUi() {
	return (UI) fTable.getConnection().find(Common.FACTORY_ID);
}
public boolean isReallyPainting() {
	return fIsPainting;
}
/**
 * Painting an invalidNode invloves making an async.
 * request for nodes frm the ULC side.
 */
public void paint(Graphics g) {
	fIsPainting = true;
	setColors();
	super.paint(g);
	fIsPainting = false;
}
public void setColors() {
	Color bColor;
	if (fTable.isRowSelected(fRow)) {
		setOpaque(true);
		setForeground(fTable.getSelectionForeground());
		setBackground(fTable.getSelectionBackground());
	} else {
		setOpaque(false);
		setForeground(fTable.getForeground());
		setBackground(fTable.getBackground());
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/99 10:32:35 AM)
 * @param newColumnAttribute java.lang.String
 */
public void setColumnAttribute(java.lang.String newColumnAttribute) {
	fColumnAttribute = newColumnAttribute;
}
/**
 * Set the calue for the given node, from the cache. Note that this method
 * gets called in two separate cases, one when the tree is just calculating the
 * total size, and the other when the actual paint is occuring. For lazy-loading
 * to work, we ensure that the cache makes requests to the UI only when painting.
 * So that only the nodes getting painted are requested.
 *
 * @see isReallyPainting()
 */
public void setValue(Object value) {
	Object val = null;
	fNode = (UiDefaultMutableTreeNode) value;
	if (fNode != null) {
		UiItemCache cache = fNode.getItemCache();
		if (cache != null) {
			if (cache.fRequestsStarted != 0) {
				if (isReallyPainting())
					val = cache.getValue(fNode.getId(), getColumnAttribute());
				else
					val = cache.getExistingValue(fNode.getId(), getColumnAttribute());
			} else {
				val = "";
			}
		}
		if (val != null) {
			if (val instanceof UILabel) {
				UILabel uiLabel = (UILabel) val;
				setText(uiLabel.getText());
				setIcon(uiLabel.getIcon());
			} else
				if (val instanceof IDummyCell) {
					IDummyCell dummy = (IDummyCell) val;
					setText(dummy.toWaitingString(getUi()));
					setIcon(null);
				} else {
					setText(val.toString());
					setIcon(null);
				}
		}
	}
}
}
