package com.ibm.ulc.ui.lists;

import java.awt.*;
import javax.swing.JTree;
import javax.swing.JTable;
import javax.swing.table.*;
import javax.swing.tree.*;
import com.ibm.ulc.ui.lists.*;
/**
 * (c) Object Technology International 1997,1998.
 */
public class UiTreeTableCellRenderer extends JTree implements TableCellRenderer {
	protected int fVisibleRow;
	private UiJTable fTable;
	protected boolean fIsSelected;
public UiTreeTableCellRenderer(TreeModel model, UiJTable table) {
	super(model);
	setShowsRootHandles(true);
	fTable= table; 
	setCellRenderer(new UiTreeCellRenderer(this, fTable));
}
public JTable getTable() {
	return fTable;
}
public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
	fVisibleRow = row;
	fIsSelected = isSelected;
	//setColors();
	return this;
}
public void paint(Graphics g) {
	g.translate(0, -fVisibleRow * getRowHeight());
	setColors();
	super.paint(g);
}
public void setBounds(int x, int y, int w, int h) {
	super.setBounds(x, 0, w, fTable.getHeight());
}
public void setColors() {
	if (fIsSelected) {
		setOpaque(true);
		setForeground(fTable.getSelectionForeground());
		setBackground(fTable.getSelectionBackground());
	} else {
		setOpaque(false);
		setForeground(fTable.getForeground());
		setBackground(fTable.getBackground());
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/18/99 10:26:48 AM)
 * @param newColumnAttribute java.lang.String
 */
public void setColumnAttribute(java.lang.String newColumnAttribute) {
	((UiTreeCellRenderer) getCellRenderer()).setColumnAttribute(newColumnAttribute);
}
}
