package com.ibm.ulc.util;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.io.*;
import java.util.*;
public class AnythingReader2 implements IAnythingReader {
	private boolean fHasPutBack = false;
	private int fPutBack;
	private InputStream fIn = null;
	private Hashtable fKeys;

public AnythingReader2() {
	fKeys = new Hashtable();
//	fBuf = new byte[fCapacity];
}
public AnythingReader2(int putback) {
	this();
	putBack(putback);
}
/**
 * Creates the corresponding writer for this format
 */
public IAnythingWriter createWriter() {
	return new AnythingWriter2();
}
public boolean hasPutBack() {
	return fHasPutBack;
}
private Anything intRead() throws IOException {
	for (;;) {
		int c = fIn.read();
		switch (c) {
			case '*' :
				return new Anything();
			case 't' :
				return new Anything(true);
			case 'f' :
				return new Anything(false);
			case 'l' :
				return new Anything(readLong());
			case 'd' :
				String str = readString();
				if (str.equals("NaN"))
					return new Anything(Double.NaN);
				else
					return new Anything(new Double(str));
			case 's' :
				return new Anything(readString());
			case 'S' :
				return new Anything(new String(readChars()));
			case 'b' :
				return new Anything(readBytes());
			case 'o' :
				return new Anything(readSerializable());
			case 'a' :
				long s = readLong();
				Anything a = new Anything();
				for (int i = 0; i < s; i++) {
					switch (c = fIn.read()) {case '/' :
						a.put(readKey(), intRead());
						break;
					case ' ' :
						a.append(intRead());
						break;
					default :
						trouble("intRead", "unexpected char in array: " + (char) c);
						break;
				}
		}
		return a;
	default :
		trouble("intRead", "unexpected char: " + (char) c);
		break;
	}
}
}
public void putBack(int c) {
	fPutBack= c;
	fHasPutBack= true;
}
public Anything read(InputStream in) {
	try {
		return readExUnSynchronized(in);
	} catch (IOException e) {
	}
	return null;
}
private byte[] readBytes() throws IOException {
	long l = readLong();
	byte[] buf = new byte[ (int) l];
	if (l > 0) {
		int offset = 0;
		int len = (int) l;
		while (len > 0) {
			int n = fIn.read(buf, offset, len);
			if (n == -1)
				break;
			offset += n;
			len -= n;
		}
	}
	return buf;
}
private char[] readChars() throws IOException {
	long l = readLong();
	int len = (int) (l * 2);
	byte[] buf = new byte[len];
	if (l > 0) {
		int offset = 0;
		while (len > 0) {
			int n = fIn.read(buf, offset, len);
			if (n == -1)
				break;
			offset += n;
			len -= n;
		}
	}
	char[] cbuf = new char[ (int) l];
	int j = 0;
	for (int i = 0; i < l; i++) {
		int k = buf[j];
		if (k < 0)
			k = 256 + k;
		int k2 = buf[j + 1];
		if (k2 < 0)
			k2 = 256 + k2;
		cbuf[i] = (char) ((k << 8) + k2);
		j += 2;
	}
	return cbuf;
}
public synchronized Anything readEx(InputStream in) throws IOException {
	return readExUnSynchronized(in);
}
public Anything readExUnSynchronized(InputStream in) throws IOException {
	fIn = in;
	int c;
	if (fHasPutBack) {
		c = fPutBack;
		fHasPutBack = false;
	} else {
		c = fIn.read();
	}
	if (c != 'V')
		return null;
	//	trouble("read", "expected version tag 'V'");

	long version = readLong();
	if (version <= 1) {
		Anything a = intRead();
		c = fIn.read();
		if (c != 'E' && c != 'e')
			trouble("read", "expected 'E' at end");
		return a;
	}
	trouble("read", "wrong version");
	return null;
}
private String readKey() throws IOException {
	String s = readString();
	String ss = (String) fKeys.get(s);
	if (ss != null)
		return ss;
	fKeys.put(s, s);
	return s;
}
private long readLong() throws IOException {
	long l = 0;
	boolean negative = false;
	char c = (char) fIn.read();
	if (Character.isDigit(c)) {
		l = Character.digit(c, 10);
	} else
		if (c == '-') {
			negative = true;
		} else
			if (c != '+') {
				trouble("readLong", "got '" + c + "' expected [-+0-9]");
			}
	for (;;) {
		c = (char) fIn.read();
		if (!Character.isDigit(c))
			break;
		l = l * 10 + Character.digit(c, 10);
	}
	if (c != '-') {
		trouble("readLong", "expected '-' at end of number");
	}
	if (negative)
		return -l;
	return l;
}
private Serializable readSerializable() {
	try {
		return (Serializable) new ObjectInputStream(new ByteArrayInputStream(readBytes())).readObject();
	} catch (Exception e) {
		System.err.println(e);
	}
	return null;
}
private String readString() throws IOException {
	byte b[] = readBytes();
	StringBuffer sb = new StringBuffer(b.length);
	int t = 0;
	for (int i = 0; i < b.length; i++) {
		t = b[i];
		if (t < 0)
			t = t + 256;
		sb.append((char) t);
	}
	return sb.toString();
}
void trouble(String method, String what) throws IOException {
	UlcObject.trouble2("AnythingReader2." + method, what);
	throw new IOException();
}
}
