package com.ibm.ulc.util;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.io.*;
public class DebugThread extends Thread implements Serializable {
	private boolean fDebug = false;
	private static int fgInstanceCount = 0;
/**
 * DebugThread constructor comment.
 * @param target java.lang.Runnable
 */
public DebugThread(Runnable target) {
	super(target);
	addThread();
}
/**
 * DebugThread constructor comment.
 * @param target java.lang.Runnable
 * @param name java.lang.String
 */
public DebugThread(Runnable target, String name) {
	super(target, name);
	addThread();
}
/**
 * DebugThread constructor comment.
 * @param name java.lang.String
 */
public DebugThread(String name) {
	super(name);
	addThread();
}
/**
 * DebugThread constructor comment.
 * @param target java.lang.Runnable
 * @param name java.lang.String
 */
public DebugThread(ThreadGroup pool, Runnable target, String name) {
	super(pool, target, name);
	addThread();
}
	static synchronized void addThread() {
		fgInstanceCount++;
	}
	/**
 	 * Code to perform when this object is garbage collected.
 	 * 
 	 * Any exception thrown by a finalize method causes the finalization to
 	 * halt. But otherwise, it is ignored.
 	 */
	protected void finalize() throws Throwable {
		super.finalize();
		fgInstanceCount--;
	}
	static public void printInstances() {
		System.out.println("Threads: " + fgInstanceCount);
	}
}
