package com.ibm.ulc.util;

/**
 * hard halt on errors - useful with things like servlets where there are global
 * traps for all errors to make sure the server stays up - in that case things like
 * Assert won't work.
 * its also more convenient as you can resume execution
 */
public class Halt {
// halt execution  
static public void now() {
	when(true);
}
// halt execution unless condition is true
static public void unless(boolean condition) {
	when(!condition);
}
// halt execution when condition is true
static public void when(boolean condition) {
	if (condition) {
		try {
			/* Throw an exception if we are not in VAJ */
			Class debugClass = Class.forName("com.ibm.uvm.tools.DebugSupport");
			java.lang.reflect.Method method = debugClass.getMethod("halt", new Class[] {});
			method.invoke(debugClass, new Object[] {});
		} catch (Throwable e) {
			System.err.println("attempt to halt in non-VAJ environment");
		}
	}
}
// halt execution on null
static public void whenNull(Object object) {
	when(object == null);
}
}
