package com.ibm.ulc.util;

/**
 * (c) Object Technology International 1997,1998.
 */
import java.io.*;

public class UlcLog extends UlcObject implements ILogStream {
	String fLogFileName = null;
	FileOutputStream fLogWriter = null;
	boolean fLogFailed= false;
/**
 * (c) Object Technology International 1997,1998.
 * @param logFilename java.lang.String
 */
public UlcLog(String logFilename) {
	fLogFileName = logFilename;

}
/**
 * logPrint method comment.
 */
public synchronized void logPrint(byte[] bytes) {
	if (fLogFailed)
		return;
	fLogWriter = openLogFile(fLogFileName);
	if (fLogWriter != null) {
		try {
			fLogWriter.write(bytes);
			fLogWriter.close();
		}
		catch (Exception e) {
			System.out.println("UlcLog: error writing to log file: " + fLogFileName);
			System.out.println("UlcLog: Disabling logging");
			fLogFailed = true;
		}
	}
}
/**
 * logPrint method comment.
 */
public void logPrint(String logEntry) {
	logPrint(logEntry.getBytes());
}
/**
 * logPrintln method comment.
 */
public synchronized void logPrintln(byte[] bytes) {
	if (fLogFailed)
		return;
	fLogWriter = openLogFile(fLogFileName);
	if (fLogWriter != null) {
		try {
			fLogWriter.write(bytes);
			fLogWriter.write(13);
			fLogWriter.write(10);
			fLogWriter.close();
		}
		catch (Exception e) {
			System.out.println("UlcLog: Error writing to log file : " + fLogFileName);
			System.out.println("UlcLog: Disabling logging");
			fLogFailed = true;
		}
	}
}
/**
 * logPrintln method comment.
 */
public void logPrintln(String logEntry) {
	logPrintln(logEntry.getBytes());
}
/**
 * logPrint method comment.
 */
private FileOutputStream openLogFile(String logFileName) {
	if (fLogFailed)
		return null;
	try {
		return new FileOutputStream(logFileName, true);
	}
	catch (Exception e) {
		System.out.println("UlcLog: Error creating logfile: " + fLogFileName);
		System.out.println("UlcLog: Disabling logging");
		fLogFailed = true;
	}
	return null;
}
}
