package com.ibm.ulc.util;

import java.util.*;
/**
 * UlcRange is a class used to denote selection ranges.
 * Primary use is to collect a list of selected indices into a
 * list of continuous ranges to optimise the message traffic to the UI.
 *
 */
public class UlcRange {
	/**
	 * The <code>int</code> start index
	 */
	public int fStartIndex = -1;
	/**
	 * The <code>int</code> end index
	 */
	public int fEndIndex = -1;
/**
 * Return an instance of a UlcRange initialized with the start and end index specified.
 *
 */

public UlcRange(int start, int end) {
	fStartIndex = start;
	fEndIndex = end;
}
/**
 * Return an instance of a UlcRange initialized with the start and end index specified.
 *
 */

public UlcRange(Integer start, Integer end) {
	fStartIndex = start.intValue();
	fEndIndex = end.intValue();
}
/**
 * Return a vector of UlcRange instances created from a vector of indices.
 * The vector of indices is not assumed to be in sorted order.
 *
 */

static public Vector createFromIntArray(int[] source) {
	Vector ranges = new Vector();
	if (source.length == 0)
		return ranges;
	int[] sorted = new UlcSorter().sort(source);
	int start = sorted[0];
	int end = start;
	int tStart = start;
	for (int i = 1; i < sorted.length; i++) {
		int next = sorted[i];
		if ((next - tStart) == 1) {
			tStart = next;
			end = next;
		} else {
			ranges.addElement(new UlcRange(start, end));
			start = next;
			tStart = start;
			end = start;
		}
	}
	ranges.addElement(new UlcRange(start, end));
	return ranges;
}
/**
 * Return a vector of UlcRange instances created from a vector of indices.
 * The vector of indices is not assumed to be in sorted order.
 *
 */

static public Vector createFromVector(Vector source) {
	Vector v = new UlcSorter().sortIntegerVector(source);
	Vector ranges = new Vector();
	Enumeration e = v.elements();
	if (e.hasMoreElements()) {
		Integer start = (Integer) e.nextElement();
		if (start == null)
			return ranges;
		Integer end = start;
		Integer tStart = start;
		while (e.hasMoreElements()) {
			Integer next = (Integer) e.nextElement();
			if ((next.intValue() - tStart.intValue()) == 1) {
				tStart = next;
				end = next;
			} else {
				ranges.addElement(new UlcRange(start, end));
				start = next;
				tStart = start;
				end = start;
			}
		}
		ranges.addElement(new UlcRange(start, end));
	}
	return ranges;
}
/**
 * Create and answer an array containing the receiver as it's
 * elements.
 */
public int[] toArray() {
	int size = fEndIndex - fStartIndex + 1;
	int[] array = new int[size];
	int j = 0;
	for (int i = fStartIndex; i <= fEndIndex; i++) {
		array[j] = i;
		j= j + 1;
	}
	return array;
}
public String toString() {
	return "[" + Integer.toString(fStartIndex) + " - " + Integer.toString(fEndIndex) + "]";
}
/**
 * Create and answer an array containing the receiver as it's
 * elements.
 */
public Vector toVector() {
	int size = fEndIndex - fStartIndex;
	Vector answer = new Vector(size);
	for (int i = fStartIndex; i < fEndIndex; i++) {
		answer.addElement(new Integer(i));
	}
	return answer;
}
}
