package com.ibm.ulc.util;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
/**
 * For internal Ulc use only.
 */
import java.util.Vector;
import java.util.Enumeration;
public class UlcSorter {
/**
 * Sort the nodes in the given array in place.
 */
public void quickSort(int[] list, int left, int right) {
	int original_left = left;
	int original_right = right;
	int mid = list[ (left + right) / 2];
	do {
		while (list[left] < mid) {
			left++;
		}
		while (mid < list[right]) {
			right--;
		}
		if (left <= right) {
			int tmp = list[left];
			list[left] = list[right];
			list[right] = tmp;
			left++;
			right--;
		}
	} while (left <= right);
	if (original_left < right) {
		quickSort(list, original_left, right);
	}
	if (left < original_right) {
		quickSort(list, left, original_right);
	}
}
/**
 * Sort the nodes in the given array returning a sorted copy.
 */
public int[] sort(int[] toBeSorted) {
	int[] answer = new int[toBeSorted.length];
	System.arraycopy(toBeSorted, 0, answer, 0, toBeSorted.length);
	if (answer.length > 1)
		quickSort(answer, 0, answer.length - 1);
	return answer;
}
/**
 * Sort the vector containing Integer objects and return a copy containing the sorted result.
 */
public Vector sortIntegerVector(Vector toBeSorted) {
	if (toBeSorted.size() == 0)
		return toBeSorted;
	int[] ints = new int[toBeSorted.size()];
	for (int i = 0; i < ints.length; i++) {
		ints[i] = ((Integer) toBeSorted.elementAt(i)).intValue();
	}
	quickSort(ints, 0, ints.length - 1);
	Vector sortedVector = new Vector(toBeSorted.size());
	for (int i = 0; i < toBeSorted.size(); i++)
		sortedVector.addElement(new Integer(ints[i]));
	return sortedVector;
}
/**
 * Internal 
 */
public int[][] sortToIntervals(int[] coll) {
	Vector temp = new Vector();
	if (coll.length == 0)
		return new int[0][];
	int start = coll[0];
	int end = start;
	if (coll.length > 1) {
		int[] sorted = sort(coll);
		start = sorted[0];
		end = start;
		for (int i = 1; i < sorted.length; i++) {
			int next = sorted[i];
			if (next - end == 1) {
				end = next;
			} else {
				Vector v = new Vector(2);
				v.insertElementAt(new Integer(start), 0);
				v.insertElementAt(new Integer(end), 1);
				temp.addElement(v);
				end = next;
				start = next;
			}
		}
	}
	Vector v = new Vector(2);
	v.insertElementAt(new Integer(start), 0);
	v.insertElementAt(new Integer(end), 1);
	temp.addElement(v);
	int s = temp.size();
	int[][] answer = new int[s][2];
	for (int i = 0; i < temp.size(); i++) {
		answer[i][0] = ((Integer) ((Vector) temp.elementAt(i)).elementAt(0)).intValue();
		answer[i][1] = ((Integer) ((Vector) temp.elementAt(i)).elementAt(1)).intValue();
	}
	return answer;
}
}
