package com.ibm.ulc.vaedit;

import java.text.*;
import java.awt.*;
import java.beans.*;
import java.awt.event.*;
import com.ibm.ulc.application.*;
/**
 * ULCAccelerator Property Editor
 * Creation date: (08-19-99 1:37:42 PM)
 * @author: Richard L. Kulp
 */
public class ULCAcceleratorEditor extends PropertyEditorSupport {
	private static java.util.ResourceBundle resVaEditStrings = java.util.ResourceBundle.getBundle("ulcvaedit");
	private UlcAcceleratorCustomEditor fCustomEditor;
/**
 * ULCAcceleratorEditor constructor comment.
 */
public ULCAcceleratorEditor() {
	super();
}
/**
 * Return the accelerator in displayable format.
 * Creation date: (08-19-99 1:51:34 PM)
 * @return java.lang.String
 */
public String getAsText() {
	ULCAccelerator accel = (ULCAccelerator) getValue();
	if (accel != null) {
		MessageFormat displayFormat = new MessageFormat(resVaEditStrings.getString("accel.display.format"));
		String keyText = KeyEvent.getKeyModifiersText(accel.getModifiers());
		int keyCode = accel.getKeyCode();
		if (keyCode != 0)
			if (keyText.length() > 0)
				keyText = keyText + "+" + KeyEvent.getKeyText(keyCode);
			else
				keyText = KeyEvent.getKeyText(keyCode);
		return displayFormat.format(new Object[] {keyText, resVaEditStrings.getString(accel.isOnKeyRelease() ? "accel.display.keyrelease" : "accel.display.keypress")});
	}
	return "";
}
public Component getCustomEditor() {
	if (fCustomEditor == null) {
		ULCAccelerator anAccel = (ULCAccelerator)getValue();
		if (anAccel == null) {
			fCustomEditor = new UlcAcceleratorCustomEditor();
		} else {
			fCustomEditor = new UlcAcceleratorCustomEditor(anAccel);
		}
	}	
	return fCustomEditor;
}
/**
 * Answer a string that should go into the code generation for the accelerator value.
 * Creation date: (08-19-99 4:26:44 PM)
 * @return java.lang.String
 */
public String getJavaInitializationString() {
	if (getValue() == null)
		return null;
		
	ULCAccelerator accel = (ULCAccelerator) getValue();

	// Translate the key code into java code
	int keyCode = accel.getKeyCode();
	String keyCodeString;

	// Check for specific keycodes
	switch (keyCode) {
		case KeyEvent.VK_ENTER :
			keyCodeString = "java.awt.event.KeyEvent.VK_ENTER";
			break;
		case KeyEvent.VK_BACK_SPACE :
			keyCodeString = "java.awt.event.KeyEvent.VK_BACK_SPACE";
			break;
		case KeyEvent.VK_TAB :
			keyCodeString = "java.awt.event.KeyEvent.VK_TAB";
			break;
		case KeyEvent.VK_CANCEL :
			keyCodeString = "java.awt.event.KeyEvent.VK_CANCEL";
			break;
		case KeyEvent.VK_CLEAR :
			keyCodeString = "java.awt.event.KeyEvent.VK_CLEAR";
			break;
		case KeyEvent.VK_SHIFT :
			keyCodeString = "java.awt.event.KeyEvent.VK_SHIFT";
			break;
		case KeyEvent.VK_CONTROL :
			keyCodeString = "java.awt.event.KeyEvent.VK_CONTROL";
			break;
		case KeyEvent.VK_ALT :
			keyCodeString = "java.awt.event.KeyEvent.VK_ALT";
			break;
		case KeyEvent.VK_PAUSE :
			keyCodeString = "java.awt.event.KeyEvent.VK_PAUSE";
			break;
		case KeyEvent.VK_CAPS_LOCK :
			keyCodeString = "java.awt.event.KeyEvent.VK_CAPS_LOCK";
			break;
		case KeyEvent.VK_ESCAPE :
			keyCodeString = "java.awt.event.KeyEvent.VK_ESCAPE";
			break;
		case KeyEvent.VK_SPACE :
			keyCodeString = "java.awt.event.KeyEvent.VK_SPACE";
			break;
		case KeyEvent.VK_PAGE_UP :
			keyCodeString = "java.awt.event.KeyEvent.VK_PAGE_UP";
			break;
		case KeyEvent.VK_PAGE_DOWN :
			keyCodeString = "java.awt.event.KeyEvent.VK_PAGE_DOWN";
			break;
		case KeyEvent.VK_END :
			keyCodeString = "java.awt.event.KeyEvent.VK_END";
			break;
		case KeyEvent.VK_HOME :
			keyCodeString = "java.awt.event.KeyEvent.VK_HOME";
			break;
		case KeyEvent.VK_LEFT :
			keyCodeString = "java.awt.event.KeyEvent.VK_LEFT";
			break;
		case KeyEvent.VK_UP :
			keyCodeString = "java.awt.event.KeyEvent.VK_UP";
			break;
		case KeyEvent.VK_RIGHT :
			keyCodeString = "java.awt.event.KeyEvent.VK_RIGHT";
			break;
		case KeyEvent.VK_DOWN :
			keyCodeString = "java.awt.event.KeyEvent.VK_DOWN";
			break;
		case KeyEvent.VK_MULTIPLY :
			keyCodeString = "java.awt.event.KeyEvent.VK_MULTIPLY";
			break;
		case KeyEvent.VK_ADD :
			keyCodeString = "java.awt.event.KeyEvent.VK_ADD";
			break;
		case KeyEvent.VK_SEPARATER :
			keyCodeString = "java.awt.event.KeyEvent.VK_SEPARATER";
			break;
		case KeyEvent.VK_SUBTRACT :
			keyCodeString = "java.awt.event.KeyEvent.VK_SUBTRACT";
			break;
		case KeyEvent.VK_DECIMAL :
			keyCodeString = "java.awt.event.KeyEvent.VK_DECIMAL";
			break;
		case KeyEvent.VK_DIVIDE :
			keyCodeString = "java.awt.event.KeyEvent.VK_DIVIDE";
			break;
		case KeyEvent.VK_F1 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F1";
			break;
		case KeyEvent.VK_F2 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F2";
			break;
		case KeyEvent.VK_F3 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F3";
			break;
		case KeyEvent.VK_F4 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F4";
			break;
		case KeyEvent.VK_F5 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F5";
			break;
		case KeyEvent.VK_F6 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F6";
			break;
		case KeyEvent.VK_F7 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F7";
			break;
		case KeyEvent.VK_F8 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F8";
			break;
		case KeyEvent.VK_F9 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F9";
			break;
		case KeyEvent.VK_F10 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F10";
			break;
		case KeyEvent.VK_F11 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F11";
			break;
		case KeyEvent.VK_F12 :
			keyCodeString = "java.awt.event.KeyEvent.VK_F12";
			break;
		case KeyEvent.VK_DELETE :
			keyCodeString = "java.awt.event.KeyEvent.VK_DELETE";
			break;
		case KeyEvent.VK_NUM_LOCK :
			keyCodeString = "java.awt.event.KeyEvent.VK_NUM_LOCK";
			break;
		case KeyEvent.VK_SCROLL_LOCK :
			keyCodeString = "java.awt.event.KeyEvent.VK_SCROLL_LOCK";
			break;
		case KeyEvent.VK_PRINTSCREEN :
			keyCodeString = "java.awt.event.KeyEvent.VK_PRINTSCREEN";
			break;
		case KeyEvent.VK_INSERT :
			keyCodeString = "java.awt.event.KeyEvent.VK_INSERT";
			break;
		case KeyEvent.VK_HELP :
			keyCodeString = "java.awt.event.KeyEvent.VK_HELP";
			break;
		case KeyEvent.VK_META :
			keyCodeString = "java.awt.event.KeyEvent.VK_META";
			break;
		case KeyEvent.VK_BACK_QUOTE :
			keyCodeString = "java.awt.event.KeyEvent.VK_BACK_QUOTE";
			break;
		case KeyEvent.VK_QUOTE :
			keyCodeString = "java.awt.event.KeyEvent.VK_QUOTE";
			break;
		case KeyEvent.VK_FINAL :
			keyCodeString = "java.awt.event.KeyEvent.VK_FINAL";
			break;
		case KeyEvent.VK_CONVERT :
			keyCodeString = "java.awt.event.KeyEvent.VK_CONVERT";
			break;
		case KeyEvent.VK_NONCONVERT :
			keyCodeString = "java.awt.event.KeyEvent.VK_NONCONVERT";
			break;
		case KeyEvent.VK_ACCEPT :
			keyCodeString = "java.awt.event.KeyEvent.VK_ACCEPT";
			break;
		case KeyEvent.VK_MODECHANGE :
			keyCodeString = "java.awt.event.KeyEvent.VK_MODECHANGE";
			break;
		case KeyEvent.VK_KANA :
			keyCodeString = "java.awt.event.KeyEvent.VK_KANA";
			break;
		case KeyEvent.VK_KANJI :
			keyCodeString = "java.awt.event.KeyEvent.VK_KANJI";
			break;
		default :
			if (keyCode >= KeyEvent.VK_NUMPAD0 && keyCode <= KeyEvent.VK_NUMPAD9) {
				char c = (char) (keyCode - KeyEvent.VK_NUMPAD0 + '0');
				keyCodeString = "java.awt.event.KeyEvent.VK_NUMPAD" + c;
			} else {
				int charType = Character.getType((char)keyCode);
				if (keyCode <= 256 && charType != Character.UNASSIGNED && charType != Character.CONTROL)
					if ((char) keyCode == '\\' || (char) keyCode == '\'')
						keyCodeString = "'\\" + String.valueOf((char) keyCode) + "'"; // It is an escape required character
					else
						keyCodeString = "'" + String.valueOf((char) keyCode) + "'"; // It is a standard character
				else {
					// Not directly displayable, so make is a unicode escape sequence
					String hexCode = Integer.toString(keyCode, 16);
					if (hexCode.length() < 4)
						hexCode = ("0000".substring(0, 4 - hexCode.length())) + hexCode; // Needs to be padded
					keyCodeString = "\\u" + hexCode;
				}
			}
	};

	// Now we do the modifiers
	int modifiers = accel.getModifiers();
	String modifiersString = ", ";
	if ((modifiers & InputEvent.CTRL_MASK) != 0)
		modifiersString += "java.awt.event.InputEvent.CTRL_MASK+";
	if ((modifiers & InputEvent.ALT_MASK) != 0)
		modifiersString += "java.awt.event.InputEvent.ALT_MASK+";
	if ((modifiers & InputEvent.META_MASK) != 0)
		modifiersString += "java.awt.event.InputEvent.META_MASK+";
	if ((modifiers & InputEvent.SHIFT_MASK) != 0)
		modifiersString += "java.awt.event.InputEvent.SHIFT_MASK+";
	if (modifiers == 0)
		modifiersString += "0, "; // Default, need a value
	else
		modifiersString = modifiersString.substring(0, modifiersString.length() - 1) + ", "; // Strip trailing '+' and add ", "

	// Now we can format the java text.
	return "ULCAccelerator.getAccelerator(" + keyCodeString + modifiersString + (new Boolean(accel.isOnKeyRelease()).toString()) + ")";
}
public Object getValue() {
	if (fCustomEditor != null) {
		return fCustomEditor.getAcceleratorValue();
	} else {
		return super.getValue();
	}
}
public void setAsText(String text) throws IllegalArgumentException {
	throw new IllegalArgumentException(text);
}
public void setValue(Object newValue) {
	if (newValue != null && !(newValue instanceof ULCAccelerator))
		super.setValue(null);	// An invalid value.
	else
		super.setValue(newValue);
	
	if (fCustomEditor != null) {
		fCustomEditor.setAcceleratorValue((ULCAccelerator)getValue());
	}	
}
public boolean supportsCustomEditor() {
	return true;
}
}
