package com.ibm.ulc.vaedit;

import java.awt.*;
/**
 * Insert type's description here.
 */
public class UlcCellWidget extends javax.swing.JPanel {
	public static final char ALIGNMENT_BOTTOM = 'b';
	protected static final int ARROWHEAD_SIZE = 3;
	protected static final int ARROW_SHAFT_LENGTH = 7;
	public static final char ALIGNMENT_TOP = 't';
	public static final char ALIGNMENT_LEFT = 'l';
	public static final char ALIGNMENT_RIGHT = 'r';
	public static final char ALIGNMENT_CENTER = 'c';
	public static final char ALIGNMENT_EXPAND = 'e';
	protected boolean fDoDraw = false;
	protected String fAlignment = "" + ALIGNMENT_EXPAND + ALIGNMENT_EXPAND;
	protected Dimension fEmptyMinimumSize = new Dimension(50,36);
	protected int fMargin = 0;	// Current margin for this cell.
/**
 * UlcCell constructor comment.
 */
public UlcCellWidget() {
	super();
	setLayout(new GridBagLayout());
}
/**
 * We have a new component. Need to set the current
 * constraints onto it.
 */
protected void addImpl(Component comp, Object constraints, int index) {
	super.addImpl(comp, constraints, index);
	setComponentConstraints(comp);
}
/**
 * Draw the appropriate alignment arrows
 */
protected void drawAlignment(Graphics g) {
	g.setColor(Color.gray);
	if (isLeftAligned() || isHorizontalExpanded())
		drawArrowLeft(g);
	if (isRightAligned() || isHorizontalExpanded())
		drawArrowRight(g);
	if (isTopAligned() || isVerticalExpanded())
		drawArrowTop(g);
	if (isBottomAligned() || isVerticalExpanded())
		drawArrowBottom(g);
}
/**
 * Draw the bottom alignment arrow
 */
protected void drawArrowBottom(Graphics g) {
	Polygon arrowHead = new Polygon();
	int xPoint = (getWidth()-1)/2;
	int yPoint = getHeight()-2;
	arrowHead.addPoint(xPoint, yPoint);
	arrowHead.addPoint(xPoint - ARROWHEAD_SIZE, yPoint - ARROWHEAD_SIZE);
	arrowHead.addPoint(xPoint + ARROWHEAD_SIZE, yPoint - ARROWHEAD_SIZE);
	arrowHead.addPoint(xPoint, yPoint);

	g.drawPolygon(arrowHead);
	g.fillPolygon(arrowHead);

	g.drawLine(xPoint, yPoint, xPoint, yPoint-ARROW_SHAFT_LENGTH);
}
/**
 * Draw the left alignment arrow
 */
protected void drawArrowLeft(Graphics g) {
	Polygon arrowHead = new Polygon();
	int yPoint = (getHeight()-1)/2;
	arrowHead.addPoint(1, yPoint);
	arrowHead.addPoint(1 + ARROWHEAD_SIZE, yPoint - ARROWHEAD_SIZE);
	arrowHead.addPoint(1 + ARROWHEAD_SIZE, yPoint + ARROWHEAD_SIZE);
	arrowHead.addPoint(1, yPoint);

	g.drawPolygon(arrowHead);
	g.fillPolygon(arrowHead);

	g.drawLine(1, yPoint, 1 + ARROW_SHAFT_LENGTH, yPoint);
}
/**
 * Draw the right alignment arrow
 */
protected void drawArrowRight(Graphics g) {
	Polygon arrowHead = new Polygon();
	int xPoint = getWidth()-2;
	int yPoint = (getHeight()-1)/2;
	arrowHead.addPoint(xPoint, yPoint);
	arrowHead.addPoint(xPoint - ARROWHEAD_SIZE, yPoint - ARROWHEAD_SIZE);
	arrowHead.addPoint(xPoint - ARROWHEAD_SIZE, yPoint + ARROWHEAD_SIZE);
	arrowHead.addPoint(xPoint, yPoint);

	g.drawPolygon(arrowHead);
	g.fillPolygon(arrowHead);

	g.drawLine(xPoint, yPoint, xPoint - ARROW_SHAFT_LENGTH, yPoint);
}
/**
 * Draw the bottom alignment arrow
 */
protected void drawArrowTop(Graphics g) {
	Polygon arrowHead = new Polygon();
	int xPoint = (getWidth()-1)/2;
	arrowHead.addPoint(xPoint, 1);
	arrowHead.addPoint(xPoint - ARROWHEAD_SIZE, 1 + ARROWHEAD_SIZE);
	arrowHead.addPoint(xPoint + ARROWHEAD_SIZE, 1 + ARROWHEAD_SIZE);
	arrowHead.addPoint(xPoint, 1);

	g.drawPolygon(arrowHead);
	g.fillPolygon(arrowHead);

	g.drawLine(xPoint, 1, xPoint, 1 + ARROW_SHAFT_LENGTH);
}
/**
 * Draw the dotted outline
 */
protected void drawOutline(Graphics g) {
	g.setColor(Color.gray);
	g.drawRect(0, 0, getWidth()-1, getHeight()-1);
}
/**
 * Query Alignment Attribute.
 */
public String getAlignment() {
	return fAlignment;
}
/**
 * Query DoDraw Attribute.
 */
public boolean getDoDraw() {
	return fDoDraw;
}
/**
 * getMinimumSize
 * If there is no component, return empty minimum size,
 * else let the default happen.
 */
public Dimension getMinimumSize() {
	if (getComponentCount() > 0)
	  return super.getMinimumSize();
	else
	  return fEmptyMinimumSize; 
}
/**
 * getPreferredSize
 * If there is no component, return empty minimum size,
 * else let the default happen.
 */
public Dimension getPreferredSize() {
	if (getComponentCount() > 0)
	  return super.getPreferredSize();
	else
	  return fEmptyMinimumSize; 
}
/**
 * Answer horizontal alignment
 */
protected char horizontalAlignment() {
	return fAlignment.charAt(0);
}
/**
 * Answer if bottom aligned
 */
public boolean isBottomAligned() {
	return (verticalAlignment() == ALIGNMENT_BOTTOM);
}
/**
 * Answer if horizontally centerd
 */
public boolean isHorizontalCentered() {
	return (horizontalAlignment() == ALIGNMENT_CENTER);
}
/**
 * Answer if horizontally expanded
 */
public boolean isHorizontalExpanded() {
	return (horizontalAlignment() == ALIGNMENT_EXPAND);
}
/**
 * Answer if left aligned
 */
public boolean isLeftAligned() {
	return (horizontalAlignment() == ALIGNMENT_LEFT);
}
/**
 * Answer if left aligned
 */
public boolean isRightAligned() {
	return (horizontalAlignment() == ALIGNMENT_RIGHT);
}
/**
 * Answer if top aligned
 */
public boolean isTopAligned() {
	return (verticalAlignment() == ALIGNMENT_TOP);
}
/**
 * Answer if vertically centered
 */
public boolean isVerticalCentered() {
	return (verticalAlignment() == ALIGNMENT_CENTER);
}
/**
 * Answer if vertically expanded
 */
public boolean isVerticalExpanded() {
	return (verticalAlignment() == ALIGNMENT_EXPAND);
}
/**
 * Do the appropriate drawing if drawing turned on and there are no components
 */
public void paint(Graphics g) {
	super.paint(g);
	if (fDoDraw) {
		if (getComponentCount() == 0)
			drawAlignment(g);
		drawOutline(g);
	}
}
/**
 * Set Alignment Attribute.
 */
public void setAlignment(String alignment) {
	if (alignment != fAlignment)
	{
		// We have a new alignment, revamp the
		// constraint on the component to this
		// new alignment.
		fAlignment = alignment;
		if (getComponentCount() > 0)
		  setComponentConstraints(getComponent(0));
	}
}
/**
 * setComponentConstraint
 *
 * Set the correct constraints for this component
 * because something has changed, or it is brand new.
 *
 */
protected void setComponentConstraints(Component c)
{
	GridBagConstraints constraints = new GridBagConstraints();
	constraints.weightx = 100;
	constraints.weighty = 100;
	constraints.gridx = 0;
	constraints.gridy = 0;
	constraints.insets = new Insets(fMargin, fMargin, fMargin, fMargin);
	if (isLeftAligned())
	  if (isTopAligned())
	    constraints.anchor = GridBagConstraints.NORTHWEST;
	  else if (isVerticalCentered())
	    constraints.anchor = GridBagConstraints.WEST;
	  else if (isBottomAligned())
	    constraints.anchor = GridBagConstraints.SOUTHWEST;
	  else if (isVerticalExpanded())
	  {
		constraints.anchor = GridBagConstraints.WEST;
		constraints.fill = GridBagConstraints.VERTICAL;
	  }
	  else ;	// Shouldn't get here
	else if (isHorizontalCentered()) 
	  if (isTopAligned())
	    constraints.anchor = GridBagConstraints.NORTH;
	  else if (isVerticalCentered())
	    constraints.anchor = GridBagConstraints.CENTER;
	  else if (isBottomAligned())
	    constraints.anchor = GridBagConstraints.SOUTH;
	  else if (isVerticalExpanded())
	  {
		constraints.anchor = GridBagConstraints.CENTER;
		constraints.fill = GridBagConstraints.VERTICAL;
	  }
	  else ;	// Shouldn't get here
	else if (isRightAligned())  
	  if (isTopAligned())
	    constraints.anchor = GridBagConstraints.NORTHEAST;
	  else if (isVerticalCentered())
	    constraints.anchor = GridBagConstraints.EAST;
	  else if (isBottomAligned())
	    constraints.anchor = GridBagConstraints.SOUTHEAST;
	  else if (isVerticalExpanded())
	  {
		constraints.anchor = GridBagConstraints.EAST;
		constraints.fill = GridBagConstraints.VERTICAL;
	  }
	  else ;	// Shouldn't get here
	else if (isHorizontalExpanded())
	{
	  constraints.fill = GridBagConstraints.HORIZONTAL;
	  if (isTopAligned())
	    constraints.anchor = GridBagConstraints.NORTH;
	  else if (isVerticalCentered())
	    constraints.anchor = GridBagConstraints.CENTER;
	  else if (isBottomAligned())
	    constraints.anchor = GridBagConstraints.SOUTH;
	  else if (isVerticalExpanded())
	  {
		constraints.anchor = GridBagConstraints.CENTER;
		constraints.fill = GridBagConstraints.BOTH;
	  }
	}
	
	((GridBagLayout)getLayout()).setConstraints(c, constraints);
	invalidate();
} 
/**
 * Set DoDraw Attribute.
 */
public void setDoDraw(boolean doDraw) {
	fDoDraw = doDraw;
}
/**
 * Set emptyMinimumSize Attribute.
 */
public void setEmptyMinimumSize(Dimension minSize) {
	fEmptyMinimumSize = minSize;
}
/**
 * setMargin(int newMargin)
 * We have a new margin for our cell.
 * Goto the component (if any) and change
 * the margin to the new margin.
 */
public void setMargin(int newMargin) {
	if (newMargin != fMargin)
	{
		// We have a new margin size, revamp the
		// constraint on the component to this
		// new margin.
		fMargin = newMargin;
		if (getComponentCount() > 0)
		  setComponentConstraints(getComponent(0));
  	  	invalidate();	// Let it layout the new alignment
	}
}
/**
 * Answer vertical alignment
 */
protected char verticalAlignment() {
	return fAlignment.charAt(1);
}
}
