package com.ibm.ulc.vaedit;

import javax.swing.*;
import javax.swing.event.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import com.ibm.uvm.abt.edit.*;
public class UlcIconCustomEditor extends JPanel {
private static java.util.ResourceBundle resabtedit = java.util.ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");  //$NON-NLS-1$
	private String savedFilename = null;
	private String savedURL = null;
	private static String savedDirectory = null;
	private ULCIconEditor propertyEditor = null;
	private ItemListener choiceListener, cacheOnUIListener = null;
	private DocumentListener documentListener = null;
	private FocusListener focusListener = null;
	private ActionListener genericActionListener = null;
	private PropertyChangeListener valueListener = null;
	private ButtonGroup ivjChoiceGroup = null;
	private JButton ivjFileBrowseButton = null;
	private JRadioButton ivjFileChoice = null;
	private JCheckBox ivjCacheOnUI = null;
	private FileDialog ivjFileDialog = null;
	private JPanel ivjJPanel1 = null;
	private FlowLayout ivjJPanel1FlowLayout = null;
	private JRadioButton ivjNoneChoice = null;
	private JLabel ivjPreviewLabel = null;
	private JPanel ivjPreviewPanel = null;
	private JTextField ivjSourceNameField = null;
	private JRadioButton ivjURLChoice = null;
	private boolean URLChoiceEnabled;
	private boolean sourceNameFieldChanged = false;
	private static java.util.ResourceBundle resulcedit = java.util.ResourceBundle.getBundle("ulcvaedit");
	private JComponent ivjWarningMessageArea;
public UlcIconCustomEditor(ULCIconEditor valueSource) {
	super();
	propertyEditor = valueSource;
	if (propertyEditor != null) {
		setURLChoiceEnabled(propertyEditor.getCustomEditorURLChoiceEnabled());
		Icon edValue = (Icon)(propertyEditor.getValue());
		propertyEditor.addPropertyChangeListener(getValueListener());
		getPreviewLabel().setIcon(edValue);
		if (edValue == null) {
			getNoneChoice().setSelected(true);
		} else if (edValue instanceof NamedImageIcon) {
			NamedImageIcon nImageIcon = (NamedImageIcon)edValue;
			if (nImageIcon.getSource() == NamedImageIcon.FILE) {
				savedFilename = nImageIcon.getSourceName();
				getFileChoice().setSelected(true);
			} else if (nImageIcon.getSource() == NamedImageIcon.URL) {
				setURLSave(nImageIcon.getSourceName());
				getURLChoice().setSelected(true);
			}
		} else {
			getFileChoice().setSelected(true);
		}
		getCacheOnUI().setSelected(propertyEditor.isCachedOnUI());
	}
	initialize();
}
private ItemListener getCachedOnUIListener() {
	if (cacheOnUIListener == null) {
		cacheOnUIListener = new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getSource() != null) {
					if (propertyEditor != null)
						propertyEditor.setCachedOnUI(isCachedOnUI());
				}
			}
		};
	}
	return cacheOnUIListener;
}
/**
 * Return the Cache On UI property value.
 * @return javax.swing.JCheckBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JCheckBox getCacheOnUI() {
	if (ivjCacheOnUI == null) {
		try {
			ivjCacheOnUI = new javax.swing.JCheckBox();
			ivjCacheOnUI.setName("CacheOnUI");
			ivjCacheOnUI.setSelected(false);
			ivjCacheOnUI.setText(resulcedit.getString("icon.custom.cacheOnUI"));
			ivjCacheOnUI.setEnabled(true);
			ivjCacheOnUI.addItemListener(getCachedOnUIListener());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCacheOnUI;
}
/**
 * Return the ChoiceGroup property value.
 * @return javax.swing.ButtonGroup
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ButtonGroup getChoiceGroup() {
	if (ivjChoiceGroup == null) {
		try {
			ivjChoiceGroup = new javax.swing.ButtonGroup();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjChoiceGroup;
}
private ItemListener getChoiceListener() {
	if (choiceListener == null) {
		choiceListener = new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getSource() != null && e.getSource() instanceof JRadioButton) {
					JRadioButton choice = (JRadioButton)(e.getSource());
					UlcIconCustomEditor.this.setUserState();
					if (choice == getNoneChoice()) {
						UlcIconCustomEditor.this.setValue(null);
					}
				}
			} 
		};
	}
	return choiceListener;
}
private DocumentListener getDocumentListener() {
	if (documentListener == null) {
		documentListener = new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				sourceNameFieldChanged = true;
			} 
			public void removeUpdate(DocumentEvent e) {
				sourceNameFieldChanged = true;
			} 
			public void insertUpdate(DocumentEvent e) {
				sourceNameFieldChanged = true;
			}
		};
	}
	return documentListener;
}
/**
 * Return the FileBrowseButton property value.
 * @return javax.swing.JButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JButton getFileBrowseButton() {
	if (ivjFileBrowseButton == null) {
		try {
			ivjFileBrowseButton = new javax.swing.JButton();
			ivjFileBrowseButton.setName("FileBrowseButton");
			ivjFileBrowseButton.setText(resabtedit.getString("FileBrowseButton_text"));
			ivjFileBrowseButton.setBackground(java.awt.SystemColor.control);
			ivjFileBrowseButton.setEnabled(true);
			// user code begin {1}
			ivjFileBrowseButton.addActionListener(getGenericActionListener());
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjFileBrowseButton;
}
/**
 * Return the FileChoice property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JRadioButton getFileChoice() {
	if (ivjFileChoice == null) {
		try {
			ivjFileChoice = new javax.swing.JRadioButton();
			ivjFileChoice.setName("FileChoice");
			ivjFileChoice.setSelected(true);
			ivjFileChoice.setText(resabtedit.getString("FileChoice_text"));
			ivjFileChoice.setEnabled(true);
			// user code begin {1}
			ivjFileChoice.addItemListener(getChoiceListener());
			getChoiceGroup().add(ivjFileChoice);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjFileChoice;
}
/**
 * Get a FileDialog that is modal to this (if possible)
 */
private FileDialog getFileDialog() {
	if (ivjFileDialog == null) {
		try {
			ivjFileDialog = new java.awt.FileDialog(new java.awt.Frame());
			ivjFileDialog.setName("FileDialog");
			addNotify();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjFileDialog;
}
private String getFilenameFromDialog() {
	FileDialog dialog = getFileDialog();
	String filename = null;
	String sep = java.io.File.separator;
	String prDir = sep + "project_resources" + sep; //$NON-NLS-1$
	String userDir = System.getProperty("user.dir", "."); //$NON-NLS-1$ //$NON-NLS-2$

	if (savedDirectory == null)
		savedDirectory = userDir;
	String defaultDir = savedDirectory;
	if (savedFilename != null && savedFilename.length() > 0) {
		String setFilename = savedFilename;
		if (setFilename.lastIndexOf(sep) > 0)
			setFilename = setFilename.substring(setFilename.lastIndexOf(sep) + 1);
		dialog.setFile(setFilename);
		defaultDir = savedFilename;
		int prInUser = userDir.indexOf(prDir);
		// directory is relative and userDir contains project_resources
		if (defaultDir.startsWith(".." + sep) && prInUser > 0) { //$NON-NLS-1$
			int prInDefault = defaultDir.indexOf(prDir);
			// directory contains project_resources
			if (prInDefault > 0)
				defaultDir = userDir.substring(0, prInUser + prDir.length()) + defaultDir.substring(prInDefault + prDir.length());
			else
				defaultDir = userDir.substring(0, prInUser + prDir.length()) + defaultDir.substring(3);
		}
		// strip off filename
		if (defaultDir.lastIndexOf(sep) > 0)
			defaultDir = defaultDir.substring(0, defaultDir.lastIndexOf(sep));
	}
	try { // make sure directory exists
		java.io.File testDir = new java.io.File(defaultDir);
		if (!testDir.isDirectory())
			defaultDir = savedDirectory;
	} catch (Exception exc) {
		defaultDir = savedDirectory;
	}
	dialog.setDirectory(defaultDir);
	getParent().setEnabled(false);
	dialog.setVisible(true);
	getParent().setEnabled(true);
	String specifiedDir = dialog.getDirectory();
	if (specifiedDir != null && specifiedDir.indexOf(prDir) > 0)
		savedDirectory = specifiedDir;
	String dialogFile = dialog.getFile();
	if (dialogFile != null && dialogFile.length() > 0) {
		filename = dialog.getDirectory() + dialogFile;
		// URL is set, then we can't use relative paths.
		if (!getURLChoice().isSelected() && propertyEditor != null && propertyEditor.getMakeFilePathRelative())
			filename = validateFilename(filename);
	}
	dialog.dispose();
	return filename;
}
private FocusListener getFocusListener() {
	if (focusListener == null) {
		focusListener = new FocusListener() {
			public void focusGained(FocusEvent e) {
			} 
			public void focusLost(FocusEvent e) {
				if (e.getSource().equals(getSourceNameField()) && sourceNameFieldChanged) 
					getSourceNameField().postActionEvent();
			} 
		};
	}
	return focusListener;
}
private ActionListener getGenericActionListener() {
	if (genericActionListener == null) {
		genericActionListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (e.getSource() == getFileBrowseButton()) {
					String newFilename = UlcIconCustomEditor.this.getFilenameFromDialog();
					if (newFilename != null) {
						if (UlcIconCustomEditor.this.getURLChoice().isSelected()) 
							newFilename = "file:/" + newFilename.replace(java.io.File.separatorChar, '/');	// Turn it into a url
						UlcIconCustomEditor.this.getSourceNameField().setText(newFilename);
						UlcIconCustomEditor.this.getSourceNameField().postActionEvent();
					}
				} else if (e.getSource() == getSourceNameField() && UlcIconCustomEditor.this.getFileChoice().isSelected()) {
					UlcIconCustomEditor.this.savedFilename = UlcIconCustomEditor.this.getSourceNameField().getText();
					UlcIconCustomEditor.this.setValue(UlcIconCustomEditor.this.savedFilename);
					sourceNameFieldChanged = false;
				} else if (e.getSource() == getSourceNameField() && UlcIconCustomEditor.this.getURLChoice().isSelected()) {
					try {
						UlcIconCustomEditor.this.setURLSave(UlcIconCustomEditor.this.getSourceNameField().getText());
						UlcIconCustomEditor.this.setValue(new java.net.URL(UlcIconCustomEditor.this.savedURL));
					} catch (java.lang.Throwable ivjExc) {
						handleException(ivjExc);
					}
				}
			}
		};
	}
	return genericActionListener;
}
/**
 * Return the JPanel1 property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JPanel getJPanel1() {
	if (ivjJPanel1 == null) {
		try {
			ivjJPanel1 = new javax.swing.JPanel();
			ivjJPanel1.setName("JPanel1");
			ivjJPanel1.setLayout(getJPanel1FlowLayout());
			ivjJPanel1.setBackground(java.awt.SystemColor.control);
			getJPanel1().add(getFileChoice(), getFileChoice().getName());
			getJPanel1().add(getURLChoice(), getURLChoice().getName());
			getJPanel1().add(getNoneChoice(), getNoneChoice().getName());
			getJPanel1().add(getCacheOnUI(), getCacheOnUI().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjJPanel1;
}
/**
 * Return the JPanel1FlowLayout property value.
 * @return java.awt.FlowLayout
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private FlowLayout getJPanel1FlowLayout() {
	java.awt.FlowLayout ivjJPanel1FlowLayout = null;
	try {
		/* Create part */
		ivjJPanel1FlowLayout = new java.awt.FlowLayout();
		ivjJPanel1FlowLayout.setAlignment(java.awt.FlowLayout.LEFT);
		ivjJPanel1FlowLayout.setVgap(0);
		ivjJPanel1FlowLayout.setHgap(10);
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	};
	return ivjJPanel1FlowLayout;
}
/**
 * Return the NoneChoice property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JRadioButton getNoneChoice() {
	if (ivjNoneChoice == null) {
		try {
			ivjNoneChoice = new javax.swing.JRadioButton();
			ivjNoneChoice.setName("NoneChoice");
			ivjNoneChoice.setText(resabtedit.getString("NoneChoice_text"));
			ivjNoneChoice.setEnabled(true);
			// user code begin {1}
			ivjNoneChoice.addItemListener(getChoiceListener());
			getChoiceGroup().add(ivjNoneChoice);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjNoneChoice;
}
/**
 * Return the PreviewLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JLabel getPreviewLabel() {
	if (ivjPreviewLabel == null) {
		try {
			ivjPreviewLabel = new javax.swing.JLabel();
			ivjPreviewLabel.setName("PreviewLabel");
			ivjPreviewLabel.setText("");
			ivjPreviewLabel.setHorizontalTextPosition(0);
			ivjPreviewLabel.setHorizontalAlignment(0);
			ivjPreviewLabel.setVerticalTextPosition(0);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPreviewLabel;
}
/**
 * Return the PreviewPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JPanel getPreviewPanel() {
	java.awt.GridBagConstraints constraintsPreviewLabel = new java.awt.GridBagConstraints();
	if (ivjPreviewPanel == null) {
		try {
			ivjPreviewPanel = new javax.swing.JPanel();
			ivjPreviewPanel.setName("PreviewPanel");
			ivjPreviewPanel.setLayout(new java.awt.CardLayout());
			ivjPreviewPanel.setBackground(java.awt.SystemColor.control);
			ivjPreviewPanel.add(getPreviewLabel(), getPreviewLabel().getName());
			ivjPreviewPanel.add(getWarningMessageArea(), getWarningMessageArea().getName());
			ivjPreviewPanel.setBorder(new javax.swing.border.EtchedBorder(javax.swing.border.EtchedBorder.RAISED, SystemColor.controlShadow, SystemColor.controlLtHighlight));
			showPreviewPanel();
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPreviewPanel;
}
private ULCIconEditor getPropertyEditor() {
	return propertyEditor;
}
/**
 * Return the SourceNameField property value.
 * @return javax.swing.JTextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JTextField getSourceNameField() {
	if (ivjSourceNameField == null) {
		try {
			ivjSourceNameField = new javax.swing.JTextField();
			ivjSourceNameField.setName("SourceNameField");
			ivjSourceNameField.setBackground(java.awt.SystemColor.textHighlightText);
			ivjSourceNameField.setEnabled(true);
			ivjSourceNameField.setColumns(30);
			// user code begin {1}
			ivjSourceNameField.addActionListener(getGenericActionListener());
			ivjSourceNameField.getDocument().addDocumentListener(getDocumentListener());
			ivjSourceNameField.addFocusListener(getFocusListener());
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjSourceNameField;
}
/**
 * Return the URLChoice property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JRadioButton getURLChoice() {
	if (ivjURLChoice == null) {
		try {
			ivjURLChoice = new javax.swing.JRadioButton();
			ivjURLChoice.setName("URLChoice");
			ivjURLChoice.setText(resabtedit.getString("URLChoice_text"));
			ivjURLChoice.setEnabled(true);
			// user code begin {1}
			ivjURLChoice.addItemListener(getChoiceListener());
			getChoiceGroup().add(ivjURLChoice);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjURLChoice;
}
/**
 * This method was created in VisualAge.
 * @return boolean
 */
public boolean getURLChoiceEnabled() {
	return URLChoiceEnabled;
}
private Object getValue() {
	Object result = null;
	if (propertyEditor != null) {
		result = propertyEditor.getValue();
	}
	return result;
}
private PropertyChangeListener getValueListener() {
	if (valueListener == null) {
		valueListener = new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				if (e.getSource() == UlcIconCustomEditor.this.getPropertyEditor() && e.getPropertyName() == "value") {//$NON-NLS-1$
					Icon icon = (Icon)(UlcIconCustomEditor.this.getPropertyEditor().getValue());
					UlcIconCustomEditor.this.getCacheOnUI().setSelected(UlcIconCustomEditor.this.propertyEditor.isCachedOnUI());
					UlcIconCustomEditor.this.getPreviewLabel().setIcon(icon);
					UlcIconCustomEditor.this.showPreviewPanel();
					UlcIconCustomEditor.this.invalidate();
					UlcIconCustomEditor.this.validate();
				}
			}
		};
	}
	return valueListener;
}
private JComponent getWarningMessageArea() {
	if (ivjWarningMessageArea == null) {
		try {
			try {
				// VaJava Version 2.0 doesn't have this string, so we'll try and if we fail,
				// we'll put an alert icon in its place.
				String iconMessage = resabtedit.getString("IconEditorWarningMessage"); //$NON-NLS-1$
				JTextArea warningArea = new JTextArea();
				ivjWarningMessageArea = warningArea;
				warningArea.setText(iconMessage);
				warningArea.setBackground(java.awt.SystemColor.info);
				warningArea.setFont(new java.awt.Font("dialog", 1, 12)); //$NON-NLS-1$
				warningArea.setMargin(new java.awt.Insets(10, 10, 10, 10));
				warningArea.setEditable(false);
			} catch (java.util.MissingResourceException exp) {
				// Couldn't find the string (i.e. in VaJava 2.0, so create a label instead
				// with the alert icon.
				JLabel warningArea = new JLabel();
				ivjWarningMessageArea = warningArea;
				warningArea.setText("");
				warningArea.setIcon(new ImageIcon(getClass().getResource("/com/ibm/ulc/application/alert.gif")));
				warningArea.setHorizontalTextPosition(0);
				warningArea.setHorizontalAlignment(0);
				warningArea.setVerticalTextPosition(0);
			}
			ivjWarningMessageArea.setName("WarningMessageArea"); //$NON-NLS-1$

		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	};
	return ivjWarningMessageArea;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	 System.out.println(resabtedit.getString("UNCAUGHTEXC")); //$NON-NLS-1$
	 exception.printStackTrace(System.out);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	// user code begin {1}
	// user code end
	java.awt.GridBagConstraints constraintsJPanel1 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsSourceNameField = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsFileBrowseButton = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsPreviewPanel = new java.awt.GridBagConstraints();
	setName("IconCustomEditor");
	setLayout(new java.awt.GridBagLayout());
	setBackground(java.awt.SystemColor.control);

	constraintsJPanel1.gridx = 0; constraintsJPanel1.gridy = 0;
	constraintsJPanel1.gridwidth = 2; constraintsJPanel1.gridheight = 1;
	constraintsJPanel1.fill = java.awt.GridBagConstraints.HORIZONTAL;
	constraintsJPanel1.anchor = java.awt.GridBagConstraints.WEST;
	constraintsJPanel1.weightx = 0.0;
	constraintsJPanel1.weighty = 0.0;
	constraintsJPanel1.insets = new java.awt.Insets(10, 0, 0, 10);
	add(getJPanel1(), constraintsJPanel1);

	constraintsSourceNameField.gridx = 0; constraintsSourceNameField.gridy = 1;
	constraintsSourceNameField.gridwidth = 1; constraintsSourceNameField.gridheight = 1;
	constraintsSourceNameField.fill = java.awt.GridBagConstraints.BOTH;
	constraintsSourceNameField.anchor = java.awt.GridBagConstraints.CENTER;
	constraintsSourceNameField.weightx = 1.0;
	constraintsSourceNameField.weighty = 0.0;
	constraintsSourceNameField.insets = new java.awt.Insets(0, 10, 0, 0);
	add(getSourceNameField(), constraintsSourceNameField);

	constraintsFileBrowseButton.gridx = 1; constraintsFileBrowseButton.gridy = 1;
	constraintsFileBrowseButton.gridwidth = 1; constraintsFileBrowseButton.gridheight = 1;
	constraintsFileBrowseButton.anchor = java.awt.GridBagConstraints.WEST;
	constraintsFileBrowseButton.weightx = 0.0;
	constraintsFileBrowseButton.weighty = 0.0;
	constraintsFileBrowseButton.insets = new java.awt.Insets(0, 10, 0, 10);
	add(getFileBrowseButton(), constraintsFileBrowseButton);

	constraintsPreviewPanel.gridx = 0; constraintsPreviewPanel.gridy = 2;
	constraintsPreviewPanel.gridwidth = 2; constraintsPreviewPanel.gridheight = 1;
	constraintsPreviewPanel.fill = java.awt.GridBagConstraints.BOTH;
	constraintsPreviewPanel.anchor = java.awt.GridBagConstraints.CENTER;
	constraintsPreviewPanel.weightx = 1.0;
	constraintsPreviewPanel.weighty = 1.0;
	constraintsPreviewPanel.insets = new java.awt.Insets(10, 10, 10, 10);
	add(getPreviewPanel(), constraintsPreviewPanel);
	setSize(getPreferredSize());
	// user code begin {2}
	// user code end
}
private boolean isCachedOnUI() {
	return getCacheOnUI().isSelected();
}
private boolean isIconInvalid() {
	boolean result = false;
	Object iconValue = getValue();
	if (iconValue instanceof NamedImageIcon) {
		NamedImageIcon namedIcon = (NamedImageIcon)iconValue;
		if (namedIcon.getSource() == NamedImageIcon.FILE && 
				getClass().getResource(namedIcon.getResourceName()) == null)
			result = true;
		else if (namedIcon.getIconWidth() < 0 || namedIcon.getIconHeight() < 0)
			result = true;
	}
	return result;
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		JFrame f = new JFrame("UlcIconEditor");
		UlcIconCustomEditor edit= new UlcIconCustomEditor(null);
		f.setSize(400, 300);
		f.getContentPane().add(edit);
		f.setVisible(true);
	} catch (Throwable e) {
		e.printStackTrace();
	}
}
/**
 * This method was created in VisualAge.
 * @param newValue boolean
 */
public void setURLChoiceEnabled(boolean newValue) {
	URLChoiceEnabled = newValue;
	getURLChoice().setVisible(URLChoiceEnabled);
}
/**
 * This method will set the savedURL to this value.
 * It will also see if this is a file format name (i.e. file:// ... )
 * If it is, then save the name in the savedFilename so that the file
 * selector will use it as the name to put in the file selector.
 * Creation date: (09-17-99 3:25:52 PM)
 * @param aURLString java.lang.String
 */
private void setURLSave(String aURLString) {
	savedURL = aURLString;
	if (savedURL.startsWith("file:/")) {
		savedFilename = savedURL.substring(6).replace('/', java.io.File.separatorChar);
	} else {
		savedFilename = "";
	}
		
}
private void setUserState() {
	boolean isFileState = getFileChoice().isSelected();
	boolean isURLState = getURLChoice().isSelected();
	JButton fileBrowse = getFileBrowseButton();
	JTextField sourceName = getSourceNameField();

	if (isFileState) {
		fileBrowse.setEnabled(true);
		sourceName.setEnabled(true);
		sourceName.setText(savedFilename);
		if (sourceName.getText() == null || sourceName.getText().equals("")) {//$NON-NLS-1$
			setValue(null);
		} else {
			sourceName.postActionEvent();
		}
	} else if (isURLState) {
		fileBrowse.setEnabled(true);
		sourceName.setEnabled(true);
		sourceName.setText(savedURL);
		if (sourceName.getText() == null || sourceName.getText().equals("")) {//$NON-NLS-1$
			setValue(null);
		} else {
			sourceName.postActionEvent();
		}
	} else {
		fileBrowse.setEnabled(false);
		sourceName.setEnabled(false);
	}	
		

	return;
}
private void setValue(Object value) {
	if (propertyEditor != null) {
		propertyEditor.setValue(value);
	}
	return;
}
private void showPreviewPanel() {
	if (isIconInvalid())
		((CardLayout)getPreviewPanel().getLayout()).show(getPreviewPanel(), getWarningMessageArea().getName());
	else
		((CardLayout)getPreviewPanel().getLayout()).show(getPreviewPanel(), getPreviewLabel().getName());
	getPreviewPanel().invalidate();
	getPreviewPanel().validate();
	return;
}
public String validateFilename(String inFileName) {
	String filename = inFileName;
	String sep = java.io.File.separator;
	String prDir = sep+"project_resources"+sep;//$NON-NLS-1$
	if (filename != null && !filename.equals("")) {//$NON-NLS-1$
		int prLoc = filename.indexOf(prDir);
		if (prLoc >= 0) {
			filename = ".."+filename.substring(prLoc+prDir.length()-1);//$NON-NLS-1$
		}
	}
	
	return filename;
}
}
