package com.ibm.ulc.vaedit;

/**
 * This type was created in VisualAge.
 */
import com.ibm.uvm.abt.edit.NamedImageIcon;
public class UlcNamedImageIcon extends NamedImageIcon {
	private boolean fCachedOnUI = false;
	static final long serialVersionUID = -6889177446852219674L;

/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(String filename) {
	super(filename);
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(String filename, String description) {
	super(filename, description);
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(String filename, String description, boolean cacheIt) {
	this(filename, description);
	fCachedOnUI = cacheIt;
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(String fileName, boolean cacheIt) {
	this(fileName);
	fCachedOnUI = cacheIt;
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(java.net.URL location) {
	super(location);
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(java.net.URL location, String description) {
	super(location, description);
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(java.net.URL location, String description, boolean cacheIt) {
	this(location, description);
	fCachedOnUI = cacheIt;
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public UlcNamedImageIcon(java.net.URL location, boolean cacheIt) {
	this(location);
	fCachedOnUI = cacheIt;
}
/**
 * This method was created in VisualAge.
 * @param fileName java.lang.String
 */
public static UlcNamedImageIcon create(NamedImageIcon icon, boolean cacheIt) {
	if (icon.getSource() == NamedImageIcon.FILE)
		return new UlcNamedImageIcon(icon.getSourceName(), cacheIt);
	else {
		try {
			return new UlcNamedImageIcon(new java.net.URL(icon.getSourceName()), cacheIt);
		} catch (java.net.MalformedURLException exception) {
			return null;
		}
	}
}
/**
 * This method was created in VisualAge.
 * @return boolean
 */
public boolean getCachedOnUI() {
	return fCachedOnUI;
}
/**
 * This method was created in VisualAge.
 * @return boolean
 */
public void setCachedOnUI(boolean cacheIt) {
	fCachedOnUI = cacheIt;
}
}
