@echo off
cls
set allOk=yes
echo.
echo ***** Testing ULC Environment Variables **********
echo ULCJREROOT=[%ULCJREROOT%]
echo ULCUIHOME=[%ULCUIHOME%]
echo.
rem echo CLASSPATH=[%CLASSPATH%]
echo **************************************************
echo.

rem JRE Check
IF %ULCJREROOT%x==x  goto ulcjrenotset

:checkjreroot
if exist "%ULCJREROOT%"\BIN\java.exe goto jreok
ECHO WARNING: The ULCJREROOT variable does not point to a valid JRE directory.
ECHO          (eg: C:\jre1.2.2 or C:\jdk1.2.2\jre)
echo.
set allOk=W
goto uihomecheck

:ulcjrenotset
echo WARNING:
echo The ULCJREROOT variable has not been set.
echo Either set this variable (eg: C:\jre1.2.2 or C:\jdk1.2.2\jre) or install
echo the Java Runtime environment on your machine and ensure that
echo the java.exe is found on your system PATH.
echo The CLASSPATH variable must also be set.
echo.
set allOk=W
goto uihomecheck

:jreok
echo ULCJREROOT is ok.
echo.

REM Check ULCUIHOME
:uihomecheck
IF "%ULCUIHOME%"x==x goto uinotset
if exist "%ULCUIHOME%"\lib\uiengine.jar goto uiok
ECHO ERROR: The ULCUIHOME variable does not point to a valid UIEngine directory.
echo      : Please set it to the location of the UIEngine (eg: c:\ULC\UIEngine)
echo.
set allOk=N
goto end

:uinotset
echo Warning: The ULCUIHOME environment variable has not been set.
echo    Note: The ULC HttpServer sample cannot run without this variable.
echo        : Please set it to the location of the UIEngine (eg: c:\ULC\UIEngine)
echo.
set allOk=N
goto end

:uiok
echo ULCUIHOME is ok.
echo.

:end
if %allOk%==W goto Warning
if %allOk%==N goto error
echo Success: All ULC Environment variables are correctly initialized.
echo.
goto exit
:Warning
echo Warning: Not all the environment variables have been correctly initialized.
echo        : Some features of ULC may not function correctly.
echo.
goto exit
:error
echo Error: Some ULC features will not run if the errors listed above are not fixed.
echo.
:exit
pause
