package com.ibm.vap.Transactions;


/**
 * This class was created by a JavaGen (tm).
 */

import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import com.ibm.vap.common.VapAccessException;

abstract public class AbstractLink
{
	protected Relationship relationship;
/**
 * AbstractLink constructor
 */
public AbstractLink()
{
	super();
}
/**
 * Do nothing.
 * Specialize in links where if the target object anObject
 * signals that it changed this might affect us
 */
public void changeSignalledForTarget(VapEJBObject anEJBObject) throws RemoteException {

}
/**
 * Clean up my exsiting relationship and direct my current counterLink
	to do likewise.  Set my new target and direct my new counterLink to 
	connect to my source
 */
public abstract void  connectTo(VapEJBObject aBO) throws RemoteException;
/**
 * Clear my target and direct my counterlink to do likewise
 */
public abstract void disconnectFrom(VapEJBObject aBo ) throws RemoteException;
/**
 * Clear my target and direct my counterlink to do likewise
 */
public abstract void disconnectFromRetrieved(VapEJBObject aBo ) throws RemoteException;
/**
 * Answer my key.  To be used by insert and update services
 */
public Key getKey()
{
	return relationship.getKeyForLink(this); 
}
/**
 * Used in place of nil.
 */
protected NullTarget getNullTarget()
{
	return NullTarget.singleton(); 
}
/**
 * Currently this is only a kludge to allow accessAgent to get name
	to fake getting the foreign key
 */
public Relationship getRelationship()
{
	return relationship; 
}
/**
 * Answer my source BO
 */
public abstract VapEJBObject getSource();
/**
 * Aswer true if target has delete presedence
 */
protected boolean hasDeletePrecedence()
{
	return this.getRelationship().hasDeletePrecedence();
}
/**
 * Aswer true if target has insert presedence
 */
protected boolean hasInsertPrecedence()
{
	return this.getRelationship().hasInsertPrecedence();
}
/**
 * Initialize target if needed
 */
public void initializeTarget() {}
/**
 * Answer true if I am cnnected to my target
 */
public abstract boolean isConnected();
/**
 * Aswer true if the relationship has a constraint defined
 */
protected boolean isConstrained()
{
	return this.getRelationship().isConstrained();
}
/**
 * Answer true if I am a single link
 */
public abstract boolean isSingleLink();
/**
 * Mark the link to be removed: disconnct from the target
 */
public abstract void markRemoved() throws RemoteException, RemoveException;
/**
 * Do nothing.
 * Specialize in links where if the target object anObject
 * signals that it changed this might affect us
 */
public void primChangeSignalledForTarget(VapEJBObject anEJBObject) throws RemoteException {

}
/**
 * Reconcile links between old version and new version after
 * refreshing from the database
 */
public void reconcileFromRetrievedWith(AbstractLink anOldLink)
{
}
/**
 * Reconcile links between old version and new version after
 * refreshing from the database
 */
public void reconcileWith(AbstractLink anOldLink)
{
}
/**
 * Establish aBO as my target object
 */
public abstract void secondaryConnectTo(VapEJBObject aBo ) throws RemoteException;
/**
 *	Establish aBO as my target object
 */
public void secondaryConnectToRetrieved(VapEJBObject aBO) throws RemoteException
{
	this.secondaryConnectTo (aBO);
}
/**
 * disconnect from aBo
 */
public abstract void secondaryDisconnectFrom(VapEJBObject aBo) throws RemoteException;
/**
 * Clear my target
 */
public abstract void secondaryDisconnectFromRetrieved(VapEJBObject aBo) throws RemoteException;
/**
 * Currently this is only a kludge to allow accessAgent to get name
	to fake getting the foreign key
 */
public void setRelationship(Relationship aRelationship)
{
	relationship = aRelationship; 
}
}