package com.ibm.vap.Transactions;

/**
 * State of an active transaction.
 * 
 */

import java.rmi.RemoteException;
import com.ibm.vap.common.VapTransactionRequiredException;
import com.ibm.vap.common.VapTransactionFailureException;

public class ActiveTransactionState extends TransactionState
{
/**
 * Commit a transaction
 */
protected void commit(Transaction aTransaction) throws RemoteException, VapTransactionFailureException, VapTransactionRequiredException
{
	Transaction parent = aTransaction.getParent();
	primCommit(aTransaction);
	aTransaction.signalRootHasBeenCommitted();
	parent.callDeferredSignallers();
	parent.callDeferredMessages();
}
/**
 * Test if the transaction is active
 */
protected boolean isActive( )
{
	return true;
}
/**
 * Mark the transaction for rollback
 */
protected void markForRollback(Transaction aTransaction)
{
	aTransaction.primMarkForRollback();
	aTransaction.setState(aTransaction.createMarkedRollbackState());
}
/**
 * Commit a transaction
 */
protected void primCommit(Transaction aTransaction) throws RemoteException, VapTransactionFailureException, VapTransactionRequiredException
{
	aTransaction.primCommit();
	aTransaction.setState(aTransaction.createCommittedState());
}
/**
 * Rollback a transaction
 */
protected void primRollback(Transaction aTransaction) throws RemoteException, VapTransactionRequiredException
{
	aTransaction.primRollback();
	aTransaction.setState(aTransaction.createRolledBackState());
}
/**
 * Resume a transaction
 */
public void resume(Transaction aTransaction) throws VapTransactionRequiredException
{
	aTransaction.primResume();
}
/**
 * Rollback a transaction
 */
protected void rollback(Transaction aTransaction) throws RemoteException, VapTransactionRequiredException
{
	primRollback(aTransaction);
	aTransaction.signalRootHasBeenRolledback();
}
/**
 * Commit a transaction that is being committed as part of a cascade
 */
protected void secondaryCommit(Transaction aTransaction) throws RemoteException, VapTransactionFailureException, VapTransactionRequiredException
{
	Transaction parent = aTransaction.getParent();
	primCommit(aTransaction);
	aTransaction.signalHasBeenCommitted();
	parent.callDeferredSignallers();
	parent.callDeferredMessages();
}
/**
 * Rollback a transaction
 */
protected void secondaryRollback(Transaction aTransaction) throws RemoteException, VapTransactionRequiredException
{
	primRollback(aTransaction);
	aTransaction.signalHasBeenRolledback();
}
/* Append the nesting level depth of the transaction to the string */
public String toString(Transaction aTransaction) {
	return "(" + aTransaction.depth() + ")" + super.toString(aTransaction) ;
}
}