package com.ibm.vap.Transactions;


/**
 * Abstract transaction state
 */

import java.rmi.RemoteException;
import com.ibm.vap.common.VapTransactionRequiredException;
import com.ibm.vap.common.VapTransactionFailureException;

public abstract class TransactionState extends java.lang.Object
{
/**
 * Answer a string that represents the transaction state ( us ) as well as the Transaction
 * Specialize in subclasses
 */
public String appendTransactionString(String aString)
{
	return aString;
}
/**
 * Commit a transaction
 */
protected void commit(Transaction aTransaction) throws RemoteException, VapTransactionFailureException, VapTransactionRequiredException
{
}
/**
 * Test if the transaction is active
 */
protected boolean isActive( )
{
	return false;
}
/**
 * Test if the transaction is committed
 */
protected boolean isCommitted( )
{
	return false;
}
/**
 * Test if the transaction is marked to be rolled back
 */
protected boolean isMarkedRollback( )
{
	return false;
}
/**
 * Test if the transaction is rolled back
 */
protected boolean isRolledBack( )
{
	return false;
}
/**
 * Mark the transaction for rollback
 */
protected void markForRollback(Transaction aTransaction)
{
}
/**
 * Resume a transaction
 */
public void resume(Transaction aTransaction) throws VapTransactionRequiredException
{
	throw new VapTransactionRequiredException();
}
/**
 * Rollback a transaction
 */
protected void rollback(Transaction aTransaction) throws RemoteException, VapTransactionFailureException, VapTransactionRequiredException
{
}
/**
 * Commit a transaction as part of a secondary commit, i.e. it is being
 * commit by its parent transaction being committed
 */
protected void secondaryCommit(Transaction aTransaction) throws RemoteException, VapTransactionFailureException, VapTransactionRequiredException
{
}
/**
 * Rollback a transaction as part of a cascade, i.e.
 * it is being rolledback because its parent is being rolledback
 */
protected void secondaryRollback(Transaction aTransaction) throws RemoteException, VapTransactionFailureException, VapTransactionRequiredException
{
}
/**
 * Return string representation of the object
 */
public String toString()
{
	return this.getClass().getName();
}
/**
 * Answer a string that represents the transaction state ( us ) as well as the Transaction
 * Specialize in subclasses
 */
public String toString(Transaction aTransaction)
{
	return aTransaction.primToString();
}
}