package com.ibm.vap.swing.list;

import java.util.Enumeration;
import java.util.Vector;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import com.sun.java.swing.JList;
import com.ibm.vap.RuntimeTools.Trace;
import com.ibm.vap.common.ArrayVectorTransform;
import com.ibm.vap.Transactions.VapActionListener;
import com.ibm.vap.Transactions.VapEvent;
import com.ibm.vap.Transactions.Transaction;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.common.VapTransactionRequiredException;


/**
 * This type was created in VisualAge.
 */

public abstract class VapAbstractListModel extends com.sun.java.swing.AbstractListModel implements VapActionListener{

	public Transaction transaction;
	protected JList list;
	protected boolean useDisplayString = false;
	private boolean fieldUseDisplayString = false;
/**
 * This is the callback that one of our dependents has signalled an event
 * If it is our transaction and it is the rootCommittedOrRolledback event
 * then we should regenerate our transaction, attach ourself as a dependent of the new one
 * and also fire the change event.  For the old value we can use the one in the event source
 */
public void actionPerformed(VapEvent event) {

	return ;
}
public abstract void addElement(Object obj) ;
public void addElements(Object[] objectArray) {
	this.addElements(ArrayVectorTransform.toVector(objectArray));
}
public abstract void addElements(Vector aVector) ;
/*
 * resume trans.
 */

protected Transaction cacheCurrentAndResumeTransaction() {

	Transaction current = Transaction.getCurrent();
	if (transaction != null)
		resumeTransaction(transaction);
	return current;

}
/**
 * 
 */
public void clearSelection() {

	if (list != null)
		list.clearSelection();
}
/**
 * Inform the list of the changed element from a VapEvent.
 */
protected void fireContentAtIndexChanged(VapEvent event) {

	Integer data = (Integer)event.getEventData();
	int index = data.intValue();
	fireContentsChanged(this, index, index);

}
/**
 * Return an Enumeration of the delegate's elements.
 */

public abstract Enumeration getElements() ;
/*
 * Return a VapBasicListCellRenderer
 */

private VapBasicListCellRenderer getListCellRenderer() {

	return new VapBasicListCellRenderer(transaction, useDisplayString);
}
/*
 * An exception occurred so handle it.
 */

protected void handleException(Exception ex) {
	Trace.show(ex);
	return ;
}
public abstract int indexOf(Object elem) ;
/**
 * Default is to do nothing.
 */
protected void newTransactionObtained() {
	return ;
}
/**
 * Remove the object at index from the relationship.
 * Return the object at index.
 * The object is not markedRemoved().
 */

protected abstract Object primRemove(int index) ;
/**
 * Remove the object at index from the relationship.
 * Return the object at index.
 * The object is not markedRemoved().
 */

public Object remove(int index) {

	Object rv = this.primRemove(index);
	fireIntervalRemoved(this, index, index);
	return rv;
}
public Object remove(Object obj) {
	this.removeElement(obj);
	return obj;
}
public abstract void removeAllElements() ;
/**
 * Remove all elements from the list and mark them for deletion.
 * Upon commit of the transaction, all elements will be deleted
 * from the database.
 */
 
public void removeAndDeleteAllElements() {
	
	Enumeration enum = getElements();
	while (enum.hasMoreElements()) {
		try {
			((VapEJBObject) enum.nextElement()).remove();
		} 
		catch (RemoteException e) {}
		catch (RemoveException e) {}
	}
	this.removeAllElements();
}
/**
 * Remove obj from the list and mark it for deletion.
 * Upon commit of the transaction, obj will be deleted
 * from the database.
 */

public boolean removeAndDeleteElement(Object obj) {
	try {
		((VapEJBObject) obj).remove();
	} 
	catch (RemoteException e) {}
	catch (RemoveException e) {}
	boolean rv = this.removeElement(obj);
	return rv;
}
/**
 * Remove elements at the indices within the intArray from the list and mark them for deletion.
 * Upon commit of the transaction, these elements will be deleted
 * from the database.
 */

public void removeAndDeleteElements(int[] intArray) {

	int index;
	
	for (int i = intArray.length - 1; i >= 0; i--) {
		index = intArray[i];
		try {
			((VapEJBObject) getElementAt(index)).remove();
		}
		catch (RemoteException e) {handleException(e);}
		catch (RemoveException e) {handleException(e);}
	    this.removeElementAt(index);
	}
}
/**
 * Remove elements within the objectArray from the list and mark them for deletion.
 * Upon commit of the transaction, these elements will be deleted
 * from the database.
 */

public void removeAndDeleteElements(Object[] objectArray) {

	Object object;
	
	for (int i = objectArray.length - 1; i >= 0; i--) {
		object = objectArray[i];
		try {
			((VapEJBObject) object).remove();
		}
		catch (RemoteException e) {handleException(e);}
		catch (RemoveException e) {handleException(e);}
	    this.removeElement(object);
	}
}
/**
 * Remove elements within the index range from the list and mark them for deletion.
 * Upon commit of the transaction, these elements will be deleted
 * from the database.
 */

public void removeAndDeleteRange(int fromIndex, int toIndex) {
	for(int i = toIndex; i >= fromIndex; i--) {
		try {
			((VapEJBObject) primRemove(i)).remove();
		}
		catch (RemoteException e) {handleException(e);}
		catch (RemoveException e) {handleException(e);}
	}
	fireIntervalRemoved(this, fromIndex, toIndex);
}
public abstract boolean removeElement(Object obj) ;
public abstract void removeElementAt(int index) ;
public void removeElements(int[] intArray) {
	for (int i = intArray.length - 1; i >= 0; i--) {
	    this.removeElementAt(intArray[i]);
	}
}
public void removeElements(Object[] objectArray) {
	for (int i = objectArray.length - 1; i >= 0; i--) {
	    this.removeElement(objectArray[i]);
	}
}
/*
 * resume trans.
 */

protected void resumeTransaction(Transaction trans) {

	try {
		trans.resume();
	} catch (VapTransactionRequiredException e) { }

}
/**
 * Set the list.
 */
public void setList(JList aList) {
	JList oldList = list;
	if (oldList == aList) return;
	list = aList;
	if (aList != null) {
		aList.setCellRenderer(getListCellRenderer());
		aList.setModel(this);
		
	}
}
/**
 * set the transaction
 */
public void setTransaction(Transaction aTransaction) {
	Transaction oldValue = transaction;
	transaction = aTransaction;
	if (oldValue != transaction)
		newTransactionObtained();
	if (list != null)
		((VapBasicListCellRenderer) list.getCellRenderer()).setTransaction(aTransaction);
}
/**
 * 
 */
public boolean shouldUseDisplayString() {
	return useDisplayString;
}
/**
 * 
 */
public void shouldUseDisplayString(boolean aBool) {
	useDisplayString = aBool;
}
public abstract String toString() ;
}