package com.ibm.vap.swing.list;


import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;
import com.ibm.vap.Transactions.Transaction;
import com.ibm.vap.common.VapTransactionRequiredException;

import java.awt.Component;
import java.awt.Color;

import java.io.Serializable;


/**
 * Renders an item in a list.
 */
public class VapBasicListCellRenderer extends BasicListCellRenderer 
	implements ListCellRenderer, Serializable
{

	protected static Border noFocusBorder;
	private Transaction transaction;
	private boolean useDisplayString = false;

	/**
	 * A subclass of BasicListCellRenderer that implements UIResource.
	 * BasicListCellRenderer doesn't implement UIResource
	 * directly so that applications can safely override the
	 * cellRenderer property with BasicListCellRenderer subclasses.
	 * <p>
	 * Warning: serialized objects of this class will not be compatible with
	 * future swing releases.  The current serialization support is appropriate
	 * for short term storage or RMI between Swing1.0 applications.  It will
	 * not be possible to load serialized Swing1.0 objects with future releases
	 * of Swing.  The JDK1.2 release of Swing will be the compatibility
	 * baseline for the serialized form of Swing objects.
	 */
	public static class UIResource extends BasicListCellRenderer 
		implements com.sun.java.swing.plaf.UIResource
	{
	}

public VapBasicListCellRenderer() {
	super();
   	noFocusBorder = new EmptyBorder(1, 1, 1, 1);
	setOpaque(true);
	setBorder(noFocusBorder);
}
public VapBasicListCellRenderer(Transaction aTransaction) {
	super();
	transaction = aTransaction;
   	noFocusBorder = new EmptyBorder(1, 1, 1, 1);
	setOpaque(true);
	setBorder(noFocusBorder);
}
public VapBasicListCellRenderer(Transaction aTransaction, boolean displayString) {
	super();
	transaction = aTransaction;
	useDisplayString(displayString);
   	noFocusBorder = new EmptyBorder(1, 1, 1, 1);
	setOpaque(true);
	setBorder(noFocusBorder);
}
public VapBasicListCellRenderer(boolean displayString) {
	super();
	useDisplayString(displayString);
   	noFocusBorder = new EmptyBorder(1, 1, 1, 1);
	setOpaque(true);
	setBorder(noFocusBorder);
}
/*
 * resume trans.
 */

protected Transaction cacheCurrentAndResumeTransaction() {

	Transaction current = Transaction.getCurrent();
	if (transaction != null)
		resumeTransaction(transaction);
	return current;

}
	public Component getListCellRendererComponent(
		JList list, 
	Object value,
		int index, 
		boolean isSelected, 
		boolean cellHasFocus)
	{
	
	if (isSelected) {
	    setBackground(list.getSelectionBackground());
	    setForeground(list.getSelectionForeground());
	}
	else {
	    setBackground(list.getBackground());
	    setForeground(list.getForeground());
	}
	
	if (value instanceof Icon) {
	    setIcon((Icon)value);
	}
	else {
	    this.setTextValue(value);
	}

	setFont(list.getFont());
	setBorder((cellHasFocus) ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);

	return this;
	}
/*
 * resume trans.
 */

protected void resumeTransaction(Transaction trans) {

	try {
		trans.resume();
	} catch (VapTransactionRequiredException e) { }

}
/*
 * Set the value of the text displayed in the list.
 * If a transaction is specified, then it is necessary to set the text based on the
 * correct transaction.
 * If useDisplayString is set to true, use that method instead of toString() to
 * display the value's text.
 */

private void setTextValue(Object value) {

	String newText = " ";
	if (value != null) {
		Transaction current = cacheCurrentAndResumeTransaction();
		try {
			newText = (useDisplayString == true) ? ((VapJListElement)value).displayString() : value.toString();
		} catch (ClassCastException e) {
			newText = value.toString();
		}
		resumeTransaction(current);
	}
	setText(newText);

}
/*
 * Set the transaction
 */

protected void setTransaction(Transaction aTransaction) {

	transaction = aTransaction;

}
/*
 * Set useDisplayString
 */

protected void useDisplayString(boolean aBool) {

	useDisplayString = aBool;

}
}