package com.ibm.vap.swing.table;

import com.sun.java.swing.event.TableModelEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import java.util.StringTokenizer;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapTransactionRequiredException;
import com.ibm.vap.common.ArrayVectorTransform;
import com.ibm.vap.common.VapMethodInvocation;
import com.ibm.vap.RuntimeTools.Trace;
import com.ibm.vap.RelationalPersistence.VapAbstractConverter;
import com.ibm.vap.Persistence.PersistentHomeCollection;
import com.ibm.vap.Transactions.Transaction;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapActionListener;
import com.ibm.vap.Transactions.VapEvent;
import com.sun.java.swing.JTable;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableColumnModel;

/**
 * This type was created in VisualAge.
 */
public abstract class VapAbstractTableModel extends com.sun.java.swing.table.AbstractTableModel implements ListSelectionListener, VapActionListener
{


	/** The Vector of column identifiers */	
	protected Vector columnIdentifiers;
	protected String columnIDString;

	protected String elementClassName;

	public Transaction transaction;
	public JTable table;
	public Vector selectedRowObjects = new Vector();
	private static java.util.ResourceBundle resobjectExtender = java.util.ResourceBundle.getBundle("objectExtender");  //$NON-NLS-1$
	protected transient java.beans.PropertyChangeSupport propertyChange;

/**
 * This is the callback that one of our dependents has signalled an event
 * If it is our transaction and it is the rootCommittedOrRolledback event
 * then we should regenerate our transaction, attach ourself as a dependent of the new one
 * and also fire the change event.  For the old value we can use the one in the event source
 */
public void actionPerformed(VapEvent event) {

	return ;
}
/**
 *  Add a column to the model. If aColumn has a modelIndex that is
 *  already in use, reset its modelIndex to an available index and
 *  add its columnIdentifier in the appropriate order.
 */
public void addColumn(TableColumn aColumn) {
	int index = aColumn.getModelIndex();
	//update the columnIdentifiers
	if ((columnIdentifiers.size() - 1) >= index) {
		String existing = (String) columnIdentifiers.elementAt(index);
		if (existing != null) {
			Enumeration enum = getTableColumnModel().getColumns();
			boolean indexAlreadyUsed = false;
			while (enum.hasMoreElements()) {
				TableColumn c = (TableColumn) enum.nextElement();
				if (c.getModelIndex() == index) {
					aColumn.setModelIndex(columnIdentifiers.size());
					columnIdentifiers.addElement(aColumn.getIdentifier());
					indexAlreadyUsed = true;
				}
			if (indexAlreadyUsed) break;
			}
		} else {
			columnIdentifiers.setElementAt(aColumn.getIdentifier(), index);
		}
	} else {
		columnIdentifiers.addElement(aColumn.getIdentifier());
	}
				
	getTableColumnModel().addColumn(aColumn);
}

/**
 *  Add a column to the model.  The new column will have the
 *  idenitifier <i>columnIdentifier</i>.  This method will send a
 *  tableChanged() notification message to all the listeners.
 */
public void addColumn(String columnIdentifier) {
	if (columnIdentifier == null)
		throw new IllegalArgumentException("addColumn() - null parameter");
	columnIdentifiers.addElement(columnIdentifier);
	fireTableStructureChanged();
}
/**
 * Add anObject to the model's data collection.
 */
protected abstract void addElement(Object anObject) ;
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 *  Add a row to the end of the model. Notification
 *  of the row being added will be generated.
 */
public void addRow(Object anObject) {

	int before, after;
	
	if (anObject != null) {
		before = getRowCount();
		addElement(anObject);
		after = getRowCount();
		if (before != after)
			// Generate notification
			fireTableRowsInserted(after-1, after-1);
	}
}
/**
 *  Add a row to the end of the model. Notification
 *  of the row being added will be generated.
 */
public void addRows(Vector rows) {

	int before, after;
	
	if (rows != null) {
		before = getRowCount();
		Enumeration enum = rows.elements();
		while (enum.hasMoreElements()) 
			addElement(enum.nextElement());
		after = getRowCount();
		if (before != after)
			// Generate notification
			fireTableRowsInserted(before, after-1);
	}
}
/*
 * resume trans.
 */

protected Transaction cacheCurrentAndResumeTransaction() {

	Transaction current = Transaction.getCurrent();
	if (transaction != null)
		resumeTransaction(transaction);
	return current;

}
/**
 * Inform the table to clear its selection.
 */
protected void clearSelection() {

	if (table != null)
		table.clearSelection();
}
/**
 * This method was created in VisualAge.
 */
private Vector convertColumnIdStringToVector(String aString) {

	Vector result = new Vector();
	
	String nextToken = null;
	String[] tokenValues;
	StringTokenizer st1, st2;
	int i = 0;
	
	st1= new StringTokenizer(aString, "%%");
	int s = 0;
	while (st1.hasMoreElements()) {
		nextToken = (String) st1.nextElement();
		if (s == 0) {
			elementClassName = nextToken;
			s++;
		} else {
			st2 = new StringTokenizer(nextToken, " ");
			tokenValues = new String[st2.countTokens()];
			i = 0;
			while (st2.hasMoreElements()) {
				tokenValues[i] = (String) st2.nextElement();
				i++;
			}
			result.addElement(new VapColumnIdentifier(tokenValues));
		}
	}
	return result;

}
/**
 * Any type that is displayed in a JTable must be able to convert a String
 * to an instance of that type.  This is done using the static method
 * valueOf.
 */
private Object convertStringForPrimitiveWrappers(String aValue, Class type) {

	if (type == String.class)
		return aValue;  //no conversion necessary

	if (type == Character.class)
		return new Character(aValue.charAt(0));  //Characters are handled differntly

	Object[] args = new Object[1];
	args[0] = aValue;
	try {
		return VapMethodInvocation.performStaticMethod("valueOf", type, args);
	} catch (Exception e) {
		return null;
	}

	
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Return aString with the first character capitalized.
 */
private String firstAsUpperCase(String aString) {

	if (Character.isUpperCase(aString.charAt(0))) 
		return aString;
	char[] oldArray, newArray;
	oldArray = aString.toCharArray();
	int oldSize = oldArray.length;
	newArray = new char[oldSize];
	newArray[0] = Character.toUpperCase(oldArray[0]);
	for (int i=1; i < oldSize; i++) 
		newArray[i] = oldArray[i];
	return String.valueOf(newArray);
}
/**
 * @return the number of columns in the model.
 */
public int getColumnCount() {
	if (columnIdentifiers == null)
		return 0;
	else
		return columnIdentifiers.size();
}
/**
 *  Return the columnIdentifier at column.
 */
public String getColumnIdentifier(int column) {

	VapColumnIdentifier colIdentifier = getColumnIdentifierObject(column);
	if (colIdentifier == null)
		return " ";
	else
		return colIdentifier.getIdentifier();

}
/**
 *  Return the columnIdentifier at column.
 */
public VapColumnIdentifier getColumnIdentifierObject(int column) {

	return (VapColumnIdentifier)getColumnIdentifiers().elementAt(column);
	
}
/**
 * 
 */
public Vector getColumnIdentifiers() {
	if (columnIdentifiers == null)
		columnIdentifiers = new Vector();
	return columnIdentifiers;

}
/**
 *  Return the columnIdentifier at column.
 */
public String getColumnIdentifiersAsString() {

	if (getColumnIdentifiers().size() == 0)
		return " ";
	Enumeration enum = getColumnIdentifiers().elements();
	StringBuffer buffer = new StringBuffer();
	VapColumnIdentifier colIdentifier;

	buffer.append(elementClassName);
	buffer.append("%%");
	
	while (enum.hasMoreElements()) {
		colIdentifier = (VapColumnIdentifier) enum.nextElement();
		buffer.append(colIdentifier.toString());
		if (enum.hasMoreElements()) {
			buffer.append("%%");
		}
	}
	return buffer.toString();
}
/**
 *  Return the columnIdentifier at column.
 */
public String getColumnName(int column) {

	Vector columns = getColumnIdentifiers();
	
	if ((columns == null) || (columns.size() == 0))
		return super.getColumnName(column);
	else
		return getColumnIdentifier(column);
		
}
/**
 * Return the object within the dataVector at the index aRow.
 */
public abstract Object getElementAt(int aRow) ;
/**
 * Return an Enumeration of the model's data collection.
 */
protected abstract Enumeration getElements() ;
/**
 *
 */
private String getGetterMethodName(VapColumnIdentifier colIdentifier) {
	return "get" + colIdentifier.getIdentifier();	
}
/**
 * Return the index of anObject within the model.
 */
protected abstract int getIndexOf(Object anObject) ;
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}

public Object getSelectedRowObject() {

	int size = selectedRowObjects.size();
	
	return (size == 1) ? selectedRowObjects.firstElement() : null;
}

public Vector getSelectedRowObjects() {
	return selectedRowObjects;
}
/**
 *
 */
private String getSetterMethodName(VapColumnIdentifier colIdentifier) {
	return "set" + colIdentifier.getIdentifier();	
}
/**
 *  Remove the column at the integer column.
 */
public TableColumnModel getTableColumnModel() {

	return table.getColumnModel();
}
/**
 * Returns an attribute value for the cell at <I>row</I>
 * and <I>column</I>.
 *
 * @param   row             the row whose value is to be looked up
 * @param   column          the column whose value is to be looked up
 * @return                  the value Object at the specified cell
 * @exception  ArrayIndexOutOfBoundsException  if an invalid row or
 *               column was given.
 */
public Object getValueAt(int row, int column) {
	Object rowObject = getElementAt(row);
	VapColumnIdentifier colIdentifier = (VapColumnIdentifier) columnIdentifiers.elementAt(column);
	return performGetValue(colIdentifier, rowObject);
}
/**
 *	Return the Object wrapper class for the primitive type primType
 */
private Class getWrapperForPrimitive(Class primType) {

	if (primType == int.class)
		return Integer.class;
	if (primType == boolean.class)
		return Boolean.class;
	if (primType == byte.class)
		return Byte.class;
	if (primType == short.class)
		return Short.class;
	if (primType == long.class)
		return Long.class;
	if (primType == float.class)
		return Float.class;
	if (primType == double.class)
		return Double.class;

	return null;
		
}
/*
 * An exception occurred so handle it.
 */

protected void handleException(Exception ex) {
	Trace.show(ex);
	return ;
}
/**
 * Returns true if the cell at <I>row</I> and <I>column</I>
 * is editable.  Otherwise, the setValueAt() on the cell will not change
 * the value of that cell.
 *
 * @param   row             the row whose value is to be looked up
 * @param   column          the column whose value is to be looked up
 * @return                  true if the cell is editable.
 * @see #setValueAt()
 */
public boolean isCellEditable(int row, int column) {

	String columnIdString;
	
	VapColumnIdentifier columnId = getColumnIdentifierObject(column);
	if (columnId == null) {
		columnIdString = " ";
	} else {
		if (!columnId.isEditable().booleanValue()) {
			return false;
		} else {
			columnIdString = columnId.getIdentifier();
		}
	}
		
	Object rowObject = getElementAt(row);
	
	if (rowObject == null)
		return false;
		
	return ((VapJTableElement) rowObject).isFieldEditable(columnIdString, this);
}
/**
 *  Mark anObject for deletion from the database.
 */
private void markObjectRemoved(Object anObject) {
	
	try {
		((VapEJBObject) anObject).remove();
	}
	catch (RemoteException e) {handleException(e);}
	catch (RemoveException e) {handleException(e);}
}
/**
 * Default is to do nothing.
 */
protected void newTransactionObtained() {
	return ;
}
/*
 * Notify listeners that the selectedRowObject has changed.
 */

protected void notifySelectedRowChanged(Vector oldObjects, Vector newObjects) {
	
		
	Object oldObject, newObject;
	oldObject = oldObjects;
	switch (oldObjects.size()) {
		case 0:
		oldObject = null;
		break;
		case 1:
		oldObject = oldObjects.firstElement();
		break;
	}
		
	newObject = newObjects;
	switch (newObjects.size()) {
		case 0:
		newObject = null;
		break;
		case 1:
		newObject = newObjects.firstElement();
		break;
	}
	firePropertyChange("selectedRowObject", oldObject, newObject);
	
}
/*
 * Notify listeners that the selectedRowObjects have changed.
 */

protected void notifySelectedRowsChanged(Vector oldObjects, Vector newObjects) {

	firePropertyChange("selectedRowObjects", oldObjects, newObjects);
}
/**
 *
 */
private Object performGetValue(VapColumnIdentifier colIdentifier, Object rowObject) {
	String methodName = this.getGetterMethodName(colIdentifier);
	try {
		if (transaction == null)
			return VapMethodInvocation.performMethod(methodName, rowObject);
		else
			return transaction.transactionDo(methodName, rowObject);
	} catch (RuntimeException e) {
		return null;
	}
}
/**
 * Perform the "set" method on a rowObject using colIdentifier and setting the object's
 * value to aValue.  We must handle primitive types so determine the correct type
 * based on the return type for the "get" method.  Always pass primitive types in their
 * Object wrapper classes.
 */
private void performSetValue(VapColumnIdentifier colIdentifier, Object rowObject, Object aValue) {

	Class type = null;
	Class[] types = null;

	type = colIdentifier.getTypeForSetterMethod();
	types = new Class[1];
	types[0] = type;
	String methodName = this.getSetterMethodName(colIdentifier);
	Object[] args = new Object[1];
	args[0] = convertStringForPrimitiveWrappers((String)aValue, type);
	if (transaction == null)
		VapMethodInvocation.performMethod(methodName, rowObject, args, types);
	else
		transaction.transactionDo(methodName, rowObject, args, types);
}
/**
 *  Remove anIdentifier from the list of columnIdentifiers without any
 *  notification.
 */
protected void primRemoveColumnIdentifier(int anIdentifier) {

	getColumnIdentifiers().removeElementAt(anIdentifier);
}
/**
 *  Remove anIdentifier from the list of columnIdentifiers without any
 *  notification.
 */
protected void primRemoveColumnIdentifier(Object anIdentifier) {

	getColumnIdentifiers().removeElement(anIdentifier);
}
/**
 *  Remove all rows  from the model. Notification
 *  of the rows being removed will be sent to all the listeners.
 */
public void removeAllRows() {
	
	int size = getRowCount();
	Enumeration enum = getElements();
	while (enum.hasMoreElements()) 
		removeElement(enum.nextElement());
	
	// Generate notification
	fireTableRowsDeleted(0, size);
}
/**
 *  Remove all rows  from the model.  
 *  Mark each object for deletion from the database.  Notification
 *  of the rows being removed will be sent to all the listeners.
 */
public void removeAndDeleteAllRows() {

	Object next;
	
	int size = getRowCount();
	Enumeration enum = getElements();
	while (enum.hasMoreElements()) {
		next = enum.nextElement();
		removeElement(next);
		markObjectRemoved(next);
	}
	// Generate notification
	fireTableRowsDeleted(0, size);
}
/**
 *  Remove anObject from the model.  
 *  Mark the row object for deletion from the database.  Notification
 *  of the row being removed will be sent to all the listeners.
 */
 
public void removeAndDeleteRow(Object anObject) {
	int index = getIndexOf(anObject);
	removeElement(anObject);
	markObjectRemoved(anObject);
	// Generate notification
	fireTableRowsDeleted(index, index);
}
/**
 *  Remove the rows at intArray from the model.  
 *  Mark each row object for deletion from the database.  Notification
 *  of the rows being removed will be sent to all the listeners.
 */
public void removeAndDeleteRows(int[] intArray) {

	int save, remove, next, last, test;
	Object rv;

	save = intArray[0];
	last = save - 1;
	for (int i=0; i < intArray.length; i++) {
		next = intArray[i];
		remove = next - i;
		rv = getElementAt(remove);
		removeElement(rv);
		markObjectRemoved(rv);
		test = next - last;
		if (test != 1) {
			// Generate notification
			fireTableRowsDeleted(save, last);
			save = next;
		}
		last = next;
	}
	// Generate notification for the last interval
	fireTableRowsDeleted(save, last);
		
}
/**
 *  Remove the selectedRowObject from the model and mark it for 
 *  deletion from the database.  Notification
 *  of the row being removed will be sent to all the listeners.
 */
 
public void removeAndDeleteSelectedRow() {

	Object selected = getSelectedRowObject();

	if (selected == null) return ;
	
	int index = getIndexOf(selected);
	removeElement(selected);
	markObjectRemoved(selected);
	
	// Generate notification
	fireTableRowsDeleted(index, index);
}
/**
 *  Remove the selectedRows from the model and mark each for
 *  deletion from the database.  Notification
 *  of the row being removed will be sent to all the listeners.
 */
 
public void removeAndDeleteSelectedRows() {

	int[] selected = table.getSelectedRows();
	if (selected.length != 0)
		this.removeAndDeleteRows(selected);
}
/**
 *  Remove the column at the integer column.
 */
public void removeColumn(int column) {

	int modelIndex = table.convertColumnIndexToModel(column);
	
	if (table.getAutoCreateColumnsFromModel()) {
		removeColumnIdentifier(modelIndex);
	} else {
		TableColumn aColumn = getTableColumnModel().getColumn(column);
		getTableColumnModel().removeColumn(aColumn);
		columnIdentifiers.setElementAt(null, modelIndex);
	}
}
/**
 *  Remove anIdentifier from the list of columnIdentifiers.
 */
public void removeColumnIdentifier(int anIdentifier) {

	primRemoveColumnIdentifier(anIdentifier);
	fireTableStructureChanged();
}
/**
 * Remove anObject from the model's data collection.
 */
protected abstract void removeElement(Object anObject) ;
/**
 * Remove the element at aRow from the model's data collection.
 */
protected abstract void removeElementAt(int aRow) ;
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 *  Remove the row at <i>row</i> from the model.  Notification
 *  of the row being removed will be sent to all the listeners.
 *
 * @param   row      the row index of the row to be removed
 * @exception  ArrayIndexOutOfBoundsException  if the row was invalid.
 */
public void removeRow(int row) {
	removeElementAt(row);
	
	// Generate notification
	fireTableRowsDeleted(row, row);
}
/**
 *  Remove anObject from the model.  Notification
 *  of the row being removed will be sent to all the listeners.
 */
 
public void removeRow(Object anObject) {
	int index = getIndexOf(anObject);
	removeElement(anObject);
	
	// Generate notification
	fireTableRowsDeleted(index, index);
}
/**
 *  Remove the rows at intArray from the model.  Notification
 *  of the rows being removed will be sent to all the listeners.
 */
public void removeRows(int[] intArray) {

	int save, remove, next, last, test;

	if (intArray.length == 0) return ;

	save = intArray[0];
	last = save - 1;
	for (int i=0; i < intArray.length; i++) {
		next = intArray[i];
		remove = next - i;
		removeElementAt(remove);
		test = next - last;
		if (test != 1) {
			// Generate notification
			fireTableRowsDeleted(save, last);
			save = next;
		}
		last = next;
	}
	// Generate notification for the last interval
	fireTableRowsDeleted(save, last);
		
}
/**
 *  Remove the column at the integer column.
 */
public void removeSelectedColumn() {

	removeColumn(table.getSelectedColumn());
}
/**
 *  Remove the selectedRowObject from the model.  Notification
 *  of the row being removed will be sent to all the listeners.
 */
 
public void removeSelectedRow() {

	Object selected = getSelectedRowObject();

	if (selected == null) return ;
	
	int index = getIndexOf(selected);
	removeElement(selected);
	
	// Generate notification
	fireTableRowsDeleted(index, index);
}
/**
 *  Remove the selectedRows from the model.  Notification
 *  of the row being removed will be sent to all the listeners.
 */
 
public void removeSelectedRows() {

	int[] selected = table.getSelectedRows();
	this.removeRows(selected);
}
/*
 * resume trans.
 */

protected void resumeTransaction(Transaction trans) {

	try {
		trans.resume();
	} catch (VapTransactionRequiredException e) { }

}
/**
 * Replaces the column identifiers in the model.
 *
 */
public void setColumnIdentifiers(Object[] newIdentifiers) {
	if (newIdentifiers != null) {
		Vector aVector = ArrayVectorTransform.toVector(newIdentifiers);
		setColumnIdentifiers(aVector);
	}
}
/**
 *  
 */
public void setColumnIdentifiers(String string) {

	Vector result;
	
	if (string == null) {
		result = new Vector();
	} else {
		result = convertColumnIdStringToVector(string);
	}
	setColumnIdentifiers(result);
}
/**
 * Replaces the column identifiers in the model.
 *
 * @param   newIdentifiers  Vector of column identifiers.  A null means
 *                          setting the model to zero columns
 * @see #setNumRows()
 */
public void setColumnIdentifiers(Vector newIdentifiers) {
	
	if (newIdentifiers != null) {
		if (newIdentifiers.size() == 0) return ;
		columnIdentifiers = newIdentifiers;
	}
	else {
		columnIdentifiers = new Vector();
	}

	// Generate notification
	fireTableStructureChanged();
}
/**
 * 
 */
private void setColumnIdsFromColumns(TableColumnModel aColumnModel) {
	
	if (aColumnModel != null) {
		Enumeration columns = aColumnModel.getColumns();
		int index;
		Object[] array = new Object[aColumnModel.getColumnCount()];
		while (columns.hasMoreElements()) {
			TableColumn col = (TableColumn) columns.nextElement();
			index = col.getModelIndex();
			array[index] = new VapColumnIdentifier((String) col.getIdentifier());
		}
		setColumnIdentifiers(array);
	}
}
		
/*
 * Set the selectedRowObject to be the object for the selectedRow integer.
 * Fire a property change only if the previously selectedRowObject is
 * different than the current selectedRowObject.
 */

protected void setSelectedRowObjects() {

	
	int index, arrayLength;
	Vector oldObjects = (Vector) getSelectedRowObjects().clone();

	getSelectedRowObjects().removeAllElements();
	int[] intArray = table.getSelectedRows();
	arrayLength = intArray.length;
	for (int i=0; i < arrayLength; i++) {
		index = intArray[i];
		if (index >= 0)
			selectedRowObjects.addElement(getElementAt(index));
	}
	Object newSingleSelection = getSelectedRowObject();
	notifySelectedRowsChanged(oldObjects, selectedRowObjects);
	notifySelectedRowChanged(oldObjects, selectedRowObjects);
}
/**
 * Set the table.
 * Add ourself as a list selection listener to the table's selection model so that
 * we will be informed when a selection is made.
 */
public void setTable(JTable aTable) {
	JTable oldTable = table;
	if (oldTable == aTable) return;
	if (oldTable != null)
		oldTable.getSelectionModel().removeListSelectionListener((ListSelectionListener) this);
	table = aTable;
	if (aTable != null) {
		//this.setColumnIdsFromColumns(aTable.getColumnModel());
		aTable.setModel(this);
		aTable.getSelectionModel().addListSelectionListener((ListSelectionListener) this);
	}
}
/**
 * set the transaction
 */
public void setTransaction(Transaction aTransaction) {
	Transaction oldValue = transaction;
	transaction = aTransaction;
	if (oldValue != transaction)
		newTransactionObtained();
}
/**
 * Sets the object value for the cell cell at <I>row</I>
 * and <I>column</I>.  This method
 * will generate a tableChanged() notification.
 *
 * @param   row             the row whose value is to be looked up
 * @param   column          the column whose value is to be looked up
 * @return                  the value Object at the specified cell
 * @exception  ArrayIndexOutOfBoundsException  if an invalid row or
 *               column was given.
 */
public void setValueAt(Object aValue, int row, int column) {
	Object rowObject = getElementAt(row);
	VapColumnIdentifier colIdentifier = (VapColumnIdentifier) columnIdentifiers.elementAt(column);
	this.performSetValue(colIdentifier, rowObject, aValue);

	// generate notification
	fireTableChanged(new TableModelEvent(this, row, row, column));
}
/*
 * Listen for selection changes in the table.  When a selection event
 * is encountered, set the selectedRowObject to be the object selected
 * in the table.
 */

public void valueChanged(com.sun.java.swing.event.ListSelectionEvent e) {
	if (e.getValueIsAdjusting() == false) 
		setSelectedRowObjects();
}
}