package com.ibm.vap.swing.table;

import java.util.Enumeration;
import java.util.Vector;
import com.sun.java.swing.event.TableModelEvent;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapTransactionRequiredException;
import com.ibm.vap.Transactions.LinkCollectionShell;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEvent;
import com.ibm.vap.Transactions.VapTransactionalEvent;
import com.ibm.vap.Transactions.Transaction;

/**
 * This type was created in VisualAge.
 */
public class VapDefaultRelationshipTableModel extends VapAbstractTableModel {

	/** The Vector of Vector of Object values */
	protected LinkCollectionShell dataShell;
/**
 * VapDefaultRelationshipTableModel constructor comment.
 */
public VapDefaultRelationshipTableModel() {
	
}
/**
 * This is the callback that one of our dependents has signalled an event
 */
public void actionPerformed(VapEvent event) {

	if ((event.getSource() == dataShell) && (event.getEventName() == "addedItems")) {
		fireTableRowsInserted(event);
		return ;
	}

	if ((event.getSource() == dataShell) && (event.getEventName() == "removedItems")) {
		fireTableRowsDeleted(event);
		return ;
	}

	if ((event.getSource() == dataShell) && (event.getEventName() == "objectChanged")) {
		fireTableRowUpdated(event);
		return ;
	}

	if ((event.getSource() == dataShell) && (event.getEventName() == "replacedItems")) {
		fireTableRowsUpdated(event);
		return ;
	}
}
/**
 *  Add anObject to the dataShell.
 */
private void addElement(VapEJBObject anEJBObject) {

	Transaction current = cacheCurrentAndResumeTransaction();
	
	try {
		dataShell.addElement(anEJBObject);
	} catch (RemoteException e) {
		handleException(e);
	}

	resumeTransaction(current);
}
/**
 *  Add anObject to the dataShell.
 */
protected void addElement(Object anObject) {
	addElement((VapEJBObject) anObject);
}
/**
 * Inform the table of the removed rows from a VapEvent.
 */
protected void fireTableRowsDeleted(VapEvent event) {

	int first, last;
	Vector data, indices;

	if ((transaction == null) || (transaction == ((VapTransactionalEvent)event).getTransaction())) {
		data = (Vector)event.getEventData();
		indices = (Vector)data.lastElement();
		first = ((Integer)indices.firstElement()).intValue();
		last = ((Integer)indices.lastElement()).intValue();
	
		fireTableRowsDeleted(first, last);

		//this is necessary to clean up rows that still appear at the bottom
		table.repaint();
	}
}
/**
 * Inform the table of the added rows from a VapEvent.
 */
protected void fireTableRowsInserted(VapEvent event) {

	int first, last;
	Vector data, indices;

	if ((transaction == null) || (transaction == ((VapTransactionalEvent)event).getTransaction())) {
		data = (Vector)event.getEventData();
		indices = (Vector)data.lastElement();
		first = ((Integer)indices.firstElement()).intValue();
		last = ((Integer)indices.lastElement()).intValue();
	
		fireTableRowsInserted(first, last);
	}
}
/**
 * Inform the table of the removed rows from a VapEvent.
 */
protected void fireTableRowsUpdated(VapEvent event) {


	int first, last;
	Vector data, indices;

	if ((transaction == null) || (transaction == ((VapTransactionalEvent)event).getTransaction())) {
		data = (Vector)event.getEventData();
		indices = (Vector)data.lastElement();
		first = ((Integer)indices.firstElement()).intValue();
		last = ((Integer)indices.lastElement()).intValue();

		fireTableRowsUpdated(first, last);
	}
}
/**
 * Inform the table of the removed rows from a VapEvent.
 */
protected void fireTableRowUpdated(VapEvent event) {


	if ((transaction == null) || (transaction == ((VapTransactionalEvent)event).getTransaction())) {
		int index = ((Integer)event.getEventData()).intValue();

		fireTableRowsUpdated(index, index);
	}
}
/**
 * Return the object within the dataShell at the index aRow.
 */
public Object getElementAt(int aRow) {

	Object result = null;
	
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		result = dataShell.elementAt(aRow);
	} 
	catch (RemoteException e) {
		result = null;
	}
	resumeTransaction(current);
	return result;
	
}
/**
 * Return an Enumeration of the model's data collection.
 */
protected Enumeration getElements() {
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		return dataShell.elements();
	} catch (RemoteException e) {
		handleException(e);
	}
	resumeTransaction(current);
	return null;
}
private int getIndexOf(VapEJBObject elem) {

	int index = -1;

	Transaction current = cacheCurrentAndResumeTransaction();
	
	try {
		index = dataShell.indexOf(elem);
	} catch (RemoteException e) {
		handleException(e);
	}
	resumeTransaction(current);
	return index;
}
/**
 * Return the index of anObject within the model.
 */
protected int getIndexOf(Object anObject) {
	return getIndexOf((VapEJBObject) anObject);
}
//
// Implementing the TableModel interface
//

/**
 * @return the number of rows in the model.
 */
public int getRowCount() {

	int shellSize = 0;
	
	Transaction current = cacheCurrentAndResumeTransaction();
	
	if (dataShell != null) {
		try {
			shellSize = dataShell.size();
		} catch (RemoteException e) {}
	}
	resumeTransaction(current);
	return shellSize;	
}
/**
 * Reset the relationship to be the dataShell.
 */
protected void newTransactionObtained() {

	if (dataShell != null && !dataShell.isConnected())
		dataShell = null ;   	
	/*The transaction has been committed or rolledback without the
	dataShell being set to null, so set it to null before proceeding.*/
	setRelationship(dataShell);
}
/**
 * Remove anObject from the model's data collection.
 */
private void removeElement(VapEJBObject anEJBObject) {

	Transaction current = cacheCurrentAndResumeTransaction();
	
	try {
		dataShell.removeElement(anEJBObject);
	} catch (RemoteException e) {
		handleException(e);
	}
	resumeTransaction(current);
}
/**
 * Remove anObject from the model's data collection.
 */
protected void removeElement(Object anObject) {

	this.removeElement((VapEJBObject) anObject);
}
/**
 * Remove the element at aRow from the model's dataShell.
 */
protected void removeElementAt(int aRow) {
	
	Object rv = null;
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		rv = dataShell.elementAt(aRow);
		dataShell.removeElement((VapEJBObject) rv);
	} catch (RemoteException e) {
		handleException(e);
	}
	resumeTransaction(current);
}
/**
 * This method was created in VisualAge.
 */
public void setRelationship(LinkCollectionShell aRelationship) {

	int index = 0;
	LinkCollectionShell oldValue = dataShell;
	if (dataShell != null) {
		dataShell.removeActionListener(this);
		dataShell.removeAsPropertyChangeListenerFromAll();
	}
	dataShell = aRelationship;
	if (aRelationship != null) {
		dataShell.addActionListener(this);
		try {
			index = dataShell.size() - 1;
		} catch (RemoteException e) {
			handleException(e);
		}
	}
	//force the table to repaint itself
	table.repaint();
	clearSelection();
	fireTableRowsInserted(0, index);
	
}
public String toString() {
	return dataShell.toString();
}
}