/* *********************************************************************** */
/*  Sample program to call a VG called application and pass it a structure */
/*   (i.e. record). The VA/G application is dynamically loaded by this C   */
/*   program. AIX version.                                                 */
/* *********************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <sys/ldr.h>
#include <errno.h>

extern "C" {
    int (*loadAndInit(char *name, int flags, char *path))();
    int terminateAndUnload (int (*entryPoint)());
}

void Unpack(char* packItem, char* packString);

#pragma options align=packed
typedef struct
{
   short  bin2Item;
   long   bin4Item;
   double bin8Item;
   char   chaItem[8];
   char   hexItem[4];
   char   numItem[8];
   char   numcItem[8];
   char   packItem[3];
   char   pacfItem[3];
} record;

typedef int (*PFN)();
typedef int (*VGAPP)(void* wsRecord, int* vgRC);

main()
{
   PFN      funcPtr;
   VGAPP    vgPtr;
   char     packString[20];
   int      rc = 0;
   int      vgRC = 0;
   record   wsRecord;
   wsRecord.bin2Item = 0;
   wsRecord.bin4Item = 0;
   wsRecord.bin8Item = 0;
   char     vgApp[30] = "VGCALL1.dll";
   char*    libPath = 0;

   printf("Entering AC2VG1C\n");

   memset(wsRecord.chaItem, ' ', sizeof(wsRecord.chaItem));
   memset(wsRecord.hexItem, ' ', sizeof(wsRecord.hexItem));
   memset(wsRecord.numItem, ' ', sizeof(wsRecord.numItem));
   memset(wsRecord.numcItem, ' ', sizeof(wsRecord.numcItem));
   memset(wsRecord.packItem, ' ', sizeof(wsRecord.packItem));
   memset(wsRecord.pacfItem, ' ', sizeof(wsRecord.pacfItem));

   libPath = getenv("FCWLIBPATH");   /* Get contents of environment variable */
                                     /*  for application search path         */

   printf("Loading the VA/G application, %s\n", vgApp);

   errno = 0;
   funcPtr = loadAndInit(vgApp, 1, libPath);
   if (funcPtr == 0)
   {
      perror("load");
      printf("AC2VG1C - loadAndInit for %s failed: errno = %d\n",
              vgApp, errno);
      exit(1);
   }

   printf("Calling %s\n", vgApp);

   vgPtr = (VGAPP)funcPtr;
   (*vgPtr)(&wsRecord, &vgRC);

   printf("Return from %s, rc = %d\n", vgApp, vgRC);

   printf("bin2Item = %d\n", wsRecord.bin2Item);
   printf("bin4Item = %d\n", wsRecord.bin4Item);
   printf("bin8Item = %d\n", wsRecord.bin8Item);
   printf("chaItem  = %8.8s\n", wsRecord.chaItem);
   printf("hexItem  = %4.4s\n", wsRecord.hexItem);
   printf("numItem  = %8.8s\n", wsRecord.numItem);
   printf("numcItem = %8.8s\n", wsRecord.numcItem);

   memset(packString, 0, sizeof(packString));
   Unpack(wsRecord.packItem, packString);
   printf("packItem = %s\n", packString);

   memset(packString, 0, sizeof(packString));
   Unpack(wsRecord.pacfItem, packString);
   printf("pacfItem = %s\n", packString);


   terminateAndUnload(funcPtr);
}

/* *********************************************************************** */
/* Subroutine to convert VA/G PACK & PACF data items to a character string */
/* *********************************************************************** */
void Unpack(char* packItem, char* packString)
{
   char temp;
   int i,j = 0;

   packString[j] = ' ';                 /* Assume positive number   */
   j++;                                 /* Increment target string ptr */

   for (i = 0; i < 10; i++)             /* Max length in bytes of a  */
   {                                    /*  VG pack/f data item = 10 */
      temp = packItem[i];
      temp >>= 4;                       /* Isolate the left nibble  */
      temp += 48;                       /* Convert it to ascii      */
      packString[j] = temp;
      j++;                              /* Increment target string ptr */

      temp = packItem[i];
      temp &= 0x0F;                     /* Isolate the right nibble */

      if ((temp == 0x0F) || (temp == 0x0C))  /* Look for the sign   */
      {
         break;                         /* Positive, leave asis     */
      }

      if ((temp == 0x0B) || (temp == 0x0D))  /* Look for the sign   */
      {
         packString[0] = '-';           /* Indicate negative        */
         break;
      }

      temp += 48;                       /* Convert it to ascii      */
      packString[j] = temp;
      j++;                              /* Increment target string ptr */
   }

}
