/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.BundleResolver;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleResolverImpl
implements BundleResolver {
    private static TraceComponent tc = Tr.register(BundleResolverImpl.class, null, null);
    private static final Map svResourceBundles = new HashMap();
    private static final List svRegexpBundles = new ArrayList();
    private static Map svResourceBundleCache = Collections.synchronizedMap(new HashMap());

    public ResourceBundle resolve(String string, Locale locale) {
        ResourceBundleCacheEntry resourceBundleCacheEntry = (ResourceBundleCacheEntry)svResourceBundleCache.get(string);
        if (resourceBundleCacheEntry != null && resourceBundleCacheEntry.locale.equals(locale)) {
            return resourceBundleCacheEntry.bundle;
        }
        ResourceBundle resourceBundle = BundleResolverImpl.getOSGiResourceBundle(string, locale);
        if (resourceBundle != null && locale != null) {
            svResourceBundleCache.put(string, new ResourceBundleCacheEntry(resourceBundle, locale));
        }
        return resourceBundle;
    }

    private static ResourceBundle getResourceBundleFromOSGiBundle(final String string, final Locale locale, final Bundle bundle) {
        ResourceBundle resourceBundle;
        block5: {
            resourceBundle = null;
            try {
                resourceBundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Class clazz = bundle.loadClass(string);
                        return ResourceBundle.getBundle(string, locale, clazz.getClassLoader());
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found resource bundle " + string + " in OSGi bundle " + bundle.getSymbolicName());
                }
            }
            catch (Exception exception) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "unable to load resource bundle " + string + " from OSGi bundle " + bundle.getSymbolicName() + ": " + exception.getMessage());
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unable to load resource bundle " + string + " from OSGi bundle " + bundle.getSymbolicName() + ": " + noClassDefFoundError.getMessage());
            }
        }
        return resourceBundle;
    }

    private static ResourceBundle getOSGiResourceBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        if (svResourceBundles.containsKey(string)) {
            Bundle bundle = (Bundle)svResourceBundles.get(string);
            resourceBundle = BundleResolverImpl.getResourceBundleFromOSGiBundle(string, locale, bundle);
        } else {
            Iterator iterator = svRegexpBundles.iterator();
            while (iterator.hasNext() && resourceBundle == null) {
                BundleEntry bundleEntry = (BundleEntry)iterator.next();
                Pattern pattern = bundleEntry.getRegExp();
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                resourceBundle = BundleResolverImpl.getResourceBundleFromOSGiBundle(string, locale, bundleEntry.getBundle());
            }
        }
        return resourceBundle;
    }

    static {
        ExtensionRegistryFactory extensionRegistryFactory = ExtensionRegistryFactory.instance();
        IExtensionRegistry iExtensionRegistry = extensionRegistryFactory.getExtensionRegistry();
        if (extensionRegistryFactory.isEclipse() && iExtensionRegistry != null) {
            String string;
            IExtensionPoint iExtensionPoint;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In running eclipse environment");
            }
            if ((iExtensionPoint = iExtensionRegistry.getExtensionPoint(string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".message-bundle")) != null) {
                IExtension[] iExtensionArray;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extension point, " + string + ", found");
                }
                if ((iExtensionArray = iExtensionPoint.getExtensions()) != null) {
                    for (int i = 0; i < iExtensionArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Extension, " + iExtensionArray[i].getExtensionPointUniqueIdentifier() + ", being processed");
                        }
                        IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
                        Bundle bundle = Platform.getBundle((String)iExtensionArray[i].getNamespace());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "osgi bundle is - " + bundle.getSymbolicName());
                        }
                        for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                            String string2 = iConfigurationElementArray[j].getAttribute("class");
                            String string3 = iConfigurationElementArray[j].getAttribute("regexp");
                            if (string2 != null && !"".equals(string2)) {
                                svResourceBundles.put(string2, bundle);
                            }
                            if (string3 == null || "".equals(string3)) continue;
                            svRegexpBundles.add(new BundleEntry(string3, bundle));
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extension point, " + string + ", NOT found");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not in a running eclipse environment");
        }
    }

    private static class ResourceBundleCacheEntry {
        ResourceBundle bundle;
        Locale locale;

        ResourceBundleCacheEntry(ResourceBundle resourceBundle, Locale locale) {
            this.bundle = resourceBundle;
            this.locale = locale;
        }
    }

    private static class BundleEntry {
        private String _regExp;
        private Pattern _compiledRegExp;
        private Bundle _bundle;

        public BundleEntry(String string, Bundle bundle) {
            this._regExp = string;
            this._bundle = bundle;
        }

        public Pattern getRegExp() {
            if (this._compiledRegExp == null) {
                this._compiledRegExp = Pattern.compile(this._regExp);
            }
            return this._compiledRegExp;
        }

        public Bundle getBundle() {
            return this._bundle;
        }
    }
}

