/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.MessageEvent6;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

class WrappingFileOutputStream
extends OutputStream {
    private static final TraceComponent svTc = Tr.register(WrappingFileOutputStream.class, null, "com.ibm.ejs.resources.RasMessages");
    private static Timer svTimer = null;
    private static final String svSepChar = "_";
    private boolean ivSizeRollover = false;
    private boolean ivTimeRollover = false;
    private long ivMaxFileSize;
    private long ivCurFileSize = 0L;
    private int ivBaseTime;
    private int ivRolloverPeriod;
    private String ivMainFileName = null;
    private File ivMainFile = null;
    private String ivDirectory = null;
    private String ivNamePrefix = null;
    private String ivNameSuffix = null;
    private String ivBackupFilePrefix = null;
    private int ivMaxBackups;
    private String[] ivBackupFiles = null;
    private String ivPreviousTime = "";
    private SimpleDateFormat ivDateFormatter = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
    private FileOutputStream ivFileStream = null;
    private LogRolloverListener ivLRL = null;

    private static synchronized Timer getTimer() {
        if (svTimer == null) {
            svTimer = new Timer(true);
        }
        return svTimer;
    }

    WrappingFileOutputStream(String string, int n) throws RasException, IOException {
        this(string, 0, n, 0x1400000L, 24, 24);
    }

    WrappingFileOutputStream(String string, int n, long l) throws RasException, IOException {
        this(string, 1, n, l, 24, 24);
    }

    WrappingFileOutputStream(String string, int n, int n2, int n3) throws RasException, IOException {
        this(string, 2, n, 0x1400000L, n2, n3);
    }

    WrappingFileOutputStream(String string, int n, int n2, long l, int n3, int n4) throws RasException, IOException {
        this.ivMainFileName = string;
        this.ivMainFile = new File(string);
        this.ivMaxFileSize = l < 1L ? 0x1400000L : l;
        this.ivMaxBackups = n2 < 1 ? 1 : n2;
        this.ivBaseTime = n3 < 1 || n3 > 24 ? 0 : n3 - 1;
        this.ivRolloverPeriod = n4 < 1 || n4 > 24 ? 24 : n4;
        this.ivBackupFiles = new String[this.ivMaxBackups];
        this.doBasicRolloverSetup();
        if (n != 0) {
            this.doCommonRolloverSetup();
            if ((n & 1) != 0) {
                this.doSizeBasedRolloverSetup();
            }
            if ((n & 2) != 0) {
                try {
                    this.doTimeBasedRolloverSetup();
                }
                catch (RasException rasException) {
                    this.forceSizeBasedRollover(rasException);
                }
            }
        }
        this.ivFileStream = RasHelper.createFileOutputStream(this.ivMainFileName, true);
    }

    public synchronized void write(int n) throws IOException {
        if (this.ivSizeRollover) {
            this.incrementCount(1);
        }
        this.ivFileStream.write(n);
    }

    public synchronized void write(byte[] byArray) throws IOException {
        if (this.ivSizeRollover) {
            this.incrementCount(byArray.length);
        }
        this.ivFileStream.write(byArray);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.ivSizeRollover) {
            this.incrementCount(n2);
        }
        this.ivFileStream.write(byArray, n, n2);
    }

    public synchronized void flush() throws IOException {
        this.ivFileStream.flush();
    }

    public synchronized void close() throws IOException {
        this.ivFileStream.close();
    }

    public synchronized void addRolloverListener(LogRolloverListener logRolloverListener) {
        this.ivLRL = logRolloverListener;
    }

    String rolloverImmediate(String string) throws IOException {
        if (string == null) {
            return this.switchFiles();
        }
        return this.switchFiles(string);
    }

    void rolloverImmediate() throws RasException {
        try {
            this.switchFiles();
        }
        catch (IOException iOException) {
            throw new RasException("Request to roll log file " + this.ivMainFileName + " failed", iOException);
        }
        try {
            this.scheduleTimeBasedRollover();
        }
        catch (RasException rasException) {
            this.forceSizeBasedRollover(rasException);
        }
    }

    private void incrementCount(int n) throws IOException {
        this.ivCurFileSize += (long)n;
        if (this.ivCurFileSize >= this.ivMaxFileSize) {
            this.switchFiles();
            this.ivCurFileSize = n;
        }
    }

    private synchronized String switchFiles() throws IOException {
        this.ivFileStream.flush();
        this.ivFileStream.close();
        try {
            String string = null;
            File file = null;
            boolean bl = true;
            for (int i = 0; bl && i < 3; ++i) {
                String string2 = this.generateTimeStampQualifier();
                string = this.ivBackupFilePrefix + string2 + this.ivNameSuffix;
                file = new File(string);
                bl = RasHelper.fileExists(file);
            }
            if (bl) {
                return null;
            }
            return this.switchFiles(string);
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{this.ivMainFileName, throwable};
            MessageEvent6 messageEvent6 = new MessageEvent6(4, svTc, "archiveCurrentFile", "MSG_ROLLOVER_FAILED_EXCEPTION", objectArray);
            Tr.queueInternalEvent(messageEvent6);
            return null;
        }
    }

    private synchronized String switchFiles(String string) throws IOException {
        this.ivFileStream.flush();
        this.ivFileStream.close();
        File file = new File(string);
        if (RasHelper.fileExists(file)) {
            throw new IOException("file " + string + " already exists");
        }
        boolean bl = RasHelper.renameFile(this.ivMainFile, file);
        this.ivCurFileSize = 0L;
        try {
            this.ivFileStream = RasHelper.createFileOutputStream(this.ivMainFileName, true);
            if (this.ivLRL != null) {
                this.ivLRL.logRolled();
            }
        }
        catch (RasException rasException) {
            throw new IOException("Unable to open log file " + this.ivMainFileName);
        }
        if (!bl) {
            throw new IOException("Unable to rename file " + this.ivMainFileName + " to " + string + ". Logging continues");
        }
        int n = this.ivBackupFiles.length - 1;
        String string2 = this.ivBackupFiles[n];
        if (string2 != null) {
            RasHelper.deleteFile(new File(string2));
        }
        int n2 = n;
        int n3 = n - 1;
        while (n2 > 0) {
            this.ivBackupFiles[n2] = this.ivBackupFiles[n3];
            --n2;
            --n3;
        }
        this.ivBackupFiles[0] = string;
        return string;
    }

    private String generateTimeStampQualifier() {
        Date date = new Date(System.currentTimeMillis());
        String string = this.ivDateFormatter.format(date);
        int n = 20;
        while (string.equals(this.ivPreviousTime)) {
            if (--n <= 0) {
                return string;
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            date = new Date(System.currentTimeMillis());
            string = this.ivDateFormatter.format(date);
        }
        this.ivPreviousTime = string;
        return string;
    }

    private void scheduleTimeBasedRollover() throws RasException {
        try {
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(11);
            if (this.ivBaseTime > n) {
                calendar.add(5, -1);
            }
            calendar.set(11, this.ivBaseTime);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date date = calendar.getTime();
            Calendar calendar2 = Calendar.getInstance();
            while (calendar.before(calendar2)) {
                calendar.add(11, this.ivRolloverPeriod);
            }
            if (calendar.equals(calendar2)) {
                calendar.add(11, this.ivRolloverPeriod);
            }
            Date date2 = calendar.getTime();
            Timer timer = WrappingFileOutputStream.getTimer();
            WrappingFileRoller wrappingFileRoller = new WrappingFileRoller(this);
            timer.schedule((TimerTask)wrappingFileRoller, date2);
        }
        catch (Throwable throwable) {
            throw new RasException("Scheduling a timer rollover event failed", throwable);
        }
    }

    private void forceSizeBasedRollover(RasException rasException) {
        if (!this.ivSizeRollover) {
            this.ivSizeRollover = true;
            boolean bl = RasHelper.fileExists(this.ivMainFile);
            this.ivCurFileSize = !bl ? 0L : RasHelper.getFileLength(this.ivMainFile);
        }
        Object[] objectArray = new Object[]{this.ivMainFileName, rasException};
        MessageEvent6 messageEvent6 = new MessageEvent6(4, svTc, "forceSizeBasedRollover", "MSG_SCHEDULE_TIME_ROLLOVER_FAILED", objectArray);
        Tr.queueInternalEvent(messageEvent6);
    }

    private void doBasicRolloverSetup() throws RasException {
        int n = this.ivMainFileName.lastIndexOf(File.separator);
        if (n == -1) {
            throw new RasException(this.ivMainFileName + " does not contain a path separator character");
        }
        this.ivDirectory = this.ivMainFileName.substring(0, n);
        String string = this.ivMainFileName.substring(n + 1, this.ivMainFileName.length());
        if (string == null || string.equals("")) {
            throw new RasException(this.ivMainFileName + " is not a proper fully qualified file name");
        }
        n = string.lastIndexOf(46);
        if (n == -1) {
            this.ivNamePrefix = string;
            this.ivNameSuffix = null;
        } else {
            this.ivNamePrefix = string.substring(0, n);
            this.ivNameSuffix = string.substring(n, string.length());
        }
        this.ivBackupFilePrefix = this.ivDirectory + File.separator + this.ivNamePrefix + svSepChar;
    }

    private void doCommonRolloverSetup() {
        this.generateBackupFileList();
    }

    private void doSizeBasedRolloverSetup() {
        this.ivSizeRollover = true;
        boolean bl = RasHelper.fileExists(this.ivMainFile);
        this.ivCurFileSize = !bl ? 0L : RasHelper.getFileLength(this.ivMainFile);
    }

    private void doTimeBasedRolloverSetup() throws RasException {
        this.ivTimeRollover = true;
        try {
            this.scheduleTimeBasedRollover();
        }
        catch (RasException rasException) {
            this.scheduleTimeBasedRollover();
        }
    }

    private void generateBackupFileList() {
        try {
            for (int i = 0; i < this.ivMaxBackups; ++i) {
                this.ivBackupFiles[i] = null;
            }
            String[] stringArray = RasHelper.listFileNames(new File(this.ivDirectory));
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            String string = this.ivDirectory + File.separator;
            int n = stringArray.length;
            Vector<String> vector = new Vector<String>(n);
            Vector<Long> vector2 = new Vector<Long>(n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l;
                File file;
                String string2 = string + stringArray[i];
                if (!string2.startsWith(this.ivBackupFilePrefix) || !RasHelper.isFile(file = new File(string2)) || (l = this.getFileTimestamp(stringArray[i])) == 0L) continue;
                vector.addElement(string2);
                vector2.addElement(new Long(l));
                ++n2;
            }
            if (!vector.isEmpty()) {
                this.sortAndDeleteFiles(vector, vector2);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private long getFileTimestamp(String string) {
        long l = 0L;
        String string2 = null;
        try {
            if (string.startsWith(this.ivNamePrefix)) {
                string2 = string.substring(this.ivNamePrefix.length() + 1);
                if (this.ivNameSuffix != null) {
                    if (string2.endsWith(this.ivNameSuffix)) {
                        string2 = string2.substring(0, string2.length() - this.ivNameSuffix.length());
                    } else {
                        return l;
                    }
                }
                Date date = this.ivDateFormatter.parse(string2);
                l = date.getTime();
            }
            return l;
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    private void sortAndDeleteFiles(Vector vector, Vector vector2) {
        String[] stringArray = null;
        try {
            int n;
            int n2;
            int n3 = vector.size();
            stringArray = new String[n3];
            long[] lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = (String)vector.elementAt(n2);
                lArray[n2] = (Long)vector2.elementAt(n2);
            }
            n2 = stringArray.length;
            boolean bl = true;
            while (bl) {
                bl = false;
                n = 0;
                for (int i = 1; i < n2; ++i) {
                    if (lArray[n] < lArray[i]) {
                        long l = lArray[n];
                        String string = stringArray[n];
                        lArray[n] = lArray[i];
                        lArray[i] = l;
                        stringArray[n] = stringArray[i];
                        stringArray[i] = string;
                        bl = true;
                    }
                    ++n;
                }
            }
            if (n2 <= this.ivMaxBackups) {
                System.arraycopy(stringArray, 0, this.ivBackupFiles, 0, n2);
            } else {
                System.arraycopy(stringArray, 0, this.ivBackupFiles, 0, this.ivMaxBackups);
                for (n = this.ivMaxBackups; n < n2; ++n) {
                    if (stringArray[n] == null) continue;
                    RasHelper.deleteFile(new File(stringArray[n]));
                }
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    String[] getBackupFileList() {
        if (this.ivBackupFiles == null || this.ivBackupFiles.length == 0) {
            return null;
        }
        int n = this.ivBackupFiles.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.ivBackupFiles[i];
        }
        return stringArray;
    }

    class WrappingFileRoller
    extends TimerTask {
        private WrappingFileOutputStream ivFile;

        WrappingFileRoller(WrappingFileOutputStream wrappingFileOutputStream2) {
            this.ivFile = wrappingFileOutputStream2;
        }

        public void run() {
            try {
                this.ivFile.rolloverImmediate();
            }
            catch (RasException rasException) {
                // empty catch block
            }
        }
    }
}

