/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASUtil;
import com.ibm.ras.mgr.RASGroup;
import com.ibm.ras.mgr.RASManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class RASBaseGroup
extends RASGroup
implements Cloneable {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -5797962705232046385L;
    private Hashtable groups = new Hashtable();
    private String defaultHandlers = null;
    private String defaultMessageHandlers = null;
    private String defaultTraceHandlers = null;

    public RASBaseGroup() {
        super(RASUtil.rasMsgs.getMessage("BASE_GROUP_NAME"));
    }

    public synchronized Object clone() {
        RASBaseGroup rASBaseGroup = (RASBaseGroup)super.clone();
        rASBaseGroup.groups = (Hashtable)this.groups.clone();
        return rASBaseGroup;
    }

    public void addGroup(RASGroup rASGroup) {
        if (rASGroup != null) {
            this.groups.put(rASGroup.getName(), rASGroup);
        }
    }

    public void removeGroup(RASGroup rASGroup) {
        if (rASGroup != null) {
            this.groups.remove(rASGroup.getName());
        }
    }

    public RASGroup getGroup(String string) {
        RASGroup rASGroup = null;
        if (string != null) {
            rASGroup = (RASGroup)this.groups.get(string);
        }
        return rASGroup;
    }

    public Hashtable getGroups() {
        return this.groups;
    }

    public String getDefaultHandlers() {
        return this.defaultHandlers;
    }

    public void setDefaultHandlers(String string) {
        this.defaultHandlers = string;
    }

    public String getDefaultMessageHandlers() {
        return this.defaultMessageHandlers;
    }

    public void setDefaultMessageHandlers(String string) {
        this.defaultMessageHandlers = string;
    }

    public String getDefaultTraceHandlers() {
        return this.defaultTraceHandlers;
    }

    public void setDefaultTraceHandlers(String string) {
        this.defaultTraceHandlers = string;
    }

    public void updateActiveObjects(RASBaseGroup rASBaseGroup, RASManager rASManager) {
        if (rASBaseGroup != null) {
            super.updateActiveObjects(rASBaseGroup, rASManager);
            Enumeration enumeration = rASBaseGroup.getGroups().elements();
            while (enumeration.hasMoreElements()) {
                RASGroup rASGroup = (RASGroup)enumeration.nextElement();
                String string = rASGroup.getName();
                RASGroup rASGroup2 = this.getGroup(string);
                if (rASGroup2 == null) {
                    this.addGroup(rASGroup);
                    continue;
                }
                rASGroup2.updateActiveObjects(rASGroup, rASManager);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\r\n");
        stringBuffer.append(super.toString());
        if (!this.groups.isEmpty()) {
            Enumeration enumeration = this.groups.elements();
            while (enumeration.hasMoreElements()) {
                RASGroup rASGroup = (RASGroup)enumeration.nextElement();
                stringBuffer.append(rASGroup.toString());
            }
        }
        if (this.defaultHandlers != null) {
            stringBuffer.append("Default Handlers:  " + this.defaultHandlers + "\r\n");
        }
        return stringBuffer.toString();
    }
}

