/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import java.io.Serializable;

public class ConfigDataId
implements Serializable {
    private static final long serialVersionUID = 7618627032319811532L;
    private static long max_local_id = 0L;
    public static final char delimiter = '|';
    private static final char hrefDelimiter = '#';
    private String contextUri;
    private final String href;
    private boolean isLocal = false;

    public ConfigDataId(String string, String string2) {
        if (string == null) {
            string = " ";
        }
        this.contextUri = string;
        this.href = string2;
    }

    public ConfigDataId(String string) {
        int n = string.lastIndexOf(124);
        this.href = n == string.length() - 1 ? null : string.substring(n + 1);
        String string2 = n == -1 ? "" : string.substring(0, n);
        n = string2.lastIndexOf(124);
        this.contextUri = n == -1 ? string2 : string2.substring(n + 1);
        this.isLocal = n != -1 && string2.substring(0, n).equals("local");
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof ConfigDataId) {
            ConfigDataId configDataId = (ConfigDataId)object;
            bl = this.isLocal == configDataId.isLocal && this.equals(this.href, configDataId.href) && this.equals(this.contextUri, configDataId.contextUri);
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isResolved() {
        return this.isLocal() || this.href.indexOf(35) != -1;
    }

    public String getContextUri() {
        return this.contextUri;
    }

    public String getHref() {
        return this.href;
    }

    private boolean equals(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public String toString() {
        return (this.isLocal ? "local|" : "") + this.contextUri + '|' + (this.href == null ? "" : this.href);
    }

    public static synchronized ConfigDataId createLocalId() {
        String string = "local_reference_id_" + max_local_id++;
        ConfigDataId configDataId = new ConfigDataId(null, string);
        configDataId.isLocal = true;
        return configDataId;
    }

    public static synchronized ConfigDataId createLocalId(String string) {
        ConfigDataId configDataId = new ConfigDataId(null, string);
        configDataId.isLocal = true;
        return configDataId;
    }
}

