/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.repository;

import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.RepositoryInputStream;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;

public class DocumentContentSource
implements Serializable {
    private static final long serialVersionUID = -8662410128695608386L;
    private Document document;
    private InputStream source;
    private long lastModified = 0L;

    public DocumentContentSource(Document document, InputStream inputStream) {
        this.setDocument(document);
        if (inputStream != null) {
            this.setSource(inputStream);
        }
    }

    public DocumentContentSource(Document document, byte[] byArray) {
        this.setDocument(document);
        if (byArray != null) {
            this.setSource(byArray);
        }
    }

    public DocumentContentSource(Document document, File file) {
        this.setDocument(document);
        if (file != null) {
            this.setSource(file);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setSource(InputStream inputStream) {
        this.source = inputStream;
        this.lastModified = 0L;
    }

    public void setSource(byte[] byArray) {
        this.setSource(new ByteArrayInputStream(byArray));
    }

    public void setSource(File file) {
        try {
            this.setSource(new RepositoryInputStream(file));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.repository.DocumentContentSource.setSource", "116", this);
            this.source = null;
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l) {
        if (l >= 0L) {
            this.lastModified = l;
        }
    }
}

