/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bundle;

import com.ibm.ws.bundle.CacheEntry;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SimpleLRUCache {
    public static final int DEFAULT_MAX_CACHE_ENTRIES = 25;
    public static final int INFINITE_CACHE = -1;
    private HashMap cache = null;
    private int maxSize = 25;

    public SimpleLRUCache() {
        this.cache = new HashMap(25);
    }

    public SimpleLRUCache(int n) {
        this.cache = n == -1 ? new HashMap() : new HashMap(n);
        this.maxSize = n;
    }

    public void putEntry(String string, Object object) {
        long l = System.currentTimeMillis();
        if (this.maxSize != -1 && this.cache.size() == this.maxSize) {
            this.removeLeastRecentlyUsed();
        }
        this.cache.put(string, new CacheEntry(object, 1L, l));
    }

    public Object getEntry(String string) {
        CacheEntry cacheEntry = null;
        Object object = null;
        cacheEntry = (CacheEntry)this.cache.get(string);
        if (cacheEntry != null) {
            object = cacheEntry.getObject();
            cacheEntry.incrementAccess();
            cacheEntry.setLastAccessTime(System.currentTimeMillis());
        }
        return object;
    }

    public Object removeEntry(String string) {
        CacheEntry cacheEntry = null;
        Object object = null;
        cacheEntry = (CacheEntry)this.cache.remove(string);
        if (cacheEntry != null) {
            object = cacheEntry.getObject();
        }
        return object;
    }

    public int size() {
        return this.maxSize;
    }

    public int freeEntriesRemaining() {
        int n = this.maxSize - this.cache.size();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void resize(int n) {
        if (n > 0) {
            this.maxSize = n;
        } else if (n == -1) {
            this.maxSize = -1;
        }
    }

    public boolean containsEntry(String string) {
        return this.cache.containsKey(string);
    }

    public void printAccessInformation(PrintStream printStream) {
        Iterator iterator;
        Set set;
        if (this.cache != null && printStream != null && (set = this.cache.keySet()) != null && (iterator = set.iterator()) != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printStream.println("Key [" + string + "] has been accessed: [" + ((CacheEntry)this.cache.get(string)).getAccessTimes() + "] times.");
            }
        }
    }

    private CacheEntry removeLeastAccessed() {
        Set set = null;
        String string = null;
        long l = 0L;
        Object var5_4 = null;
        set = this.cache.keySet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry = null;
                String string2 = (String)iterator.next();
                if (string != null) {
                    cacheEntry = (CacheEntry)this.cache.get(string2);
                    if (cacheEntry.getAccessTimes() >= l) continue;
                    string = string2;
                    l = cacheEntry.getAccessTimes();
                    continue;
                }
                string = string2;
                cacheEntry = (CacheEntry)this.cache.get(string2);
                l = cacheEntry.getAccessTimes();
            }
        }
        return (CacheEntry)this.cache.remove(string);
    }

    private CacheEntry removeLeastRecentlyUsed() {
        Set set = null;
        String string = null;
        long l = 0L;
        Object var5_4 = null;
        set = this.cache.keySet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry = null;
                String string2 = (String)iterator.next();
                if (string != null) {
                    cacheEntry = (CacheEntry)this.cache.get(string2);
                    if (cacheEntry.getLastAccessTime() >= l) continue;
                    string = string2;
                    l = cacheEntry.getLastAccessTime();
                    continue;
                }
                string = string2;
                cacheEntry = (CacheEntry)this.cache.get(string2);
                l = cacheEntry.getLastAccessTime();
            }
        }
        return (CacheEntry)this.cache.remove(string);
    }

    public Enumeration getKeys() {
        Iterator iterator;
        Vector vector = new Vector();
        Set set = this.cache.keySet();
        if (set != null && (iterator = set.iterator()) != null) {
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        }
        return vector.elements();
    }
}

