/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.feedback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.RouterMediator;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.monitor.AdvisorFactory;
import com.ibm.wsspi.cluster.monitor.AdvisorMediator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ObservedWeightFeedback
implements WeightBasedFeedback {
    private static final TraceComponent tc = Tr.register(ObservedWeightFeedback.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private final AdvisorMediator mediator = AdvisorFactory.getAdvisorMediator();
    private Identity clusterIdentity;
    private SelectionAlgorithm selectionAlgorithm;
    private Map members = Collections.EMPTY_MAP;
    private volatile boolean execute = true;

    private int[] modifyWeights(MemberData[] memberDataArray) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyWeights", memberDataArray);
        }
        int n2 = memberDataArray.length;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = memberDataArray[n].observed;
            nArray2[n] = 5;
            if (nArray2[n] != 0) {
                ++n4;
            }
            n3 += nArray[n];
        }
        n = 0;
        n2 = n4;
        int n5 = 1;
        if (n3 > 0) {
            n5 = n3 / n2 + 1;
        }
        for (int i = 0; i < n2; ++i) {
            int n6 = nArray[i] = nArray2[i] == 0 ? 0 : n5 - nArray[i];
            if (nArray[i] == memberDataArray[i].last) continue;
            memberDataArray[i].last = nArray[i];
            n = 1;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("weights ");
            if (n != 0) {
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(5);
                    stringBuffer.append("->");
                    stringBuffer.append(nArray[i]);
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append("no change ");
            }
            stringBuffer.append(n3);
            Tr.exit(tc, "modifyWeights", stringBuffer);
        }
        return (int[])(n != 0 ? nArray : null);
    }

    public void init(Identity identity, SelectionAlgorithm selectionAlgorithm) {
        this.clusterIdentity = identity;
        this.selectionAlgorithm = selectionAlgorithm;
        this.applyStructuralUpdate(clusterService.getMemberIdentities(this.clusterIdentity));
        ((RouterMediator)this.mediator).registerFeedback(this, identity);
    }

    public void applyStructuralUpdate(Identity[] identityArray) {
        HashMap<Identity, MemberData> hashMap = new HashMap<Identity, MemberData>(identityArray.length * 2);
        for (int i = 0; i < identityArray.length; ++i) {
            MemberData memberData = (MemberData)this.members.get(identityArray[i]);
            if (memberData == null) {
                memberData = new MemberData(identityArray[i]);
            }
            hashMap.put(identityArray[i], memberData);
        }
        this.members = hashMap;
        this.execute(true);
    }

    public void applyWorkloadUpdate(Identity identity, int n) {
        MemberData memberData = (MemberData)this.members.get(identity);
        if (memberData != null) {
            memberData.observed = n;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    public void applyExceptionUpdate(Identity identity, int n) {
        MemberData memberData = (MemberData)this.members.get(identity);
        if (memberData != null) {
            memberData.exception += n;
        }
        if (this.execute) {
            this.execute = false;
            this.execute(false);
            this.execute = true;
        }
    }

    private void execute(boolean bl) {
        MemberData[] memberDataArray = new MemberData[this.members.size()];
        this.members.values().toArray(memberDataArray);
        int[] nArray = this.modifyWeights(memberDataArray);
        if (bl || nArray != null) {
            int n;
            Identity[] identityArray = new Identity[memberDataArray.length];
            for (n = 0; n < memberDataArray.length; ++n) {
                identityArray[n] = memberDataArray[n].memberIdentity;
            }
            if (nArray == null) {
                nArray = new int[identityArray.length];
                for (n = 0; n < memberDataArray.length; ++n) {
                    nArray[n] = 5;
                }
            }
            this.selectionAlgorithm.prepare(identityArray, nArray);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.6 ");
        }
    }

    private final class MemberData {
        private final Identity memberIdentity;
        private final int desired = 5;
        private int observed;
        private int exception;
        private int last;

        private MemberData(Identity identity) {
            this.memberIdentity = identity;
        }

        public String toString() {
            return "FeedbackData [" + this.memberIdentity + ':' + 5 + ':' + this.observed + ':' + this.exception + ':' + this.last + ']';
        }
    }
}

