/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.service.ClusterManagementImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.service.ServerClusterContextFactory;
import com.ibm.ws.cluster.service.ServerClusterContextImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.IdentityMapping;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.distribution.ClusterContextDistributor;
import com.ibm.wsspi.cluster.distribution.ServerClusterContext;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ClusterMemberServiceImpl
extends WsComponentImpl
implements ClusterMemberService {
    private static final TraceComponent tc = Tr.register(ClusterMemberServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private DescriptionManager ivDescMgr;
    private ServerClusterContext ivServerClusterContext;
    private Map activeClusterSet;
    private static final ClusterService clusterService;
    private DescriptionFactory descriptionFactory;
    private DescriptionKey identityMapKey;
    private IdentityMap identityMap;
    private Map ivDistributors;
    private String ivCellName;
    private String ivNodeName;
    private String ivProcessName;
    private ProcessDescription ivClusterMember;
    private Contract ivContract;
    private ClusterManagement ivClusterManagement;
    private ProcessProperties ivProcessProperties;
    private DescriptionKey containingClusterWeightTableKey;
    private Server server;
    static /* synthetic */ Class class$com$ibm$websphere$cluster$topography$ClusterDescription;

    public ClusterMemberServiceImpl() {
        DescriptionManagerFactory.getInstance();
        this.ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
        this.ivServerClusterContext = ServerClusterContextFactory.getServerClusterContextFactory().createServerClusterContext();
        this.activeClusterSet = Collections.synchronizedMap(new HashMap());
        this.descriptionFactory = DescriptionFactory.getInstance();
        this.ivDistributors = new HashMap();
        this.ivCellName = null;
        this.ivNodeName = null;
        this.ivProcessName = null;
        this.ivClusterMember = null;
        this.ivContract = null;
        this.ivClusterManagement = ClusterManagementFactory.getClusterManagement();
        this.ivProcessProperties = null;
        this.server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        this.ivContract = new ContractImpl();
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.ivContract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        try {
            this.server = (Server)WsServiceRegistry.getService(this, Server.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".initialize", "199");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.ivCellName = this.server.getCellName();
        this.ivNodeName = this.server.getNodeName();
        this.ivProcessName = this.server.getName();
        String string = this.server.getClusterName();
        this.identityMapKey = (DescriptionKey)IdentityMapping.getActiveClusterSetIdentityFromCellName(this.ivCellName);
        this.identityMap = this.getIdentityMap();
        DescriptionKey descriptionKey = (DescriptionKey)((ClusterManagementImpl)this.ivClusterManagement).createClusterMember(this.ivCellName, this.ivNodeName, null, this.ivProcessName);
        this.ivProcessProperties = ProcessProperties.getInstance();
        this.ivProcessProperties.put("key.local.member", descriptionKey);
        this.ivClusterMember = (ProcessDescription)this.ivDescMgr.getDescription(descriptionKey);
        this.containingClusterWeightTableKey = (DescriptionKey)this.ivProcessProperties.get("key.containing.cluster.weight.table");
        Map map = this.activeClusterSet;
        synchronized (map) {
            Integer n = (Integer)this.activeClusterSet.get(descriptionKey);
            n = new Integer(n == null ? 1 : n + 1);
            this.activeClusterSet.put(descriptionKey, n);
        }
        try {
            WsServiceRegistry.addService(this, ClusterMemberService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".initialize", "235");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.ivProcessProperties.put("key.clustermember.service", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        super.start();
        if (this.server.getServerMode() == 1) {
            this.ivClusterMember.setAvailability((byte)9);
        } else {
            this.ivClusterMember.setAvailability((byte)0);
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
        DescriptionKey descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(this.ivClusterMember.getKey(), treeMap);
        SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.ivDescMgr.getDescription(descriptionKey);
        selectionClusterMemberDescription.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public EndPoint defineLocalScopedData(Identity identity, byte[] byArray) {
        EndPointImpl endPointImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineLocalScopedData ", identity);
        }
        try {
            endPointImpl = (EndPointImpl)this.ivDescMgr.getDescription((DescriptionKey)identity, EndPoint.class.getName());
            endPointImpl.setlocal(true);
            endPointImpl.setData(byArray);
            this.ivClusterMember.setExtrinsicData(endPointImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.getClass().getName() + ".defineLocalScopedData", "341");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception ", exception);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An internal error occurred while trying to process the local data.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defineLocalScopedData", endPointImpl);
        }
        return endPointImpl;
    }

    public EndPoint defineMemberScopedData(Identity identity, byte[] byArray) {
        EndPoint endPoint;
        block2: {
            endPoint = null;
            try {
                endPoint = this.ivClusterManagement.defineMemberScopedData(this.ivClusterMember.getKey(), identity, byArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".defineMemberScopedData", "221");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        return endPoint;
    }

    public byte[] undefineMemberScopedData(EndPoint endPoint) {
        try {
            this.ivClusterManagement.undefineMemberScopedData(this.ivClusterMember.getKey(), endPoint);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".undefineMemberScopedData", "240");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", exception);
            }
            return null;
        }
        return endPoint.getData();
    }

    public byte[] undefineLocalScopedData(EndPoint endPoint) {
        DescriptionKey descriptionKey = (DescriptionKey)endPoint.getIdentity();
        this.ivClusterMember.removeExtrinsicData(descriptionKey);
        return endPoint.getData();
    }

    public void joinCluster(Identity identity) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "joinCluster", identity);
        }
        this.addToActiveClusterSet(identity);
        DescriptionKey descriptionKey = this.ivClusterMember.getKey();
        this.ivClusterManagement.joinCluster(identity, new Identity[]{descriptionKey});
        ((ServerClusterContextImpl)this.ivServerClusterContext).updateActiveClusterSet(this.activeClusterSet.keySet(), this.activeClusterSet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", this.activeClusterSet);
        }
    }

    public void disjoinCluster(Identity identity) throws NoClusterDefinedException {
        DescriptionKey descriptionKey;
        ClusterDescription clusterDescription;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disjoinCluster", identity);
        }
        if ((clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey = (DescriptionKey)identity)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
            }
            throw new NoClusterDefinedException();
        }
        this.removeFromActiveClusterSet(descriptionKey);
        this.ivClusterManagement.disjoinCluster(descriptionKey, new Identity[]{this.ivClusterMember.getKey()});
        ((ServerClusterContextImpl)this.ivServerClusterContext).updateActiveClusterSet(this.activeClusterSet.keySet(), this.activeClusterSet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", this.activeClusterSet);
        }
    }

    public ServerClusterContext getServerClusterContextListener() {
        return this.ivServerClusterContext;
    }

    public void registerDistributor(ClusterContextDistributor clusterContextDistributor, Identity identity) {
        this.ivDistributors.put(identity, clusterContextDistributor);
    }

    public void joinCluster(Identity[] identityArray) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "joinCluster", identityArray);
        }
        try {
            Identity identity = identityArray[0];
            this.addToActiveClusterSet(identity);
            Identity identity2 = null;
            for (int i = 1; i < identityArray.length; ++i) {
                identity2 = identityArray[i];
                this.ivDescMgr.getDescription((DescriptionKey)identity2, (class$com$ibm$websphere$cluster$topography$ClusterDescription == null ? ClusterMemberServiceImpl.class$("com.ibm.websphere.cluster.topography.ClusterDescription") : class$com$ibm$websphere$cluster$topography$ClusterDescription).getName());
                this.addToActiveClusterSet(identity2);
                this.ivClusterManagement.joinCluster(identity, new Identity[]{identity2});
                identity = identity2;
            }
            this.ivClusterManagement.joinCluster(identity, new Identity[]{this.ivClusterMember.getKey()});
            ((ServerClusterContextImpl)this.ivServerClusterContext).updateActiveClusterSet(this.activeClusterSet.keySet(), this.activeClusterSet);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".joinCluster", "325");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "joinCluster");
            }
            throw new NoClusterDefinedException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", this.activeClusterSet);
        }
    }

    public void disjoinCluster(Identity[] identityArray) throws NoClusterDefinedException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disjoinCluster", identityArray);
        }
        if ((n = identityArray.length) > 1) {
            DescriptionKey descriptionKey = (DescriptionKey)identityArray[n - 1];
            ClusterDescription clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey);
            if (clusterDescription == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
                }
                throw new NoClusterDefinedException();
            }
            ClusterDescription clusterDescription2 = clusterDescription;
            for (int i = n - 2; i >= 0; --i) {
                this.removeFromActiveClusterSet(identityArray[i]);
                DescriptionKey descriptionKey2 = (DescriptionKey)identityArray[i];
                clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey2);
                if (clusterDescription == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
                    }
                    throw new NoClusterDefinedException();
                }
                this.ivClusterManagement.disjoinCluster(descriptionKey2, new Identity[]{clusterDescription2.getKey()});
                clusterDescription2 = clusterDescription;
            }
            ((ServerClusterContextImpl)this.ivServerClusterContext).updateActiveClusterSet(this.activeClusterSet.keySet(), this.activeClusterSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", this.activeClusterSet);
        }
    }

    public void defineAttribute(String string) {
        this.ivClusterManagement.defineAttribute(this.ivClusterMember.getKey(), string);
    }

    public void undefineAttribute(String string) {
        this.ivClusterManagement.undefineAttribute(this.ivClusterMember.getKey(), string);
    }

    public Identity getIdentity() {
        return this.ivClusterMember.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToActiveClusterSet(Identity identity) {
        Map map = this.activeClusterSet;
        synchronized (map) {
            Integer n = (Integer)this.activeClusterSet.get(identity);
            n = new Integer(n == null ? 1 : n + 1);
            this.activeClusterSet.put(identity, n);
        }
        this.addToIdentityMap(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromActiveClusterSet(Identity identity) {
        boolean bl = false;
        Map map = this.activeClusterSet;
        synchronized (map) {
            Integer n = (Integer)this.activeClusterSet.get(identity);
            if (n != null) {
                int n2 = n - 1;
                if (n2 <= 0) {
                    this.activeClusterSet.remove(identity);
                    bl = true;
                } else {
                    this.activeClusterSet.put(identity, new Integer(n2));
                }
            }
        }
        if (bl) {
            this.removeFromIdentityMap(identity);
        }
    }

    private void addToIdentityMap(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToIdentityMap", identity);
        }
        this.identityMap.put(identity, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToIdentityMap", this.identityMap);
        }
    }

    private IdentityMap getIdentityMap() {
        IdentityMap identityMap;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getIdentityMap");
            }
            identityMap = null;
            try {
                identityMap = (IdentityMap)this.ivDescMgr.getDescription(this.identityMapKey, IdentityMap.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + "getIdentityMap", "623");
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentityMap", identityMap.toString());
        }
        return identityMap;
    }

    private void removeFromIdentityMap(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromIdentityMap", identity);
        }
        this.identityMap.remove(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromIdentityMap", this.identityMap);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.60 ");
        }
        clusterService = ClusterServiceFactory.getClusterService();
    }
}

