/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.service.ClientClusterContextImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.IdentityMapping;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import com.ibm.wsspi.cluster.distribution.ClientClusterContext;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterServiceImpl
implements ClusterService,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(ClusterServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map listeners = new HashMap();
    private Map coIdentifiers = Collections.synchronizedMap(new HashMap());
    private DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();

    public Identity getIdentity(Map map) throws IllegalArgumentException {
        return this.keyRepository.getDescriptionKey(map);
    }

    public byte[] getClusterScopedData(Identity identity, Identity identity2) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterScopedData", new Object[]{identity, identity2});
        }
        byte[] byArray = null;
        DescriptionKey descriptionKey = (DescriptionKey)identity;
        DescriptionKey descriptionKey2 = (DescriptionKey)identity2;
        ClusterDescription clusterDescription = null;
        try {
            clusterDescription = (ClusterDescription)this.descMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
            byArray = memento.getClusterScopedData(descriptionKey2);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + ".getClusterScopedData", "174");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterScopedData");
            }
            throw new NoClusterDefinedException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterScopedData", byArray);
        }
        return byArray;
    }

    public byte[] getMemberScopedData(Identity identity, Identity identity2) throws NoMemberAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberScopedData", new Object[]{identity, identity2});
        }
        byte[] byArray = null;
        DescriptionKey descriptionKey = (DescriptionKey)identity;
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription(descriptionKey);
        if (clusterMemberDescription == null) {
            throw new NoMemberAvailableException();
        }
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        EndPointImpl endPointImpl = (EndPointImpl)memento.getExtrinsicData((DescriptionKey)identity2);
        if (endPointImpl != null) {
            byArray = endPointImpl.getData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberScopedData", byArray);
        }
        return byArray;
    }

    public ClientClusterContext getClientClusterContextListener(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientClusterContext", list);
        }
        ClientClusterContext clientClusterContext = null;
        SoftReference softReference = (SoftReference)this.listeners.get(list);
        if (softReference != null && (clientClusterContext = (ClientClusterContext)softReference.get()) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientClusterContext", clientClusterContext);
            }
            return clientClusterContext;
        }
        clientClusterContext = new ClientClusterContextImpl(list);
        this.listeners.put(list, new SoftReference<ClientClusterContext>(clientClusterContext));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientClusterContext", clientClusterContext);
        }
        return clientClusterContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterest(ClusterObserver clusterObserver, Identity identity, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerInterest", new Object[]{clusterObserver, identity, string});
            }
            object4 = identity;
            try {
                if (string.equals("cluster.active")) {
                    object3 = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identity, IdentityMap.class.getName());
                    object3.registerNotificationListener(this, "type.key.added", "cluster.active");
                } else if (string.equals("cluster.deactive")) {
                    object3 = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identity, IdentityMap.class.getName());
                    object3.registerNotificationListener(this, "type.key.removed", "cluster.deactive");
                } else if (string.equals("type.endpoint.added")) {
                    object3 = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity, ClusterMemberDescription.class.getName());
                    object3.registerNotificationListener(this, "type.add.extrinsic", "type.endpoint.added");
                } else if (string.equals("type.endpoint.removed")) {
                    object3 = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity, ClusterMemberDescription.class.getName());
                    object3.registerNotificationListener(this, "type.remove.extrinsic", "type.endpoint.removed");
                } else if (string.equals("type.attribute.added")) {
                    object3 = new HashMap(identity.getProperties());
                    object3.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    object2 = this.getIdentity((Map)object3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", object2);
                    }
                    object = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)object2, SelectionClusterMemberDescription.class.getName());
                    object.registerNotificationListener(this, "type.attribute.added", "type.attribute.added");
                    object4 = object2;
                } else if (string.equals("type.attribute.removed")) {
                    object3 = new HashMap<String, String>(identity.getProperties());
                    object3.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    object2 = this.getIdentity((Map)object3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", object2);
                    }
                    object = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)object2, SelectionClusterMemberDescription.class.getName());
                    object.registerNotificationListener(this, "type.attribute.removed", "type.attribute.removed");
                    object4 = object2;
                } else {
                    object3 = (ClusterDescription)this.descMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
                    object3.registerNotificationListener(this, string, string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + ".registerInterest", "301");
                if (!tc.isDebugEnabled()) break block23;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        object3 = (Map)this.coIdentifiers.get(object4);
        if (object3 == null) {
            object3 = new HashMap();
            this.coIdentifiers.put(object4, object3);
        }
        if ((object2 = (HashSet)object3.get(string)) == null) {
            object2 = new HashSet();
            object3.put(string, object2);
        }
        object = object2;
        synchronized (object) {
            object2.add(new WeakReference<ClusterObserver>(clusterObserver));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerInterest");
        }
    }

    public Identity[] getMemberIdentities(Identity identity) {
        ClusterDescription clusterDescription;
        Identity[] identityArray;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMemberIdentities", identity);
            }
            identityArray = null;
            DescriptionKey descriptionKey = (DescriptionKey)identity;
            clusterDescription = null;
            try {
                clusterDescription = (ClusterDescription)this.descMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + ".getMemberIdentities", "346");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        if (clusterDescription != null) {
            Set set = ((ClusterDescription.Memento)clusterDescription.getMemento()).getMembers().keySet();
            identityArray = new Identity[set.size()];
            set.toArray(identityArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberIdentities", identityArray);
        }
        return identityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
        }
        if (object instanceof Description) {
            object = ((Description)object).getKey();
        }
        if ((string.equals("type.key.added") || string.equals("type.key.removed") || string.equals("type.value.modified") || string.equals("type.add.extrinsic") || string.equals("type.remove.extrinsic")) && object2 != null && object2 instanceof String) {
            if (object instanceof EndPoint) {
                object = ((EndPoint)object).getIdentity();
            }
            string = (String)object2;
        } else if ((string.equals("type.attribute.added") || string.equals("type.attribute.removed")) && object2 != null && object2 instanceof String) {
            string = (String)object2;
        }
        Map map = (Map)this.coIdentifiers.get(descriptionKey);
        if (map != null) {
            HashSet hashSet = (HashSet)map.get(string);
            if (hashSet != null) {
                HashSet hashSet2;
                Object object3 = hashSet;
                synchronized (object3) {
                    hashSet2 = (HashSet)hashSet.clone();
                }
                object3 = hashSet2.iterator();
                while (object3.hasNext()) {
                    ClusterObserver clusterObserver;
                    WeakReference weakReference = (WeakReference)object3.next();
                    ClusterObserver clusterObserver2 = clusterObserver = weakReference == null ? null : (ClusterObserver)weakReference.get();
                    if (clusterObserver != null) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Cluster Service, notify observer", clusterObserver);
                        }
                        clusterObserver.notify(descriptionKey, string, object);
                        continue;
                    }
                    hashSet.remove(weakReference);
                }
                if (hashSet.isEmpty()) {
                    map.remove(string);
                }
            }
            if (map.isEmpty()) {
                this.coIdentifiers.remove(descriptionKey);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public EndPoint[] matchEndPoints(Identity identity, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", new Object[]{identity, map});
        }
        EndPoint[] endPointArray = null;
        IntrinsicDescription intrinsicDescription = (IntrinsicDescription)this.descMgr.getDescription((DescriptionKey)identity);
        if (intrinsicDescription == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "matchEndPoints - no intrinsic description for passed Identity");
            }
            return new EndPoint[0];
        }
        IntrinsicDescription.Memento memento = (IntrinsicDescription.Memento)intrinsicDescription.getMemento();
        Map map2 = memento.getExtrinsicData();
        endPointArray = this.matchEndPoints(map2, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints");
        }
        return endPointArray;
    }

    public EndPoint[] matchEndPoints(Map map, Map map2) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", new Object[]{map2});
        }
        if (map == null) {
            throw new IllegalArgumentException("The endPoints argument must not be null.");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("The propertyNames argument must not be null.");
        }
        EndPoint[] endPointArray = new EndPoint[]{};
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            EndPoint[] endPointArray2;
            Iterator iterator2 = map2.entrySet().iterator();
            Object v = iterator.next();
            if (!(v instanceof EndPoint)) continue;
            EndPoint endPoint = (EndPoint)v;
            Identity identity = endPoint.getIdentity();
            Map map3 = identity.getProperties();
            while (iterator2.hasNext()) {
                endPointArray2 = iterator2.next();
                try {
                    if (!map3.containsKey(endPointArray2.getKey()) || endPointArray2.getValue() != null && !((String)map3.get(endPointArray2.getKey())).startsWith((String)endPointArray2.getValue())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting next to null", endPoint);
                        }
                        endPoint = null;
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "found a match: " + endPointArray2.getKey() + " " + endPointArray2.getValue());
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("The property value " + endPointArray2.getValue().toString() + " should be a String type.");
                }
            }
            if (endPoint == null) continue;
            endPointArray2 = new EndPoint[endPointArray.length + 1];
            endPointArray2[endPointArray.length] = endPoint;
            System.arraycopy(endPointArray, 0, endPointArray2, 0, endPointArray.length);
            endPointArray = endPointArray2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints", endPointArray);
        }
        return endPointArray;
    }

    public String identityToString(Identity identity) {
        return this.descMgr.keyToString((DescriptionKey)identity);
    }

    public Identity stringToIdentity(String string) {
        return this.descMgr.stringToKey(string);
    }

    public Set getActiveClusterSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveClusterSet");
        }
        Set set = null;
        String string = (String)ProcessProperties.getInstance().get("key.containing.cellname");
        DescriptionKey descriptionKey = (DescriptionKey)IdentityMapping.getActiveClusterSetIdentityFromCellName(string == null ? "" : string);
        IdentityMap identityMap = this.getIdentityMap(descriptionKey);
        set = identityMap.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveClusterSet", set);
        }
        return set;
    }

    IdentityMap getIdentityMap(DescriptionKey descriptionKey) {
        IdentityMap identityMap;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getIdentityMap");
            }
            identityMap = null;
            try {
                identityMap = (IdentityMap)this.descMgr.getDescription(descriptionKey, IdentityMap.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + "getIdentityMap", "623");
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentityMap", identityMap.toString());
        }
        return identityMap;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.35.1.1 ");
        }
    }
}

