/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.ClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.SelectionDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClusterDescriptionImpl
extends ClusterMemberDescriptionImpl
implements ClusterDescription,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(ClusterDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private final long TIMESTAMPADD = 1L;
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final DescriptionFactory ivDescriptionFactory = DescriptionFactory.getInstance();
    private static final DescriptionManager ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
    public static final SelectionDescription WEIGHTED;
    public static final SelectionDescription WEIGHTED_PREFER_LOCAL;
    public static final SelectionDescription WEIGHTED_NOT_INITIALIZED;
    private static final Map weightTableDistinction;
    protected long structuralEpoch = -2L;
    protected long influentialEpoch = -2L;
    private Map ivClusterScopedData = new HashMap();
    private Map ivWeightTable;
    private final DescriptionKey ivOwnedWeightTableKey;
    private DescriptionKey ivManagingWeightTableKey;
    protected SelectionDescription selection;
    private ClusterDescription backupCluster;
    private Contract contract = null;
    protected Map ivMembers = new HashMap();
    protected Map ivQuiesceState = Collections.synchronizedMap(new HashMap(1));
    static /* synthetic */ Class class$com$ibm$ws$cluster$topography$ClusterDescriptionImpl$MementoImpl;

    public ClusterDescriptionImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
        this.leaf = false;
        this.selection = WEIGHTED_NOT_INITIALIZED;
        this.contract = new ContractImpl();
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.contract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        this.ivOwnedWeightTableKey = ClusterDescriptionImpl.getWeightTableKey(descriptionKey);
        this.ivManagingWeightTableKey = (DescriptionKey)ProcessProperties.getInstance().get("key.containing.cluster.weight.table");
        if (this.ivManagingWeightTableKey == null) {
            this.ivManagingWeightTableKey = this.ivOwnedWeightTableKey;
        }
        this.assignWeightTable(this.ivManagingWeightTableKey);
    }

    public String getDefinitionKey() {
        return ClusterDescription.class.getName();
    }

    public synchronized void setStructuralEpoch(long l) {
        this.structuralEpoch = l;
        this.updateMemento();
    }

    public void setClusterScopedData(DescriptionKey descriptionKey, byte[] byArray) {
        this.ivClusterScopedData.put(descriptionKey, byArray);
        this.updateMemento();
    }

    public void setClusterWeightTable(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterWeightTable", map);
        }
        if (this.ivOwnedWeightTableKey != this.ivManagingWeightTableKey) {
            Map map2 = this.ivWeightTable;
            this.assignWeightTable(this.ivOwnedWeightTableKey);
            this.ivWeightTable.putAll(map2);
        }
        this.ivWeightTable.putAll(map);
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterWeightTable", this.ivWeightTable);
        }
    }

    public void setClusterWeightTableEntry(DescriptionKey descriptionKey, Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterWeightTableEntry", new Object[]{descriptionKey, n});
        }
        if (this.ivOwnedWeightTableKey != this.ivManagingWeightTableKey) {
            Map map = this.ivWeightTable;
            this.assignWeightTable(this.ivOwnedWeightTableKey);
            this.ivWeightTable.putAll(map);
        }
        this.ivWeightTable.put(descriptionKey, n);
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterWeightTableEntry", this.ivWeightTable);
        }
    }

    public void setClusterIdentityForWeightTable(Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("The managing cluster Identity can not be null.");
        }
        ClusterDescriptionImpl clusterDescriptionImpl = (ClusterDescriptionImpl)ivDescMgr.getDescription((DescriptionKey)identity);
        if (clusterDescriptionImpl == null) {
            throw new IllegalStateException("The managing cluster must be fluffed up before setting it as parent.");
        }
        if (clusterDescriptionImpl.ivManagingWeightTableKey == this.ivManagingWeightTableKey) {
            return;
        }
        Map map = (Map)((Object)ivDescMgr.getDescription(clusterDescriptionImpl.ivManagingWeightTableKey));
        if (map == null) {
            throw new IllegalStateException("The managing cluster weight table has not been fluffed up.");
        }
        MementoImpl mementoImpl = (MementoImpl)this.getMemento();
        Set set = mementoImpl.m_members.keySet();
        Set set2 = map.keySet();
        if (!set2.containsAll(set)) {
            throw new IllegalArgumentException("The new weight table does not contain weights for all members.\n" + set2 + '\n' + set);
        }
        this.ivManagingWeightTableKey = (DescriptionKey)identity;
        this.assignWeightTable(clusterDescriptionImpl.ivManagingWeightTableKey);
        this.updateMemento();
    }

    public void removeClusterScopedData(DescriptionKey descriptionKey) {
        this.ivClusterScopedData.remove(descriptionKey);
        this.updateMemento();
    }

    public synchronized void setInfluentialEpoch(long l) {
        this.influentialEpoch = l;
        this.updateMemento();
    }

    public synchronized void addMember(ClusterMemberDescription clusterMemberDescription) {
        if (!this.ivMembers.containsKey(clusterMemberDescription.getKey())) {
            this.ivMembers.put(clusterMemberDescription.getKey(), clusterMemberDescription);
            this.updateMemento();
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "memberAdded", new Object[]{clusterMemberDescription.getKey(), this.ivMembers});
        }
    }

    public synchronized void removeMember(ClusterMemberDescription clusterMemberDescription) {
        Object v = this.ivMembers.remove(clusterMemberDescription.getKey());
        if (this.ivOwnedWeightTableKey == this.ivManagingWeightTableKey) {
            this.ivWeightTable.remove(clusterMemberDescription.getKey());
        }
        if (v != null) {
            this.updateMemento();
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "memberRemoved", new Object[]{clusterMemberDescription.getKey(), this.ivMembers});
        }
    }

    public synchronized void setSelectionDescription(SelectionDescription selectionDescription) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSelectionDescription ", new Object[]{selectionDescription});
        }
        if (selectionDescription == null) {
            throw new NullPointerException("Must not set selection null.");
        }
        this.selection = selectionDescription;
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSelectionDescription ");
        }
    }

    public synchronized void setBackupCluster(ClusterDescription clusterDescription) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBackupCluster", clusterDescription);
        }
        this.backupCluster = clusterDescription;
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBackupCluster");
        }
    }

    public synchronized void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream " + this.getKey(), format);
        }
        int n = 1;
        dataOutput.writeByte(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version " + n);
        }
        super.exportToStream(dataOutput, format);
        int n2 = format.getType();
        ClusterDescription.Memento memento = null;
        if (n2 == 3) {
            memento = (ClusterDescription.Memento)this.getMemento();
        }
        Set set = null;
        int n3 = 0;
        if (format.getType() == 3) {
            set = memento.getClusterScopedData();
            n3 = set.size();
        } else {
            set = ((HashMap)((HashMap)this.ivClusterScopedData).clone()).entrySet();
            n3 = this.ivClusterScopedData.size();
        }
        dataOutput.writeInt(n3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote cluster scoped data map size = " + n3);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            object2 = (DescriptionKey)entry.getKey();
            keyRepository.exportToStream(dataOutput, (DescriptionKey)object2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote data key " + object2);
            }
            byte[] byArray = (byte[])entry.getValue();
            dataOutput.writeInt(byArray.length);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote data length " + byArray.length);
            }
            dataOutput.write(byArray, 0, byArray.length);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "wrote cluster scoped data", byArray);
        }
        int n4 = 0;
        if (format.getType() == 3) {
            set = memento.getMemberEntrySet();
            n4 = set.size();
        } else {
            set = this.ivMembers.entrySet();
            n4 = this.ivMembers.size();
        }
        dataOutput.writeInt(n4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote length " + n4);
        }
        object2 = set.iterator();
        for (int i = 0; i < n4; ++i) {
            Map.Entry entry = (Map.Entry)object2.next();
            DescriptionKey descriptionKey = (DescriptionKey)entry.getKey();
            Description description = (Description)entry.getValue();
            object = description.getDefinitionKey();
            dataOutput.writeUTF((String)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote member impl key " + (String)object);
            }
            keyRepository.exportToStream(dataOutput, descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote member description key " + descriptionKey);
            }
            Integer n5 = null;
            n5 = format.getType() != 3 ? (Integer)this.ivWeightTable.get(descriptionKey) : (Integer)memento.getWeightTable().get(descriptionKey);
            if (n5 == null) {
                n5 = new Integer(-1);
            }
            dataOutput.writeInt(n5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote member weight", String.valueOf(n5));
            }
            if (format.getType() != 3) continue;
            description.exportToStream(dataOutput, format);
        }
        if (format.getType() != 3) {
            dataOutput.writeInt(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote weight table size 0");
            }
        }
        long l = 0L;
        long l2 = 0L;
        if (format.getType() == 3) {
            l = memento.getStructuralEpoch();
            l2 = memento.getInfluentialEpoch();
        } else {
            object = (ClusterDescription.Memento)this.getMemento();
            long l3 = object.getStructuralEpoch();
            long l4 = object.getInfluentialEpoch();
            l = this.structuralEpoch = System.currentTimeMillis();
            l2 = this.influentialEpoch = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current time stamps ie: " + l2 + " se: " + l);
            }
            if (l <= l3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "current time stamp <= memento's struct epoch: " + l3);
                }
                l = this.structuralEpoch = l3 + 1L;
            }
            if (l2 <= l4) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "current time stamp <= memento's influential epoch: " + l4);
                }
                l2 = this.influentialEpoch = l4 + 1L;
            }
        }
        dataOutput.writeLong(l);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote structualEpoch " + l);
        }
        dataOutput.writeLong(l2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote influentialEpoch " + l2);
        }
        object = null;
        SelectionDescription selectionDescription = null;
        ClusterDescription clusterDescription = null;
        if (format.getType() == 3) {
            selectionDescription = memento.getSelectionDescription();
            object = selectionDescription.getKey();
            keyRepository.exportToStream(dataOutput, (DescriptionKey)object);
            selectionDescription.exportToStream(dataOutput, format);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote selection descriptionKey " + object);
            }
            clusterDescription = memento.getBackupCluster();
        } else {
            selectionDescription = this.selection;
            object = this.selection.getKey();
            keyRepository.exportToStream(dataOutput, (DescriptionKey)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote selection descriptionKey " + object);
            }
            clusterDescription = this.backupCluster;
        }
        if (clusterDescription == null) {
            dataOutput.writeBoolean(false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "boolean backup cluster cell name available false");
            }
        } else {
            dataOutput.writeBoolean(true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "boolean backup cluster data available true");
            }
            keyRepository.exportToStream(dataOutput, clusterDescription.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote backup cluster's data " + clusterDescription.getKey());
            }
        }
        if (format.getVersion() >= 1) {
            if (format.getType() == 4) {
                keyRepository.exportToStream(dataOutput, this.ivManagingWeightTableKey);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote weight table key " + this.ivManagingWeightTableKey);
                }
            }
            if (format.getType() == 4 || format.getType() == 3) {
                Map map = format.getType() == 4 ? this.ivQuiesceState : memento.getQuiesceState();
                dataOutput.writeInt(map.size());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote stateMap size " + map.size());
                }
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    DescriptionKey descriptionKey = (DescriptionKey)entry.getKey();
                    keyRepository.exportToStream(dataOutput, descriptionKey);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "wrote memberKey " + descriptionKey);
                    }
                    byte by = (Byte)entry.getValue();
                    dataOutput.writeByte(by);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "wrote state " + by);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public synchronized Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream", format);
        }
        MementoImpl mementoImpl = (MementoImpl)memento;
        try {
            long l;
            Object object;
            Object object2;
            int n;
            Object object3;
            int n2;
            if (mementoImpl == null) {
                mementoImpl = (MementoImpl)this.createMemento();
            }
            byte by = dataInput.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read version " + by);
            }
            super.importFromStream(dataInput, format, mementoImpl);
            int n3 = dataInput.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read cluster scoped data map size = " + n3);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                DescriptionKey descriptionKey = null;
                descriptionKey = keyRepository.importFromStream(dataInput);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read dataKey " + descriptionKey);
                }
                int n4 = dataInput.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read data length " + n4);
                }
                object3 = new byte[n4];
                dataInput.readFully((byte[])object3, 0, ((byte[])object3).length);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read cluster scoped data", object3);
                }
                mementoImpl.m_clusterScopedData.put(descriptionKey, object3);
            }
            n2 = dataInput.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read member length " + n2);
            }
            for (n = 0; n < n2; ++n) {
                String string = dataInput.readUTF();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read member impl key " + string);
                }
                object3 = keyRepository.importFromStream(dataInput);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read description key " + object3);
                }
                object2 = ivDescMgr.getDescription((DescriptionKey)object3, string);
                mementoImpl.m_members.put(object3, object2);
                int n5 = -1;
                n5 = dataInput.readInt();
                if (format.getType() != 3) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read member weight " + n5);
                }
                if (n5 != -1) {
                    mementoImpl.m_weightTable.put(object3, new Integer(n5));
                }
                object = (ClusterMemberDescription.Memento)object2.importFromStream(dataInput, format, null);
                object2.setMemento((Description.Memento)object);
            }
            n = -1;
            if (format.getType() != 3) {
                n2 = dataInput.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read weight table size " + n2);
                }
                for (int i = 0; i < n2; ++i) {
                    object3 = keyRepository.importFromStream(dataInput);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read member key", object3);
                    }
                    n = dataInput.readInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read member weight " + n);
                    }
                    if (n == -1) continue;
                    mementoImpl.m_weightTable.put(object3, new Integer(n));
                }
            }
            if ((l = dataInput.readLong()) > mementoImpl.m_epoch) {
                mementoImpl.m_epoch = l;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read structuralEpoch " + l);
            }
            if ((l = dataInput.readLong()) > mementoImpl.m_influentialEpoch) {
                mementoImpl.m_influentialEpoch = l;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read influentialEpoch " + l);
            }
            object2 = keyRepository.importFromStream(dataInput);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read selection description key " + object2);
            }
            SelectionDescription selectionDescription = null;
            if (object2 != SelectionDescription.KEY_WEIGHTED_NOT_INITIALIZED) {
                selectionDescription = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription((DescriptionKey)object2, SelectionDescription.class.getName());
                mementoImpl.m_selection = selectionDescription;
            } else {
                selectionDescription = memento != null ? ((ClusterDescription.Memento)memento).getSelectionDescription() : WEIGHTED_NOT_INITIALIZED;
                mementoImpl.m_selection = selectionDescription;
            }
            if (selectionDescription != null && format.getType() == 3) {
                object = (SelectionDescription.Memento)selectionDescription.importFromStream(dataInput, format, null);
                selectionDescription.setMemento((Description.Memento)object);
            }
            if (dataInput.readBoolean()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "backup cluster data available true");
                }
                object = keyRepository.importFromStream(dataInput);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read backup cluster key " + object);
                }
                mementoImpl.m_backupCluster = (ClusterDescription)ClusterDescriptionImpl.ivDescMgr.getDescription((DescriptionKey)object, ClusterDescription.class.getName());
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "backup cluster data available false");
            }
            if (by >= 1) {
                if (format.getType() == 4) {
                    object = keyRepository.importFromStream(dataInput);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read weight table key " + object);
                    }
                    mementoImpl.m_disembodiedWeightTable = (IdentityMap)ClusterDescriptionImpl.ivDescMgr.getDescription((DescriptionKey)object, IdentityMap.class.getName());
                }
                if (format.getType() == 4 || format.getType() == 3 && format.getVersion() >= 1) {
                    int n6 = dataInput.readInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read stateMap size " + n6);
                    }
                    for (int i = 0; i < n6; ++i) {
                        DescriptionKey descriptionKey = keyRepository.importFromStream(dataInput);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "read memberKey " + descriptionKey);
                        }
                        byte by2 = dataInput.readByte();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "read state " + by2);
                        }
                        mementoImpl.m_quiesceState.put(descriptionKey, new Byte(by2));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not going to the Bulletin Board");
                }
            }
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", exception);
            }
            IOException iOException = new IOException("An unexpected exception occurred while processing the import from stream.");
            iOException.initCause(exception);
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoImpl;
    }

    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        DescriptionKey descriptionKey2 = (DescriptionKey)object;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
        }
        if (((ClusterDescription.Memento)this.getMemento()).getMembers().containsKey(descriptionKey2)) {
            ivDescriptionFactory.notifyListeners(this.getKey(), (String)object2, object);
            this.notifyListeners((String)object2, object);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Non-member of this cluster, no need to send notifications ");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[").append(super.toString());
        stringBuffer.append(" se:").append(this.structuralEpoch);
        stringBuffer.append(" ie:").append(this.influentialEpoch);
        stringBuffer.append(" members ").append(this.ivMembers == null ? null : this.ivMembers.keySet());
        stringBuffer.append(" cluster data ").append(this.ivClusterScopedData);
        stringBuffer.append(" backup cluster ").append(this.backupCluster == null ? null : this.backupCluster.getKey());
        stringBuffer.append(" quiesce state ").append(this.ivQuiesceState);
        stringBuffer.append(" weight table [").append(this.ivManagingWeightTableKey).append(' ').append(this.ivWeightTable).append(']');
        return stringBuffer.append(']').toString();
    }

    public void setMemento(Description.Memento memento) {
        Object k;
        Map.Entry entry;
        Object object;
        Map.Entry entry2;
        ClusterDescription.Memento memento2 = (ClusterDescription.Memento)this.getMemento();
        ClusterDescription.Memento memento3 = (ClusterDescription.Memento)memento;
        Map map = memento2.getMembers();
        Map map2 = memento3.getMembers();
        Set set = memento2.getClusterScopedData();
        Set set2 = memento3.getClusterScopedData();
        super.setMemento(memento);
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            entry2 = object2.next();
            if (map2.containsKey(entry2.getKey())) continue;
            object = entry2.getValue();
            this.notifyListeners("member.removed", object);
            ivDescriptionFactory.notifyListeners(this.getKey(), "member.removed", object);
        }
        object2 = map2.entrySet().iterator();
        while (object2.hasNext()) {
            entry2 = object2.next();
            object = entry2.getValue();
            if (map.containsKey(entry2.getKey())) continue;
            this.notifyListeners("member.added", object);
            ivDescriptionFactory.notifyListeners(this.getKey(), "member.added", object);
        }
        if (!memento3.getSelectionDescription().equals(memento2.getSelectionDescription())) {
            this.notifyListeners("type.selection.description.modified", null);
        }
        object2 = (MementoImpl)memento3;
        entry2 = (MementoImpl)memento2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registering with map for weight updates.", ((MementoImpl)object2).m_disembodiedWeightTable);
        }
        ((MementoImpl)object2).m_disembodiedWeightTable.registerNotificationListener(this, "type.key.added", "type.cluster.weight.update");
        ((MementoImpl)object2).m_disembodiedWeightTable.registerNotificationListener(this, "type.key.removed", "type.cluster.weight.update");
        ((MementoImpl)object2).m_disembodiedWeightTable.registerNotificationListener(this, "type.value.modified", "type.cluster.weight.update");
        if (((MementoImpl)((Object)entry2)).m_disembodiedWeightTable != ((MementoImpl)object2).m_disembodiedWeightTable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deregistering with map for weight updates.", ((MementoImpl)((Object)entry2)).m_disembodiedWeightTable);
            }
            ((MementoImpl)((Object)entry2)).m_disembodiedWeightTable.deregisterNotificationListener(this, "type.key.added");
            ((MementoImpl)((Object)entry2)).m_disembodiedWeightTable.deregisterNotificationListener(this, "type.key.removed");
            ((MementoImpl)((Object)entry2)).m_disembodiedWeightTable.deregisterNotificationListener(this, "type.value.modified");
        }
        object = set.iterator();
        while (object.hasNext()) {
            entry = (Map.Entry)object.next();
            k = entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMemento Cluster Scoped Data undefine: obj:" + k.toString());
            }
            if (set2.contains(k)) continue;
            this.notifyListeners("type.cluster.scoped.data.removed", k);
            ivDescriptionFactory.notifyListeners(this.getKey(), "type.cluster.scoped.data.removed", k);
        }
        object = set2.iterator();
        while (object.hasNext()) {
            entry = (Map.Entry)object.next();
            k = entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMemento Cluster Scoped Data define: obj:" + k.toString());
            }
            if (set.contains(k)) continue;
            this.notifyListeners("type.cluster.scoped.data.added", k);
            ivDescriptionFactory.notifyListeners(this.getKey(), "type.cluster.scoped.data.added", k);
        }
        if (!((Object)((MementoImpl)object2).m_quiesceState).equals(((MementoImpl)((Object)entry2)).m_quiesceState)) {
            this.notifyListeners("type.quiesce.state.changed", ((MementoImpl)object2).getQuiesceState());
        }
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setQuiesce(Identity identity) {
        this.ivQuiesceState.put(identity, new Byte(9));
        this.updateMemento();
    }

    public void unsetQuiesce(Identity identity) {
        this.ivQuiesceState.remove(identity);
        this.updateMemento();
    }

    public static DescriptionKey getWeightTableKey(DescriptionKey descriptionKey) {
        return keyRepository.getDescriptionKey(descriptionKey, weightTableDistinction);
    }

    private void assignWeightTable(DescriptionKey descriptionKey) {
        block4: {
            try {
                this.ivWeightTable = (Map)((Object)ivDescMgr.getDescription(descriptionKey, IdentityMap.class.getName()));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Changed over to new weight table.", new Object[]{this.ivManagingWeightTableKey, descriptionKey});
                }
                this.ivManagingWeightTableKey = descriptionKey;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterDescriptionImpl.class.getName() + ".assignWeightTable", "1012", this, new Object[]{descriptionKey});
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "unexpected exception", exception);
                }
                if (this.ivWeightTable != null) break block4;
                this.ivWeightTable = Collections.synchronizedMap(new HashMap());
            }
        }
    }

    static {
        weightTableDistinction = new HashMap();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.68 ");
        }
        weightTableDistinction.put("Type", "WeightTable");
        SelectionDescription selectionDescription = null;
        SelectionDescription selectionDescription2 = null;
        SelectionDescription selectionDescription3 = null;
        try {
            selectionDescription = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED, SelectionDescription.class.getName());
            selectionDescription.modifyRules(new String[]{"rule.local.server", "rule.default"});
            selectionDescription2 = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED_PREFER_LOCAL, SelectionDescription.class.getName());
            selectionDescription2.modifyRules(new String[]{"rule.local.server", "rule.local.host", "rule.default"});
            selectionDescription3 = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED_NOT_INITIALIZED, SelectionDescription.class.getName());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, SelectionDescriptionImpl.class.getName() + "<clinit>", "125");
        }
        WEIGHTED = selectionDescription;
        WEIGHTED_PREFER_LOCAL = selectionDescription2;
        WEIGHTED_NOT_INITIALIZED = selectionDescription3;
    }

    public class MementoImpl
    extends ClusterMemberDescriptionImpl.MementoImpl
    implements ClusterDescription.Memento {
        private long m_epoch;
        private long m_influentialEpoch;
        private Map m_members;
        private SelectionDescription m_selection;
        private Map m_clusterScopedData;
        private ClusterDescription m_backupCluster;
        private Map m_weightTable;
        private IdentityMap m_disembodiedWeightTable;
        private Map m_quiesceState;

        protected MementoImpl() {
            block3: {
                super(ClusterDescriptionImpl.this);
                this.m_epoch = -2L;
                this.m_influentialEpoch = -2L;
                this.m_members = new HashMap(4);
                this.m_clusterScopedData = new HashMap(3);
                this.m_backupCluster = null;
                this.m_weightTable = new HashMap(4);
                this.m_quiesceState = new HashMap(1);
                try {
                    this.m_selection = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED_NOT_INITIALIZED, (class$com$ibm$websphere$cluster$topography$SelectionDescription == null ? (class$com$ibm$websphere$cluster$topography$SelectionDescription = ClusterDescriptionImpl.class$("com.ibm.websphere.cluster.topography.SelectionDescription")) : class$com$ibm$websphere$cluster$topography$SelectionDescription).getName());
                    DescriptionKey descriptionKey = (DescriptionKey)ProcessProperties.getInstance().get("key.containing.cluster.weight.table");
                    if (descriptionKey == null) {
                        descriptionKey = ClusterDescriptionImpl.getWeightTableKey(ClusterDescriptionImpl.this.getKey());
                    }
                    this.m_disembodiedWeightTable = (IdentityMap)ivDescMgr.getDescription(descriptionKey, (class$com$ibm$websphere$cluster$topography$IdentityMap == null ? (class$com$ibm$websphere$cluster$topography$IdentityMap = ClusterDescriptionImpl.class$("com.ibm.websphere.cluster.topography.IdentityMap")) : class$com$ibm$websphere$cluster$topography$IdentityMap).getName());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (class$com$ibm$ws$cluster$topography$ClusterDescriptionImpl$MementoImpl == null ? (class$com$ibm$ws$cluster$topography$ClusterDescriptionImpl$MementoImpl = ClusterDescriptionImpl.class$("com.ibm.ws.cluster.topography.ClusterDescriptionImpl$MementoImpl")) : class$com$ibm$ws$cluster$topography$ClusterDescriptionImpl$MementoImpl).getName() + ".<init>", "863", this);
                    if (!tc.isEventEnabled()) break block3;
                    Tr.event(tc, "unexpected", exception);
                }
            }
        }

        public long getStructuralEpoch() {
            return this.m_epoch;
        }

        public Iterator getClusterMembers() {
            return this.m_members.values().iterator();
        }

        public Map getMembers() {
            return this.m_members;
        }

        public Set getMemberEntrySet() {
            return this.m_members.entrySet();
        }

        public Map getWeightTable() {
            HashMap hashMap = new HashMap(this.m_weightTable);
            hashMap.putAll(this.m_disembodiedWeightTable);
            return hashMap;
        }

        public int getWeightTableEntry(DescriptionKey descriptionKey) {
            if (!this.m_members.containsKey(descriptionKey)) {
                throw new IllegalArgumentException("The passed in member (" + descriptionKey + ") is not part of this cluster (" + ClusterDescriptionImpl.this.getKey() + ").");
            }
            int n = 2;
            Integer n2 = (Integer)this.m_disembodiedWeightTable.get(descriptionKey);
            if (n2 == null) {
                n2 = (Integer)this.m_weightTable.get(descriptionKey);
            }
            if (n2 != null) {
                n = n2;
            }
            return n;
        }

        public ClusterDescription getBackupCluster() {
            return this.m_backupCluster;
        }

        public SelectionDescription getSelectionDescription() {
            return this.m_selection;
        }

        public long getInfluentialEpoch() {
            return this.m_influentialEpoch;
        }

        public byte[] getClusterScopedData(DescriptionKey descriptionKey) {
            return (byte[])this.m_clusterScopedData.get(descriptionKey);
        }

        public Set getClusterScopedData() {
            return this.m_clusterScopedData.entrySet();
        }

        public boolean isQuiesced(Identity identity) {
            return this.m_quiesceState.containsKey(identity);
        }

        public Map getQuiesceState() {
            return this.m_quiesceState;
        }

        public byte getState() {
            int n = 3;
            Iterator iterator = this.getClusterMembers();
            while (iterator.hasNext()) {
                ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)iterator.next();
                byte by = ((ClusterMemberDescription.Memento)clusterMemberDescription.getMemento()).getState();
                if (by == 0) {
                    n = 0;
                    break;
                }
                if (by != 9) continue;
                n = 9;
            }
            return (byte)n;
        }

        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[").append(super.toString());
            stringBuffer.append(" se:").append(this.m_epoch);
            stringBuffer.append(" ie:").append(this.m_influentialEpoch);
            stringBuffer.append(" members ").append(this.m_members == null ? null : this.m_members.keySet());
            stringBuffer.append(" cluster data ").append(this.m_clusterScopedData);
            stringBuffer.append(" backup cluster ").append(this.m_backupCluster);
            stringBuffer.append(" quiesce state ").append(this.m_quiesceState);
            stringBuffer.append(" cluster weight table ").append(this.m_weightTable);
            stringBuffer.append(" disembodied weight table ").append(this.m_disembodiedWeightTable);
            return stringBuffer.append(']').toString();
        }
    }
}

