/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.commons.logging;

import com.ibm.ejs.ras.MessageEvent6;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent6;
import org.apache.commons.logging.Log;

public final class TrLog
implements Log {
    private TraceComponent tc = null;
    private static final String ibm = "IBM";
    private static final String webSphere = "WebSphere";
    private static final String method = "";
    private String component = null;
    private static final String className = "";

    public TrLog(String string, String string2) {
        this.component = string2;
        this.tc = Tr.register(string, string2, null);
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.trace(5, String.valueOf(object));
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.trace(5, String.valueOf(object));
            this.trace(5, throwable);
        }
    }

    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.trace(2, String.valueOf(object));
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.trace(2, String.valueOf(object));
            this.trace(2, throwable);
        }
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.log(11, String.valueOf(object));
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(11, String.valueOf(object));
            this.log(11, throwable);
        }
    }

    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.log(10, String.valueOf(object));
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.log(10, String.valueOf(object));
            this.log(10, throwable);
        }
    }

    public void error(Object object) {
        if (this.isErrorEnabled()) {
            this.log(4, String.valueOf(object));
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(4, String.valueOf(object));
            this.log(4, throwable);
        }
    }

    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.log(8, String.valueOf(object));
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.log(8, String.valueOf(object));
            this.log(8, throwable);
        }
    }

    public boolean isTraceEnabled() {
        return this.tc.isEventEnabled();
    }

    public boolean isDebugEnabled() {
        return this.tc.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.tc.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.tc.isWarningEnabled();
    }

    public boolean isErrorEnabled() {
        return this.tc.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.tc.isFatalEnabled();
    }

    private void log(int n, String string) {
        try {
            MessageEvent6 messageEvent6 = new MessageEvent6(n, this.tc, string, null, null, ibm, webSphere, this.component, "", "", null);
            Tr.logJrasEvent((MessageEvent6)messageEvent6);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void log(int n, Throwable throwable) {
        try {
            String string = "com.ibm.ejs.resources.RasMessages";
            String string2 = RasHelper.throwableToString(throwable);
            MessageEvent6 messageEvent6 = new MessageEvent6(n, this.tc, "MSG_EXCEPTION_LOGGED", string, string2, ibm, webSphere, this.component, "", "", string2);
            Tr.logJrasEvent((MessageEvent6)messageEvent6);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private void trace(int n, String string) {
        try {
            TraceEvent6 traceEvent6 = new TraceEvent6(n, this.tc, string, null, ibm, webSphere, this.component, "", "", null);
            Tr.logJrasEvent((TraceEvent6)traceEvent6);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void trace(int n, Throwable throwable) {
        try {
            String string = RasHelper.throwableToString(throwable);
            TraceEvent6 traceEvent6 = new TraceEvent6(n, this.tc, "The following exception was logged", (Object)string, ibm, webSphere, this.component, "", "", string);
            Tr.logJrasEvent((TraceEvent6)traceEvent6);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }
}

